/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.properties;

import java.util.ArrayList;
import java.util.Collections;
import javax.xml.namespace.QName;
import org.eclipse.bpel.common.ui.flatui.FlatFormAttachment;
import org.eclipse.bpel.common.ui.flatui.FlatFormData;
import org.eclipse.bpel.model.Assign;
import org.eclipse.bpel.model.BPELFactory;
import org.eclipse.bpel.model.Copy;
import org.eclipse.bpel.model.From;
import org.eclipse.bpel.model.Query;
import org.eclipse.bpel.model.To;
import org.eclipse.bpel.model.Variable;
import org.eclipse.bpel.model.messageproperties.Property;
import org.eclipse.bpel.model.util.BPELUtils;
import org.eclipse.bpel.model.util.XSD2XMLGenerator;
import org.eclipse.bpel.ui.Messages;
import org.eclipse.bpel.ui.adapters.IVirtualCopyRuleSide;
import org.eclipse.bpel.ui.commands.InsertCopyCommand;
import org.eclipse.bpel.ui.details.providers.ModelTreeLabelProvider;
import org.eclipse.bpel.ui.details.providers.VariableTreeContentProvider;
import org.eclipse.bpel.ui.details.tree.ITreeNode;
import org.eclipse.bpel.ui.properties.AssignCategoryBase;
import org.eclipse.bpel.ui.properties.BPELPropertySection;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.bpel.ui.util.XSDUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFeature;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.impl.XSDTypeDefinitionImpl;

public class VariablePartAssignCategory
extends AssignCategoryBase {
    Label fNameLabel;
    Text fNameText;
    Tree fVariableTree;
    TreeViewer fVariableViewer;
    VariableTreeContentProvider variableContentProvider;
    Shell shell;

    protected VariablePartAssignCategory(BPELPropertySection anOwnerSection) {
        super(anOwnerSection);
    }

    @Override
    public String getName() {
        return Messages.VariablePartAssignCategory_Variable_or_Part_1;
    }

    protected boolean isPropertyTree() {
        return false;
    }

    protected void updateQueryFieldFromTreeSelection() {
        if (!this.displayQuery() || this.fChangeHelper.isNonUserChange() || this.fModelObject == null || this.fModelObject.eContainer() == null) {
            return;
        }
        IStructuredSelection sel = (IStructuredSelection)this.fVariableViewer.getSelection();
        Object[] path = this.variableContentProvider.getPathToRoot(sel.getFirstElement());
        StringBuilder builder = new StringBuilder();
        ArrayList<String> querySegments = new ArrayList<String>();
        Object[] objectArray = path;
        int n = path.length;
        int n2 = 0;
        while (n2 < n) {
            Object next = objectArray[n2];
            Object eObj = BPELUtil.resolveXSDObject(BPELUtil.adapt(next, ITreeNode.class).getModelObject());
            builder.setLength(0);
            String targetNamespace = null;
            String namespacePrefix = null;
            if (eObj instanceof XSDAttributeDeclaration) {
                XSDAttributeDeclaration att = (XSDAttributeDeclaration)eObj;
                targetNamespace = att.getTargetNamespace();
                builder.append("/@");
                if (targetNamespace != null) {
                    namespacePrefix = BPELUtil.lookupOrCreateNamespacePrefix(this.fModelObject, targetNamespace, "xsd", this.shell);
                    if (namespacePrefix == null) break;
                    builder.append(namespacePrefix).append(":");
                }
                builder.append(att.getName());
            } else if (eObj instanceof XSDElementDeclaration) {
                XSDElementDeclaration elm = (XSDElementDeclaration)eObj;
                targetNamespace = elm.getTargetNamespace();
                int maxOccurs = XSDUtils.getMaxOccurs((XSDFeature)elm);
                builder.append("/");
                if (targetNamespace != null) {
                    namespacePrefix = BPELUtil.lookupOrCreateNamespacePrefix(this.fModelObject, targetNamespace, "xsd", this.shell);
                    if (namespacePrefix == null) break;
                    builder.append(namespacePrefix).append(":");
                }
                builder.append(elm.getName());
                if (maxOccurs != 1) {
                    builder.append("[1]");
                }
            }
            if (builder.length() > 0) {
                querySegments.add(builder.toString());
            }
            ++n2;
        }
        Collections.reverse(querySegments);
        builder.setLength(0);
        for (String s : querySegments) {
            builder.append(s);
        }
        if (builder.length() > 0) {
            builder.deleteCharAt(0);
        }
        try {
            this.fChangeHelper.startNonUserChange();
            this.fNameText.setText(builder.toString());
            this.fNameText.setEnabled(true);
            this.fNameLabel.setEnabled(true);
        }
        finally {
            this.fChangeHelper.finishNonUserChange();
        }
    }

    @Override
    protected void createClient2(Composite parent) {
        FlatFormData data;
        this.fVariableTree = this.fWidgetFactory.createTree(parent, 0);
        if (this.displayQuery()) {
            this.fNameLabel = this.fWidgetFactory.createLabel(parent, Messages.VariablePartAssignCategory_Query__8);
            this.fNameText = this.fWidgetFactory.createText(parent, "");
            data = new FlatFormData();
            data.left = new FlatFormAttachment(0, BPELUtil.calculateLabelWidth((Widget)this.fNameText, 105));
            data.right = new FlatFormAttachment(100, -5);
            data.bottom = new FlatFormAttachment(100, 0);
            data.top = new FlatFormAttachment(100, -1 * (this.fNameText.getLineHeight() + 4 * this.fNameText.getBorderWidth()) - 4);
            this.fNameText.setLayoutData((Object)data);
            this.fChangeHelper.startListeningTo(new Control[]{this.fNameText});
            this.fChangeHelper.startListeningForEnter(new Control[]{this.fNameText});
            data = new FlatFormData();
            data.left = new FlatFormAttachment(0, 0);
            data.right = new FlatFormAttachment((Control)this.fNameText, -5);
            data.top = new FlatFormAttachment((Control)this.fNameText, 0, 0x1000000);
            this.fNameLabel.setLayoutData((Object)data);
        }
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 0);
        data.top = new FlatFormAttachment(0, 0);
        data.right = new FlatFormAttachment(100, 0);
        data.bottom = this.displayQuery() ? new FlatFormAttachment((Control)this.fNameText, -4, 128) : new FlatFormAttachment(100, 0);
        this.fVariableTree.setLayoutData((Object)data);
        this.variableContentProvider = new VariableTreeContentProvider(true, this.isPropertyTree(), this.displayQuery());
        this.fVariableViewer = new TreeViewer(this.fVariableTree);
        this.fVariableViewer.setContentProvider((IContentProvider)this.variableContentProvider);
        this.fVariableViewer.setLabelProvider((IBaseLabelProvider)new ModelTreeLabelProvider());
        this.fVariableViewer.setInput(this.fOwnerSection.getModel());
        this.fVariableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                VariablePartAssignCategory.this.updateQueryFieldFromTreeSelection();
            }
        });
        this.fChangeHelper.startListeningTo(new Control[]{this.fVariableTree});
    }

    @Override
    public boolean isCategoryForModel(EObject aModel) {
        if (aModel == null) {
            return false;
        }
        IVirtualCopyRuleSide side = BPELUtil.adapt((Object)aModel, IVirtualCopyRuleSide.class);
        if (side == null) {
            return false;
        }
        return side.getVariable() != null && side.getProperty() != null == this.isPropertyTree();
    }

    @Override
    protected void load(IVirtualCopyRuleSide side) {
        Object[] items;
        this.fChangeHelper.startNonUserChange();
        try {
            this.fVariableViewer.setSelection((ISelection)StructuredSelection.EMPTY, false);
            if (this.displayQuery()) {
                this.fNameText.setText("");
                this.fNameText.setEnabled(true);
                this.fNameLabel.setEnabled(true);
            }
        }
        finally {
            this.fChangeHelper.finishNonUserChange();
        }
        ArrayList<ITreeNode> pathToNode = new ArrayList<ITreeNode>();
        ITreeNode node = null;
        Object context = side.getVariable();
        if (context != null && (node = this.variableContentProvider.findModelNode(items = this.variableContentProvider.getElements(this.fVariableViewer.getInput()), context, 0)) != null) {
            pathToNode.add(node);
        }
        context = this.isPropertyTree() ? side.getProperty() : side.getPart();
        if (node != null && context != null && (node = this.variableContentProvider.findModelNode(items = this.variableContentProvider.getChildren(node), context, this.variableContentProvider.isCondensed() ? 0 : 1)) != null) {
            pathToNode.add(node);
        }
        if (context == null) {
            context = side.getVariable();
        }
        String query = null;
        if (node != null && context != null) {
            Query queryObject = side.getQuery();
            if (queryObject != null) {
                query = queryObject.getValue();
            }
            if (query != null && !query.equals("")) {
                int tokenCount = 0;
                String[] stringArray = query.split("\\/");
                int n = stringArray.length;
                int n2 = 0;
                block6: while (n2 < n) {
                    String token = stringArray[n2];
                    ++tokenCount;
                    if (token.length() == 0) {
                        if (tokenCount != 1) break;
                    } else {
                        Object[] items2;
                        QueryStep step = new QueryStep(token);
                        step.updateNamespaceURI(this.fModelObject);
                        if (!step.fAxis.equals("child")) break;
                        Object[] objectArray = items2 = this.variableContentProvider.getChildren(node);
                        int n3 = items2.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Object item = objectArray[n4];
                            Object originalMatch = ((ITreeNode)item).getModelObject();
                            Object match = BPELUtil.resolveXSDObject(originalMatch);
                            if (match instanceof XSDElementDeclaration) {
                                XSDElementDeclaration elmDecl = (XSDElementDeclaration)match;
                                if (this.match(step, (XSDNamedComponent)elmDecl)) {
                                    node = this.variableContentProvider.findModelNode(items2, originalMatch, 0);
                                    if (node == null) break block6;
                                    pathToNode.add(node);
                                    break;
                                }
                            } else if (match instanceof XSDAttributeDeclaration) {
                                XSDAttributeDeclaration attrDecl = (XSDAttributeDeclaration)match;
                                if (!this.match(step, (XSDNamedComponent)attrDecl) || (node = this.variableContentProvider.findModelNode(items2, originalMatch, 0)) == null) break block6;
                                pathToNode.add(node);
                                break block6;
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
        }
        if (pathToNode.size() > 0) {
            node = (ITreeNode)pathToNode.get(pathToNode.size() - 1);
        }
        if (node != null) {
            this.fChangeHelper.startNonUserChange();
            try {
                if (this.displayQuery()) {
                    this.fNameText.setText(query == null ? "" : query);
                }
                this.fVariableViewer.expandToLevel((Object)node, 0);
                this.fVariableViewer.setSelection((ISelection)new StructuredSelection((Object)node), true);
            }
            finally {
                this.fChangeHelper.finishNonUserChange();
            }
        }
    }

    boolean match(QueryStep step, XSDNamedComponent xsdNamed) {
        if (!step.fLocalPart.equals(xsdNamed.getName())) {
            return false;
        }
        return step.fNamespaceURI.equals(xsdNamed.getTargetNamespace()) || step.fNamespaceURI.equals("") && xsdNamed.getTargetNamespace() == null;
    }

    @Override
    protected void store(IVirtualCopyRuleSide side) {
        IStructuredSelection sel = (IStructuredSelection)this.fVariableViewer.getSelection();
        Object[] path = this.variableContentProvider.getPathToRoot(sel.getFirstElement());
        String query = this.displayQuery() ? this.fNameText.getText() : "";
        side.setVariable(null);
        side.setPart(null);
        side.setProperty(null);
        side.setQuery(null);
        Object[] objectArray = path;
        int n = path.length;
        int n2 = 0;
        while (n2 < n) {
            Object n3 = objectArray[n2];
            ITreeNode treeNode = BPELUtil.adapt(n3, ITreeNode.class);
            Object model = treeNode.getModelObject();
            if (model instanceof Variable) {
                side.setVariable((Variable)model);
            }
            if (model instanceof Part) {
                side.setPart((Part)model);
            }
            if (model instanceof Property) {
                side.setProperty((Property)model);
            }
            ++n2;
        }
        query = query.trim();
        if (this.displayQuery() && query.length() > 0) {
            Query queryObject = BPELFactory.eINSTANCE.createQuery();
            queryObject.setQueryLanguage("urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0");
            queryObject.setValue(query);
            side.setQuery(queryObject);
        } else {
            side.setQuery(null);
        }
        if (side.isSource()) {
            return;
        }
        if (query == null) {
            return;
        }
        Variable var = side.getVariable();
        if (this.needInitializer(var, side) && MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Initializer", (String)NLS.bind((String)"Variable {0} doesn't have initializer. Should it be generated?", (Object[])new Object[]{var.getName()}))) {
            this.initTargetVariable(var, side);
        }
    }

    private boolean needInitializer(Variable var, IVirtualCopyRuleSide side) {
        XSDElementDeclaration element;
        XSDTypeDefinitionImpl type;
        XSDElementDeclaration declaration;
        Assign a = (Assign)((To)side.getCopyRuleSide()).getContainer().getContainer();
        EList list = a.getCopy();
        for (Copy copy : list) {
            Part p;
            To to;
            Variable v;
            if (copy.getFrom().getLiteral() == null || (v = (to = copy.getTo()).getVariable()) == null || !v.equals(var) || (p = to.getPart()) == null || !p.equals(side.getPart())) continue;
            return false;
        }
        String rootElement = null;
        String uriWSDL = null;
        Message msg = var.getMessageType();
        if (msg != null && !msg.eIsProxy() && side.getPart() != null && (declaration = side.getPart().getElementDeclaration()) != null) {
            uriWSDL = declaration.getSchema().getSchemaLocation();
            rootElement = declaration.getName();
        }
        if ((type = (XSDTypeDefinitionImpl)var.getType()) != null && !type.eIsProxy()) {
            QName qname = new QName(type.getTargetNamespace(), type.getName());
            rootElement = qname.getLocalPart();
            uriWSDL = type.eResource().getURI().toString();
        }
        if ((element = var.getXSDElement()) != null && !element.eIsProxy()) {
            QName qname = new QName(element.getTargetNamespace(), element.getName());
            rootElement = qname.getLocalPart();
            uriWSDL = element.eResource().getURI().toString();
        }
        return rootElement != null && uriWSDL != null;
    }

    private void initTargetVariable(Variable var, IVirtualCopyRuleSide side) {
        XSDElementDeclaration element;
        XSDTypeDefinition type;
        XSDElementDeclaration declaration;
        String rootElement = null;
        String uriWSDL = null;
        Message msg = var.getMessageType();
        if (msg != null && side.getPart() != null && (declaration = side.getPart().getElementDeclaration()) != null) {
            uriWSDL = declaration.getSchema().getSchemaLocation();
            rootElement = declaration.getName();
        }
        if ((type = var.getType()) != null) {
            QName qname = new QName(type.getTargetNamespace(), type.getName());
            rootElement = qname.getLocalPart();
            uriWSDL = type.eResource().getURI().toString();
        }
        if ((element = var.getXSDElement()) != null) {
            QName qname = new QName(element.getTargetNamespace(), element.getName());
            rootElement = qname.getLocalPart();
            uriWSDL = element.eResource().getURI().toString();
        }
        if (rootElement == null || uriWSDL == null) {
            return;
        }
        XSD2XMLGenerator generator = new XSD2XMLGenerator(uriWSDL, rootElement);
        if (side.getQuery() != null && side.getQuery().getValue().trim().length() > 0) {
            generator.setQueryPath(side.getQuery().getValue());
        }
        try {
            String literal = generator.createXML();
            Copy copy = BPELFactory.eINSTANCE.createCopy();
            Assign a = (Assign)((To)side.getCopyRuleSide()).getContainer().getContainer();
            this.getCommandFramework().execute(this.wrapInShowContextCommand((Command)new InsertCopyCommand(a, copy, 0)));
            To to = BPELFactory.eINSTANCE.createTo();
            From from = BPELFactory.eINSTANCE.createFrom();
            from.setLiteral(literal);
            copy.setFrom(from);
            to.setVariable(side.getVariable());
            to.setPart(side.getPart());
            copy.setTo(to);
            this.fChangeHelper.startNonUserChange();
            this.fOwnerSection.basicSetInput((EObject)a);
            this.fChangeHelper.finishNonUserChange();
        }
        catch (Exception exception) {
            throw new IllegalStateException("Can't generate initializer, check WSDL file");
        }
    }

    @Override
    protected void basicSetInput(EObject newInput) {
        super.basicSetInput(newInput);
        EObject container = newInput.eContainer();
        if (container instanceof Variable) {
            this.fChangeHelper.startNonUserChange();
            try {
                this.fVariableViewer.setInput((Object)container);
            }
            finally {
                this.fChangeHelper.finishNonUserChange();
            }
        }
    }

    @Override
    public Object getUserContext() {
        return null;
    }

    @Override
    public void restoreUserContext(Object userContext) {
        this.fVariableTree.setFocus();
    }

    private boolean displayQuery() {
        return !this.isPropertyTree();
    }

    class QueryStep {
        String fAxis = "child";
        String fPrefix = "";
        String fLocalPart = "";
        String fNamespaceURI = "";

        QueryStep(String step) {
            int qnameMark;
            int axisMark = step.indexOf("::");
            if (axisMark >= 0) {
                this.fAxis = step.substring(0, axisMark);
                step = step.substring(axisMark + 2);
            }
            if ((qnameMark = step.indexOf(":")) < 0) {
                this.fLocalPart = step;
            } else {
                this.fLocalPart = step.substring(qnameMark + 1);
                this.fPrefix = step.substring(0, qnameMark);
            }
            if (this.fLocalPart.charAt(0) == '@') {
                this.fLocalPart = this.fLocalPart.substring(1);
            }
            int arrayMark1 = this.fLocalPart.indexOf(91);
            int arrayMark2 = this.fLocalPart.indexOf(93);
            if (arrayMark2 > arrayMark1 && arrayMark1 > 0) {
                this.fLocalPart = this.fLocalPart.substring(0, arrayMark1);
            }
        }

        void updateNamespaceURI(EObject eObj) {
            if (this.fPrefix.length() > 0) {
                this.fNamespaceURI = BPELUtils.getNamespace((EObject)eObj, (String)this.fPrefix);
                if (this.fNamespaceURI == null) {
                    this.fNamespaceURI = "urn:unresolved:" + System.currentTimeMillis() + ":" + this.fPrefix;
                }
            } else {
                this.fNamespaceURI = "";
            }
        }
    }
}

