/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.model;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.ListResourceBundle;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class Messages {
    private static String DOT = ".";
    static final Map<String, Messages> BUNDLES = new HashMap<String, Messages>();
    static final ResourceBundle EMPTY_BUNDLE = new ListResourceBundle(){

        @Override
        protected Object[][] getContents() {
            return new Object[][]{{"empty", "empty"}};
        }
    };
    String fBundleName;
    ResourceBundle fBundle = EMPTY_BUNDLE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        Map<String, Messages> map = BUNDLES;
        synchronized (map) {
            BUNDLES.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Messages getMessages(String bundleName) {
        Messages msg = BUNDLES.get(bundleName);
        if (msg == null) {
            msg = new Messages(bundleName);
            Map<String, Messages> map = BUNDLES;
            synchronized (map) {
                BUNDLES.put(bundleName, msg);
            }
        }
        return msg;
    }

    static String keyFor(Class<?> clazz, String name) {
        String pName = clazz.getPackage().getName();
        return String.valueOf(pName) + DOT + name;
    }

    public Messages(String bundleName) {
        this.fBundleName = bundleName;
        String resourceName = String.valueOf(this.fBundleName.replace('.', '/')) + ".properties";
        URL resourceURL = this.getClass().getClassLoader().getResource(resourceName);
        if (resourceURL == null) {
            return;
        }
        try {
            this.fBundle = new PropertyResourceBundle(resourceURL.openStream());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public boolean containsKey(String key) {
        try {
            return this.fBundle.getString(key) != null;
        }
        catch (MissingResourceException mre) {
            return false;
        }
    }

    public String get(String key) {
        return this.get(key, 16);
    }

    private String get(String key, int level) {
        String value;
        try {
            value = this.fBundle.getString(key).trim();
            String newKey = this.aliasFrom(value);
            if (newKey != null) {
                if (level > 0) {
                    return this.get(newKey, level - 1);
                }
                return Messages.missingKey(newKey);
            }
        }
        catch (MissingResourceException e) {
            return Messages.missingKey(key);
        }
        return value;
    }

    public static final String missingKey(String key) {
        StringBuilder sb = new StringBuilder(64);
        sb.append("!!").append(key).append("! [0={0},1={1},2={2},3={3},4={4},5={5}]");
        return sb.toString();
    }

    public String get(String key, String def) {
        return this.get(key, def, 16);
    }

    String get(String key, String def, int level) {
        String value;
        try {
            value = this.fBundle.getString(key);
            String newKey = this.aliasFrom(value);
            if (newKey != null) {
                if (level > 0) {
                    return this.get(newKey, def, level - 1);
                }
                return def;
            }
        }
        catch (MissingResourceException e) {
            return def;
        }
        return value;
    }

    String aliasFrom(String value) {
        int len = value.length();
        if (len < 5) {
            return null;
        }
        char ch1 = value.charAt(0);
        char ch2 = value.charAt(1);
        char chL = value.charAt(len - 1);
        if (ch1 == '$' && ch2 == '{' && chL == '}') {
            return value.substring(2, len - 1);
        }
        return null;
    }
}

