/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.pde.plugin;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egf.common.helper.BundleHelper;
import org.eclipse.egf.core.pde.EGFPDEPlugin;
import org.eclipse.egf.core.pde.helper.PluginHelper;
import org.eclipse.egf.core.pde.internal.ui.ModelModification;
import org.eclipse.egf.core.pde.internal.ui.PDEModelUtility;
import org.eclipse.egf.core.pde.plugin.IPluginChangesCommand;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.plugin.WorkspacePluginModelBase;

public abstract class AbstractChangesCommand
implements IPluginChangesCommand {
    private String _bundleId;
    private IPluginModelBase _pluginModelBase;
    private IProject _project;

    public AbstractChangesCommand(IProject project) throws CoreException {
        Assert.isNotNull((Object)project);
        this._project = project;
        IPluginModelBase fakeModel = BundleHelper.getPluginModelBase((IProject)this._project);
        if (fakeModel == null) {
            throw new CoreException(EGFPDEPlugin.getDefault().newStatus(4, NLS.bind((String)"AbstractChangesCommand(..) _ project ''{0}'' is not a bundle project.", (Object)this._project.getModificationStamp()), null));
        }
    }

    public String getBundleId() {
        if (this._bundleId == null && this._pluginModelBase != null) {
            this._bundleId = BundleHelper.getBundleId((IPluginModelBase)this._pluginModelBase);
        }
        return this._bundleId;
    }

    public IPluginModelBase getPluginModelBase() {
        return this._pluginModelBase;
    }

    public void execute(IProgressMonitor monitor) throws CoreException {
        if (this._project.getFile("plugin.xml").exists()) {
            this.modifyExistingPlugin(monitor);
        } else {
            this.createNewPlugin(monitor);
        }
    }

    private void createNewPlugin(IProgressMonitor monitor) throws CoreException {
        IPluginModelBase fakeModel = BundleHelper.getPluginModelBase((IProject)this._project);
        if (fakeModel == null) {
            throw new CoreException(EGFPDEPlugin.getDefault().newStatus(4, NLS.bind((String)"AbstractChangesCommand.createNewPlugin(..) _ project ''{0}'' is not a bundle project.", (Object)this._project.getModificationStamp()), null));
        }
        WorkspacePluginModelBase pluginModel = PluginHelper.createWorkspacePluginModelBase(fakeModel);
        if (pluginModel == null) {
            return;
        }
        this._pluginModelBase = pluginModel;
        this.doExecute(monitor);
        pluginModel.save();
        PluginHelper.updateBuildFile(pluginModel);
    }

    private void modifyExistingPlugin(final IProgressMonitor monitor) {
        EGFPDEPlugin.getDisplay().asyncExec(new Runnable(){

            public void run() {
                ModelModification updateOperation = new ModelModification(AbstractChangesCommand.this._project.getFile("plugin.xml")){

                    protected void modifyModel(IBaseModel model, IProgressMonitor innerMonitor) throws CoreException {
                        if (model == null) {
                            return;
                        }
                        if (!(model instanceof IPluginModelBase)) {
                            return;
                        }
                        AbstractChangesCommand.this._pluginModelBase = (IPluginModelBase)model;
                        AbstractChangesCommand.this.doExecute(innerMonitor);
                    }
                };
                PDEModelUtility.modifyModel(updateOperation, monitor);
            }
        });
    }

    protected abstract void doExecute(IProgressMonitor var1) throws CoreException;
}

