/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.examples.chess.features;

import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.graphiti.examples.chess.Messages;
import org.eclipse.graphiti.examples.chess.MoveUtil;
import org.eclipse.graphiti.examples.chess.diagram.ChessToolBehaviorProvider;
import org.eclipse.graphiti.examples.mm.chess.Piece;
import org.eclipse.graphiti.examples.mm.chess.Square;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.impl.AddConnectionContext;
import org.eclipse.graphiti.features.impl.AbstractCreateConnectionFeature;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.BoxRelativeAnchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public class CreateChessMoveFeature
extends AbstractCreateConnectionFeature {
    public CreateChessMoveFeature(IFeatureProvider fp) {
        super(fp, Messages.CreateChessMoveFeature_name, Messages.CreateChessMoveFeature_description);
    }

    public boolean canStartConnection(ICreateConnectionContext context) {
        Piece piece = this.getPiece(context.getSourceAnchor());
        return piece != null;
    }

    public boolean canCreate(ICreateConnectionContext context) {
        Piece piece = this.getPiece(context.getSourceAnchor());
        if (piece == null) {
            return false;
        }
        Square sourceSquare = this.getSquare(context.getSourceAnchor());
        if (sourceSquare == null) {
            return false;
        }
        Square targetSquare = this.getSquare(context.getTargetAnchor());
        if (targetSquare == null) {
            return false;
        }
        return MoveUtil.isMoveAllowed(piece, sourceSquare, targetSquare);
    }

    public Connection create(ICreateConnectionContext context) {
        this.takeBackHighlighting();
        Connection newConnection = null;
        Anchor sourceAnchor = context.getSourceAnchor();
        Square sourceSquare = this.getPiece(sourceAnchor).getSquare();
        Square targetSquare = this.getSquare(context.getTargetAnchor());
        if (sourceSquare != null && targetSquare != null) {
            AddConnectionContext addContext;
            AnchorContainer parent = sourceAnchor.getParent();
            if (parent instanceof ContainerShape) {
                addContext = new AddConnectionContext(this.getSquareConnectionAnchor(sourceAnchor), this.getSquareConnectionAnchor(context.getTargetAnchor()));
            } else if (parent instanceof Connection) {
                addContext = new AddConnectionContext(((Connection)parent).getEnd(), this.getSquareConnectionAnchor(context.getTargetAnchor()));
            } else {
                throw new IllegalStateException("Parent in neither a ContainerShape nor a Connection: " + parent);
            }
            addContext.putProperty((Object)"move", (Object)Boolean.TRUE);
            newConnection = (Connection)this.getFeatureProvider().addIfPossible((IAddContext)addContext);
        }
        return newConnection;
    }

    public void attachedToSource(ICreateConnectionContext context) {
        Piece piece = this.getPiece(context.getSourceAnchor());
        if (piece == null) {
            return;
        }
        Square sourceSquare = this.getSquare(context.getSourceAnchor());
        if (sourceSquare == null) {
            return;
        }
        this.showFeedback(context);
    }

    public void canceledAttaching(ICreateConnectionContext context) {
        this.takeBackHighlighting();
    }

    private void takeBackHighlighting() {
        ChessToolBehaviorProvider toolBehaviorProvider = (ChessToolBehaviorProvider)this.getFeatureProvider().getDiagramTypeProvider().getCurrentToolBehaviorProvider();
        toolBehaviorProvider.clearAllowedSquaresForMove();
        this.getDiagramBehavior().refresh();
    }

    private void showFeedback(ICreateConnectionContext context) {
        Piece piece = this.getPiece(context.getSourceAnchor());
        if (piece == null) {
            return;
        }
        Square sourceSquare = this.getSquare(context.getSourceAnchor());
        if (sourceSquare == null) {
            return;
        }
        EList<Square> allSquares = sourceSquare.getBoard().getSquares();
        ArrayList<Square> allowedSquares = new ArrayList<Square>();
        for (Square square : allSquares) {
            if (!MoveUtil.isMoveAllowed(piece, sourceSquare, square)) continue;
            allowedSquares.add(square);
        }
        ChessToolBehaviorProvider toolBehaviorProvider = (ChessToolBehaviorProvider)this.getFeatureProvider().getDiagramTypeProvider().getCurrentToolBehaviorProvider();
        toolBehaviorProvider.addToAllowedSquaresForMove(allowedSquares);
        for (Square square : allowedSquares) {
            PictogramElement pe = this.getFeatureProvider().getPictogramElementForBusinessObject((Object)square);
            this.getDiagramBehavior().refreshRenderingDecorators(pe);
        }
    }

    private Piece getPiece(Anchor anchor) {
        if (anchor != null) {
            AnchorContainer parent = anchor.getParent();
            Object obj = this.getBusinessObjectForPictogramElement((PictogramElement)parent);
            if (obj instanceof Piece) {
                return (Piece)obj;
            }
            if (obj instanceof Square) {
                Piece pieceOnSquare = ((Square)obj).getPiece();
                if (pieceOnSquare != null) {
                    return pieceOnSquare;
                }
                EList incomingConnections = anchor.getIncomingConnections();
                for (Connection connection : incomingConnections) {
                    Piece piece = this.getPiece(connection.getStart());
                    if (piece == null) continue;
                    return piece;
                }
            } else if (parent instanceof Connection) {
                Anchor startAnchor = ((Connection)parent).getStart();
                return this.getPiece(startAnchor);
            }
        }
        return null;
    }

    private Square getSquare(Anchor anchor) {
        if (anchor != null) {
            AnchorContainer parent = anchor.getParent();
            Object obj = this.getBusinessObjectForPictogramElement((PictogramElement)parent);
            if (obj instanceof Square) {
                return (Square)obj;
            }
            if (obj instanceof Piece) {
                return ((Piece)obj).getSquare();
            }
            if (parent instanceof Connection) {
                Anchor startAnchor = ((Connection)parent).getEnd();
                return this.getSquare(startAnchor);
            }
        }
        return null;
    }

    private Anchor getSquareConnectionAnchor(Anchor anchor) {
        if (anchor != null) {
            AnchorContainer parent = anchor.getParent();
            if (parent instanceof ContainerShape) {
                Object obj = this.getBusinessObjectForPictogramElement((PictogramElement)parent);
                if (obj instanceof Square) {
                    EList anchors = parent.getAnchors();
                    return this.findConnectionAnchor((EList<Anchor>)anchors);
                }
                if (obj instanceof Piece) {
                    EList anchors = ((ContainerShape)parent).getContainer().getAnchors();
                    return this.findConnectionAnchor((EList<Anchor>)anchors);
                }
            } else {
                throw new IllegalStateException("Parent shape is not a container shape");
            }
        }
        return null;
    }

    private Anchor findConnectionAnchor(EList<Anchor> anchors) {
        for (Anchor connectionAnchor : anchors) {
            if (!(connectionAnchor instanceof BoxRelativeAnchor)) continue;
            return connectionAnchor;
        }
        throw new IllegalStateException("No BoxRelativeAnchor found");
    }
}

