/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.base.scope;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.help.ICriteria;
import org.eclipse.help.IIndexEntry;
import org.eclipse.help.IIndexSee;
import org.eclipse.help.IToc;
import org.eclipse.help.ITopic;
import org.eclipse.help.IUAElement;
import org.eclipse.help.base.AbstractHelpScope;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.UAElement;
import org.eclipse.help.internal.base.util.CriteriaUtilities;
import org.eclipse.help.internal.criteria.CriteriaProviderRegistry;
import org.eclipse.help.internal.criteria.CriterionResource;
import org.eclipse.help.internal.workingset.AdaptableHelpResource;
import org.eclipse.help.internal.workingset.IHelpWorkingSetManager;
import org.eclipse.help.internal.workingset.WorkingSet;

public class WorkingSetScope
extends AbstractHelpScope {
    private static final String UNCATEGORIZED = "Uncategorized";
    private WorkingSet workingSet;
    private AdaptableHelpResource[] elements;
    private CriterionResource[] criteria;
    private String name;

    public WorkingSetScope(String scope, IHelpWorkingSetManager manager, String name) {
        this.workingSet = manager.getWorkingSet(scope);
        this.elements = this.workingSet.getElements();
        this.criteria = this.workingSet.getCriteria();
        this.name = name;
    }

    public WorkingSetScope(WorkingSet wset, String name) {
        this.workingSet = wset;
        this.elements = this.workingSet.getElements();
        this.criteria = this.workingSet.getCriteria();
        this.name = name;
    }

    @Override
    public boolean inScope(IToc toc) {
        if (HelpPlugin.getCriteriaManager().isCriteriaEnabled()) {
            return this.inContentScope(toc) && this.inCriteriaScope(toc);
        }
        return this.inContentScope(toc);
    }

    private boolean inContentScope(IToc toc) {
        int i = 0;
        while (i < this.elements.length) {
            AdaptableHelpResource adaptable = this.elements[i];
            while (adaptable != null) {
                IToc itoc = adaptable.getAdapter(IToc.class);
                if (toc == itoc) {
                    return true;
                }
                IAdaptable parent = adaptable.getParent();
                adaptable = parent instanceof AdaptableHelpResource ? (AdaptableHelpResource)parent : null;
            }
            ++i;
        }
        return false;
    }

    private boolean inCriteriaScope(IToc toc) {
        if (toc == null) {
            return this.criteria == null || this.criteria.length == 0;
        }
        ICriteria[] criteriaOfToc = CriteriaProviderRegistry.getInstance().getAllCriteria(toc);
        return this.isCriteriaInScope(criteriaOfToc);
    }

    private boolean isCriteriaInScope(ICriteria[] criteriaOfTopic) {
        if (this.criteria == null) {
            return true;
        }
        Map<String, Set<String>> ownCriteria = this.getCriteriaInfo(criteriaOfTopic);
        Map<String, Set<String>> scope = this.getCriteriaInfo(this.criteria);
        Iterator<String> keyIterator = scope.keySet().iterator();
        block0: while (keyIterator.hasNext()) {
            String key = String.valueOf(keyIterator.next());
            Iterator<String> valueIterator = scope.get(key).iterator();
            while (valueIterator.hasNext()) {
                String value = String.valueOf(valueIterator.next());
                if (!value.equals(UNCATEGORIZED) ? ownCriteria.get(key) != null && ownCriteria.get(key).contains(value) : !ownCriteria.containsKey(key)) continue block0;
            }
            return false;
        }
        return true;
    }

    private Map<String, Set<String>> getCriteriaInfo(CriterionResource[] criteria) {
        HashMap<String, Set<String>> criteriaMap = new HashMap<String, Set<String>>();
        CriteriaUtilities.addCriteriaToMap(criteriaMap, criteria);
        return criteriaMap;
    }

    private Map<String, Set<String>> getCriteriaInfo(ICriteria[] criteria) {
        HashMap<String, Set<String>> criteriaMap = new HashMap<String, Set<String>>();
        CriteriaUtilities.addCriteriaToMap(criteriaMap, criteria);
        return criteriaMap;
    }

    @Override
    public boolean inScope(ITopic topic) {
        if (HelpPlugin.getCriteriaManager().isCriteriaEnabled()) {
            return this.inContentScope(topic) && this.inCriteriaScope(topic);
        }
        return this.inContentScope(topic);
    }

    private boolean inContentScope(ITopic topic) {
        HashSet<Object> topics = new HashSet<Object>();
        IToc toc = null;
        topics.add(topic);
        if (topic instanceof UAElement) {
            UAElement uae = (UAElement)topic;
            while (uae != null) {
                if (uae instanceof IToc) {
                    toc = (IToc)uae;
                    uae = null;
                    continue;
                }
                if (uae instanceof IIndexEntry) {
                    return this.isHrefInScope(topic.getHref());
                }
                if (uae instanceof ITopic) {
                    topics.add(uae);
                }
                uae = uae.getParentElement();
            }
        }
        int i = 0;
        while (i < this.elements.length) {
            IToc itoc;
            AdaptableHelpResource adaptable = this.elements[i];
            if (toc != null && toc == (itoc = adaptable.getAdapter(IToc.class))) {
                return true;
            }
            ITopic itopic = adaptable.getAdapter(ITopic.class);
            if (topic != null && topics.contains(itopic)) {
                return true;
            }
            IAdaptable parent = adaptable.getParent();
            adaptable = parent instanceof AdaptableHelpResource ? (AdaptableHelpResource)parent : null;
            ++i;
        }
        return false;
    }

    private boolean isHrefInScope(String href) {
        int index = href.indexOf(35);
        String anchorlessHref = index != -1 ? href.substring(0, index) : href;
        AdaptableHelpResource[] adaptableHelpResourceArray = this.elements;
        int n = this.elements.length;
        int n2 = 0;
        while (n2 < n) {
            AdaptableHelpResource adaptable = adaptableHelpResourceArray[n2];
            if (adaptable.getTopic(anchorlessHref) != null) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean inCriteriaScope(ITopic topic) {
        if (topic == null) {
            return this.criteria == null || this.criteria.length == 0;
        }
        ICriteria[] criteriaOfTopic = CriteriaProviderRegistry.getInstance().getAllCriteria(topic);
        return this.isCriteriaInScope(criteriaOfTopic);
    }

    @Override
    public boolean inScope(IIndexEntry entry) {
        return this.hasInScopeChildren((IUAElement)entry);
    }

    @Override
    public boolean inScope(IIndexSee see) {
        return this.hasInScopeChildren((IUAElement)see);
    }

    @Override
    public String getName(Locale locale) {
        return this.name;
    }
}

