/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.feature;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.ui.editor.IDiagramContainerUI;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.dialog.SelectTypeDialog;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.i18n.JPAEditorMessages;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;

public class RefactorAttributeTypeFeature
extends AbstractCustomFeature {
    public RefactorAttributeTypeFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canExecute(ICustomContext context) {
        return true;
    }

    public void execute(ICustomContext context) {
        PictogramElement pe = context.getPictogramElements()[0];
        Object bo = this.getFeatureProvider().getBusinessObjectForPictogramElement(pe);
        if (bo == null || !(bo instanceof PersistentAttribute)) {
            return;
        }
        PersistentAttribute jpa = (PersistentAttribute)bo;
        String typeName = JPAEditorUtil.getAttributeTypeNameWithGenerics(jpa);
        String msg = MessageFormat.format(JPAEditorMessages.SelectTypeDialog_chooseAttributeTypeDialogText, jpa.getName(), JPAEditorUtil.returnSimpleName(((PersistentType)jpa.getParent()).getName()));
        SelectTypeDialog d = new SelectTypeDialog(msg, typeName);
        if (d.open() != 0) {
            return;
        }
        String newTypeName = d.getTypeName();
        String[] attributeTypeTypeNames = JPAEditorUtil.getGenericsElementTypes(newTypeName);
        if (attributeTypeTypeNames != null) {
            newTypeName = newTypeName.substring(0, newTypeName.indexOf(60)).trim();
        }
        this.getFeatureProvider().addAddIgnore((PersistentType)jpa.getParent(), jpa.getName());
        this.getFeatureProvider().addRemoveIgnore((PersistentType)jpa.getParent(), jpa.getName());
        String mappingKey = jpa.getMappingKey();
        List<String> annotations = JpaArtifactFactory.instance().getAnnotationStrings(jpa);
        JpaArtifactFactory.instance().deleteAttribute((PersistentType)jpa.getParent(), jpa.getName(), this.getFeatureProvider());
        PersistentAttribute newAt = JpaArtifactFactory.instance().makeNewAttribute((PersistentType)jpa.getParent(), jpa.getName(), newTypeName, jpa.getName(), newTypeName, attributeTypeTypeNames, annotations, false);
        this.getFeatureProvider().replaceAttribute(jpa, newAt);
        JpaArtifactFactory.instance().addOrmPersistentAttribute((PersistentType)newAt.getParent(), newAt, mappingKey);
        IWorkbenchPartSite ws = ((IDiagramContainerUI)this.getFeatureProvider().getDiagramTypeProvider().getDiagramBehavior().getDiagramContainer()).getSite();
        ICompilationUnit cu = this.getFeatureProvider().getCompilationUnit((PersistentType)newAt.getParent());
        this.getFeatureProvider().getJPAEditorUtil().formatCode(cu, (IWorkbenchSite)ws);
        JPAEditorUtil.organizeImports(cu, (IWorkbenchSite)ws);
        JpaArtifactFactory.instance().remakeRelations(this.getFeatureProvider(), ((Shape)pe).getContainer(), (PersistentType)newAt.getParent());
    }

    public IJPAEditorFeatureProvider getFeatureProvider() {
        return (IJPAEditorFeatureProvider)super.getFeatureProvider();
    }

    public String getName() {
        return JPAEditorMessages.RefactorAttributeTypeFeature_ContextMenuOperationDescription;
    }
}

