/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.utils.annotations;

import java.io.FileNotFoundException;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jst.ws.jaxws.utils.ContractChecker;
import org.eclipse.jst.ws.jaxws.utils.annotations.AnnotationGeneratorException;
import org.eclipse.jst.ws.jaxws.utils.annotations.IAnnotation;
import org.eclipse.jst.ws.jaxws.utils.annotations.IAnnotationInspector;
import org.eclipse.jst.ws.jaxws.utils.annotations.IParamValuePair;
import org.eclipse.jst.ws.jaxws.utils.annotations.IValue;
import org.eclipse.jst.ws.jaxws.utils.internal.annotations.impl.AnnotationImpl;
import org.eclipse.jst.ws.jaxws.utils.internal.annotations.impl.AnnotationInspectorImpl;
import org.eclipse.jst.ws.jaxws.utils.internal.annotations.impl.AnnotationUtils;
import org.eclipse.jst.ws.jaxws.utils.internal.annotations.impl.ArrayValueImpl;
import org.eclipse.jst.ws.jaxws.utils.internal.annotations.impl.BooleanValueImpl;
import org.eclipse.jst.ws.jaxws.utils.internal.annotations.impl.ClassValueImpl;
import org.eclipse.jst.ws.jaxws.utils.internal.annotations.impl.IntegerValueImpl;
import org.eclipse.jst.ws.jaxws.utils.internal.annotations.impl.ParamValuePairImpl;
import org.eclipse.jst.ws.jaxws.utils.internal.annotations.impl.QualifiedNameValueImpl;
import org.eclipse.jst.ws.jaxws.utils.internal.annotations.impl.StringValueImpl;
import org.eclipse.jst.ws.jaxws.utils.internal.text.JaxWsUtilMessages;
import org.eclipse.text.edits.MalformedTreeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationFactory {
    public static <T extends IJavaElement> IAnnotation<T> createAnnotation(String annotationQName, Set<IParamValuePair> paramValuePairs, T appliedElement) {
        if (annotationQName == null) {
            throw new NullPointerException("annotationQName should not be null!");
        }
        if (annotationQName.trim().length() == 0) {
            throw new IllegalArgumentException("annotationQName should not be empty String!");
        }
        if (paramValuePairs == null) {
            throw new NullPointerException("paramValuePairs should not be null!");
        }
        AnnotationImpl<T> impl = new AnnotationImpl<T>(annotationQName, paramValuePairs);
        impl.setJavaElement(appliedElement);
        return impl;
    }

    public static IAnnotation<? extends IJavaElement> createAnnotation(String annotationQName, IJavaElement appliedElement, Set<IParamValuePair> paramValuePairs) {
        ContractChecker.nullCheckParam(annotationQName, "annotationQName");
        if (annotationQName.trim().length() == 0) {
            throw new IllegalArgumentException("annotationQName should not be empty String!");
        }
        ContractChecker.nullCheckParam(paramValuePairs, "paramValuePairs");
        ContractChecker.nullCheckParam(appliedElement, "appliedElement");
        AnnotationImpl<IJavaElement> annotation = new AnnotationImpl<IJavaElement>(annotationQName, paramValuePairs);
        annotation.setAppliedElementWithoutSave(appliedElement);
        return annotation;
    }

    public static IParamValuePair createParamValuePairValue(String param, IValue value) {
        if (param == null) {
            throw new NullPointerException("param should not be null!");
        }
        if (param.trim().length() == 0) {
            throw new IllegalArgumentException("param should not be empty String!");
        }
        if (value == null) {
            throw new NullPointerException("value should not be null!");
        }
        return new ParamValuePairImpl(param, value);
    }

    public static IValue createArrayValue(Set<IValue> values) {
        if (values == null) {
            throw new NullPointerException("values should not be null!");
        }
        if (values.size() < 1) {
            throw new IllegalArgumentException("values should not be empty Set!");
        }
        return new ArrayValueImpl(values);
    }

    public static IValue createBooleanValue(boolean value) {
        return new BooleanValueImpl(value);
    }

    public static IValue createClassValue(String value) {
        if (value == null) {
            throw new NullPointerException("value should not be null!");
        }
        if (value.equals("")) {
            throw new IllegalArgumentException("value should not be empty String");
        }
        return new ClassValueImpl(value);
    }

    public static IValue createIntegerValue(String value) {
        return new IntegerValueImpl(value);
    }

    public static IValue createQualifiedNameValue(String qualifiedName) {
        if (qualifiedName == null) {
            throw new NullPointerException("qualifiedName should not be null!");
        }
        if (qualifiedName.trim().length() == 0 || qualifiedName.indexOf(46) == -1) {
            throw new IllegalArgumentException("qualifiedName is not in correct form!");
        }
        return new QualifiedNameValueImpl(qualifiedName);
    }

    public static IValue createStringValue(String value) {
        if (value == null) {
            throw new NullPointerException("value should not be null!");
        }
        return new StringValueImpl(value);
    }

    public static void removeAnnotationsFromJavaElement(IJavaElement javaElement) throws AnnotationGeneratorException {
        if (javaElement == null) {
            throw new NullPointerException("javaElement should not be null!");
        }
        if (!(javaElement instanceof IType || javaElement instanceof IMethod || javaElement instanceof IField || javaElement instanceof ITypeParameter)) {
            throw new IllegalArgumentException("javaElement is not of correct type!");
        }
        AnnotationFactory.removeAnnotations(javaElement, null);
    }

    public static void removeAnnotations(IJavaElement javaElement, Set<String> annotations) throws AnnotationGeneratorException {
        if (javaElement == null) {
            throw new NullPointerException("javaElement should not be null!");
        }
        if (!(javaElement instanceof IType || javaElement instanceof IMethod || javaElement instanceof IField || javaElement instanceof ITypeParameter)) {
            throw new IllegalArgumentException("javaElement is not of correct type!");
        }
        try {
            AnnotationUtils.getInstance().removeAnnotations(javaElement, annotations, true);
        }
        catch (JavaModelException e) {
            throw new AnnotationGeneratorException(e.getMessage(), e.getStatus().getMessage(), e);
        }
        catch (MalformedTreeException e) {
            throw new AnnotationGeneratorException(e.getMessage(), JaxWsUtilMessages.InvalidTreeStateMsg, e);
        }
        catch (FileNotFoundException e) {
            throw new AnnotationGeneratorException(e.getMessage(), JaxWsUtilMessages.CompUnitMissingMsg, e);
        }
        catch (CoreException e) {
            throw new AnnotationGeneratorException(e.getMessage(), e.getStatus().getMessage(), e);
        }
        catch (BadLocationException e) {
            throw new AnnotationGeneratorException(e.getMessage(), JaxWsUtilMessages.CannotPerformEditMsg, e);
        }
    }

    public static IAnnotationInspector createAnnotationInspector(IType type) {
        return new AnnotationInspectorImpl(type);
    }
}

