/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.framework.jonas;

import java.io.File;
import org.apache.tools.ant.DirectoryScanner;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.libra.framework.core.FrameworkInstanceConfiguration;
import org.eclipse.libra.framework.core.FrameworkInstanceDelegate;
import org.eclipse.libra.framework.core.OSGIFrameworkInstanceBehaviorDelegate;
import org.eclipse.libra.framework.core.TargetDefinitionUtil;
import org.eclipse.libra.framework.core.Trace;
import org.eclipse.libra.framework.jonas.IJonasFrameworkInstance;
import org.eclipse.libra.framework.jonas.IJonasVersionHandler;
import org.eclipse.libra.framework.jonas.JonasFramework;
import org.eclipse.libra.framework.jonas.Messages;
import org.eclipse.libra.framework.jonas.internal.JonasFrameworkInstanceBehavior;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;

public class JonasFrameworkInstance
extends FrameworkInstanceDelegate
implements IJonasFrameworkInstance {
    protected transient IJonasVersionHandler versionHandler;

    public IStatus canModifyModules(IModule[] add, IModule[] remove) {
        IStatus status = super.canModifyModules(add, remove);
        if (!status.isOK()) {
            return status;
        }
        if (this.getJonasVersionHandler() == null) {
            return new Status(4, "org.eclipse.libra.framework.jonas", 0, Messages.errorNoRuntime, null);
        }
        if (add != null) {
            int size = add.length;
            int i = 0;
            while (i < size) {
                IModule module = add[i];
                IStatus status2 = this.getJonasVersionHandler().canAddModule(module);
                if (status2 != null && !status2.isOK()) {
                    return status2;
                }
                ++i;
            }
        }
        return Status.OK_STATUS;
    }

    public void setDefaults(IProgressMonitor monitor) {
        super.setDefaults(monitor);
        try {
            this.getJonasConfiguration();
        }
        catch (CoreException e) {
            Trace.trace((byte)2, (String)"Can't setup for Felix configuration.", (Throwable)e);
        }
    }

    public void importRuntimeConfiguration(IRuntime runtime, IProgressMonitor monitor) throws CoreException {
        super.importRuntimeConfiguration(runtime, monitor);
        OSGIFrameworkInstanceBehaviorDelegate fsb = (OSGIFrameworkInstanceBehaviorDelegate)this.getServer().loadAdapter(JonasFrameworkInstanceBehavior.class, null);
        if (fsb != null) {
            IPath tempDir = fsb.getTempDirectory();
            if (!tempDir.isAbsolute()) {
                IPath rootPath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
                tempDir = rootPath.append(tempDir);
            }
            this.setInstanceDirectory(tempDir.toPortableString());
        }
        try {
            this.getJonasConfiguration();
        }
        catch (CoreException e) {
            Trace.trace((byte)2, (String)"Can't setup for Felix configuration.", (Throwable)e);
        }
    }

    public JonasFramework getJonasRuntime() {
        if (this.getServer().getRuntime() == null) {
            return null;
        }
        return (JonasFramework)this.getServer().getRuntime().loadAdapter(JonasFramework.class, null);
    }

    public IJonasVersionHandler getJonasVersionHandler() {
        if (this.versionHandler == null) {
            if (this.getServer().getRuntime() == null || this.getJonasRuntime() == null) {
                return null;
            }
            this.versionHandler = this.getJonasRuntime().getVersionHandler();
        }
        return this.versionHandler;
    }

    public FrameworkInstanceConfiguration getJonasConfiguration() throws CoreException {
        return this.getFrameworkInstanceConfiguration();
    }

    private ITargetLocation[] getDefaultBundleContainers(IPath installPath) {
        try {
            DirectoryScanner scanner = new DirectoryScanner();
            String baseDir = installPath.append("repositories/maven2-internal").toOSString();
            scanner.setBasedir(baseDir);
            scanner.setIncludes(new String[]{"**/*.jar"});
            scanner.scan();
            String[] bundles = scanner.getIncludedFiles();
            ITargetPlatformService service = TargetDefinitionUtil.getTargetPlatformService();
            if (bundles != null && bundles.length > 0) {
                ITargetLocation[] containers = new ITargetLocation[bundles.length];
                int i = 0;
                String[] stringArray = bundles;
                int n = bundles.length;
                int n2 = 0;
                while (n2 < n) {
                    String b = stringArray[n2];
                    File bundle = new File(b);
                    Path baseDirFile = new Path(baseDir);
                    containers[i] = service.newDirectoryLocation(baseDirFile.append(bundle.getParent()).toOSString());
                    ++i;
                    ++n2;
                }
                return containers;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return new ITargetLocation[0];
    }

    public ITargetDefinition createDefaultTarget() throws CoreException {
        IPath installPath = this.getServer().getRuntime().getLocation();
        ITargetPlatformService service = TargetDefinitionUtil.getTargetPlatformService();
        ITargetDefinition targetDefinition = service.newTarget();
        targetDefinition.setName(this.getServer().getName());
        ITargetLocation[] containers = this.getDefaultBundleContainers(installPath);
        targetDefinition.setTargetLocations(containers);
        service.saveTargetDefinition(targetDefinition);
        return targetDefinition;
    }
}

