/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.ui.explorer;

import org.eclipse.core.resources.IProject;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.ExternalProjectFragment;
import org.eclipse.dltk.internal.ui.navigator.ScriptExplorerContentProvider;
import org.eclipse.php.composer.core.ComposerPlugin;
import org.eclipse.php.composer.core.facet.FacetManager;
import org.eclipse.php.composer.core.log.Logger;
import org.eclipse.php.composer.core.model.PackagePath;
import org.eclipse.php.composer.ui.explorer.ComposerBuildpathContainer;

public class PackageTreeContentProvider
extends ScriptExplorerContentProvider {
    public PackageTreeContentProvider() {
        super(true);
    }

    public Object[] getChildren(Object parentElement) {
        if (!ComposerPlugin.getDefault().isBuildpathContainerEnabled()) {
            return null;
        }
        if (parentElement instanceof PackagePath) {
            PackagePath pPath = (PackagePath)parentElement;
            IScriptProject scriptProject = pPath.getProject();
            IBuildpathEntry entry = pPath.getEntry();
            try {
                IProjectFragment[] allProjectFragments;
                IProjectFragment[] iProjectFragmentArray = allProjectFragments = scriptProject.getAllProjectFragments();
                int n = allProjectFragments.length;
                int n2 = 0;
                while (n2 < n) {
                    ExternalProjectFragment external;
                    IProjectFragment fragment = iProjectFragmentArray[n2];
                    if (fragment instanceof ExternalProjectFragment && (external = (ExternalProjectFragment)fragment).getBuildpathEntry().equals(entry)) {
                        return super.getChildren((Object)external);
                    }
                    ++n2;
                }
            }
            catch (ModelException e) {
                Logger.logException((Throwable)e);
            }
        } else {
            if (parentElement instanceof ComposerBuildpathContainer) {
                ComposerBuildpathContainer container = (ComposerBuildpathContainer)((Object)parentElement);
                Object[] children = container.getChildren();
                if (children == null || children.length == 0) {
                    return NO_CHILDREN;
                }
                return children;
            }
            if (parentElement instanceof IScriptProject) {
                try {
                    IProject project = ((IScriptProject)parentElement).getProject();
                    if (FacetManager.hasComposerFacet((IProject)project)) {
                        return new Object[]{new ComposerBuildpathContainer((IScriptProject)parentElement)};
                    }
                }
                catch (Exception e) {
                    Logger.logException((Throwable)e);
                }
            }
        }
        return null;
    }
}

