/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.util;

import java.util.Optional;
import java.util.function.Function;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.scout.sdk.core.apidef.ApiVersion;
import org.eclipse.scout.sdk.core.apidef.IApiSpecification;
import org.eclipse.scout.sdk.core.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.s.apidef.IScoutApi;
import org.eclipse.scout.sdk.core.s.apidef.ScoutApi;
import org.eclipse.scout.sdk.s2e.environment.EclipseEnvironment;

public final class ApiHelper {
    private ApiHelper() {
    }

    public static IScoutApi requireScoutApiFor(IJavaElement context) {
        return ApiHelper.requireScoutApiFor(context, null);
    }

    public static IScoutApi requireScoutApiFor(IJavaElement context, EclipseEnvironment environment) {
        IJavaProject project = context.getJavaProject();
        return ApiHelper.applyWithEclipseEnvironment(e -> ApiHelper.requireApiFor(project, IScoutApi.class, e), environment);
    }

    public static Optional<ApiVersion> scoutVersionOf(IJavaElement context, EclipseEnvironment environment) {
        IJavaProject project = context.getJavaProject();
        return ApiHelper.applyWithEclipseEnvironment(e -> ScoutApi.version((IJavaEnvironment)e.toScoutJavaEnvironment(project)), environment);
    }

    static <T> T applyWithEclipseEnvironment(Function<EclipseEnvironment, T> task, EclipseEnvironment existingEnvironment) {
        if (existingEnvironment == null) {
            return (T)EclipseEnvironment.callInEclipseEnvironmentSync((e, p) -> task.apply((EclipseEnvironment)e), (IProgressMonitor)new NullProgressMonitor());
        }
        return task.apply(existingEnvironment);
    }

    public static <T extends IApiSpecification> T requireApiFor(IJavaProject project, Class<T> api, EclipseEnvironment environment) {
        return (T)ApiHelper.applyWithEclipseEnvironment(e -> e.toScoutJavaEnvironment(project).requireApi(api), environment);
    }

    public static Optional<IScoutApi> scoutApiFor(IJavaProject project) {
        return ApiHelper.scoutApiFor(project, null);
    }

    public static Optional<IScoutApi> scoutApiFor(IJavaProject project, EclipseEnvironment environment) {
        return ApiHelper.apiFor(project, IScoutApi.class, environment);
    }

    public static <T extends IApiSpecification> Optional<T> apiFor(IJavaProject project, Class<T> api) {
        return ApiHelper.apiFor(project, api, null);
    }

    public static <T extends IApiSpecification> Optional<T> apiFor(IJavaProject project, Class<T> api, EclipseEnvironment environment) {
        return ApiHelper.applyWithEclipseEnvironment(e -> e.toScoutJavaEnvironment(project).api(api), environment);
    }
}

