/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.core.IChartSettings;
import org.eclipse.swtchart.extensions.core.IPrimaryAxisSettings;
import org.eclipse.swtchart.extensions.core.ISecondaryAxisSettings;
import org.eclipse.swtchart.extensions.core.Messages;
import org.eclipse.swtchart.extensions.core.PrimaryAxisSettings;
import org.eclipse.swtchart.extensions.core.RangeRestriction;
import org.eclipse.swtchart.extensions.events.IHandledEventProcessor;
import org.eclipse.swtchart.extensions.events.MouseDownEvent;
import org.eclipse.swtchart.extensions.events.MouseMoveCursorEvent;
import org.eclipse.swtchart.extensions.events.MouseMoveSelectionEvent;
import org.eclipse.swtchart.extensions.events.MouseMoveShiftEvent;
import org.eclipse.swtchart.extensions.events.MouseUpEvent;
import org.eclipse.swtchart.extensions.events.MouseWheelEvent;
import org.eclipse.swtchart.extensions.events.ResetSeriesEvent;
import org.eclipse.swtchart.extensions.events.SelectDataPointEvent;
import org.eclipse.swtchart.extensions.events.SelectHideSeriesEvent;
import org.eclipse.swtchart.extensions.events.UndoRedoEvent;
import org.eclipse.swtchart.extensions.menu.IChartMenuEntry;
import org.eclipse.swtchart.extensions.menu.RedoSelectionHandler;
import org.eclipse.swtchart.extensions.menu.ResetChartHandler;
import org.eclipse.swtchart.extensions.menu.ResetSelectedSeriesHandler;
import org.eclipse.swtchart.extensions.menu.UndoSelectionHandler;
import org.eclipse.swtchart.extensions.menu.toggle.ToggleAxisZeroMarkerHandler;
import org.eclipse.swtchart.extensions.menu.toggle.ToggleLabelTooltipsHandler;
import org.eclipse.swtchart.extensions.menu.toggle.ToggleLegendMarkerHandler;
import org.eclipse.swtchart.extensions.menu.toggle.TogglePlotCenterMarkerHandler;
import org.eclipse.swtchart.extensions.menu.toggle.TogglePositionMarkerHandler;
import org.eclipse.swtchart.extensions.menu.toggle.ToggleRangeSelectorHandler;
import org.eclipse.swtchart.extensions.menu.toggle.ToggleSeriesLabelMarkerHandler;
import org.eclipse.swtchart.extensions.menu.toggle.ToggleSeriesLegendHandler;

public class ChartSettings
implements IChartSettings {
    private boolean bufferSelection = false;
    private boolean enableRangeSelector = false;
    private boolean showRangeSelectorInitially = true;
    private Color colorHintRangeSelector;
    private int rangeSelectorDefaultAxisX = 0;
    private int rangeSelectorDefaultAxisY = 0;
    private boolean verticalSliderVisible = false;
    private boolean horizontalSliderVisible = true;
    private String title = Messages.getString(Messages.CHART_TITLE);
    private boolean titleVisible = true;
    private Color titleColor;
    private Font titleFont;
    private int legendPosition = 131072;
    private boolean legendVisible = false;
    private boolean legendExtendedVisible = false;
    private IPrimaryAxisSettings primaryAxisSettingsX = new PrimaryAxisSettings(BaseChart.DEFAULT_TITLE_X_AXIS);
    private IPrimaryAxisSettings primaryAxisSettingsY = new PrimaryAxisSettings(BaseChart.DEFAULT_TITLE_Y_AXIS);
    private List<ISecondaryAxisSettings> secondaryAxisSettingsListX = new ArrayList<ISecondaryAxisSettings>();
    private List<ISecondaryAxisSettings> secondaryAxisSettingsListY = new ArrayList<ISecondaryAxisSettings>();
    private int orientation = 256;
    private Color background;
    private Color backgroundChart;
    private Color backgroundPlotArea;
    private boolean enableCompress = true;
    private RangeRestriction rangeRestriction = new RangeRestriction();
    private boolean showPositionMarker = false;
    private Color colorPositionMarker;
    private boolean showPlotCenterMarker = false;
    private Color colorPlotCenterMarker;
    private boolean showLegendMarker = false;
    private Color colorLegendMarker;
    private boolean showAxisZeroMarker = false;
    private Color colorAxisZeroMarker;
    private boolean showSeriesLabelMarker = false;
    private Color colorSeriesLabelMarker;
    private boolean createMenu = true;
    private Set<IChartMenuEntry> menuEntries;
    private Set<IHandledEventProcessor> handledEventProcessors;
    private boolean supportDataShift = false;
    private boolean enableTooltips = false;
    private final Font defaultFont = new Font((Device)Display.getDefault(), "Tahoma", 11, 1);

    public ChartSettings() {
        Display display = Display.getDefault();
        this.colorHintRangeSelector = display.getSystemColor(3);
        this.titleColor = display.getSystemColor(1);
        this.titleFont = this.defaultFont;
        this.background = display.getSystemColor(1);
        this.backgroundChart = display.getSystemColor(1);
        this.backgroundPlotArea = display.getSystemColor(1);
        this.rangeRestriction.setZeroX(true);
        this.rangeRestriction.setZeroY(true);
        this.rangeRestriction.setRestrictFrame(true);
        this.colorPositionMarker = display.getSystemColor(16);
        this.colorPlotCenterMarker = display.getSystemColor(16);
        this.colorLegendMarker = display.getSystemColor(16);
        this.colorAxisZeroMarker = display.getSystemColor(16);
        this.colorSeriesLabelMarker = display.getSystemColor(16);
        this.menuEntries = new HashSet<IChartMenuEntry>();
        this.menuEntries.add(new ResetChartHandler());
        this.menuEntries.add(new ResetSelectedSeriesHandler());
        this.menuEntries.add(new ToggleRangeSelectorHandler());
        this.menuEntries.add(new ToggleLegendMarkerHandler());
        this.menuEntries.add(new TogglePositionMarkerHandler());
        this.menuEntries.add(new ToggleSeriesLegendHandler());
        this.menuEntries.add(new TogglePlotCenterMarkerHandler());
        this.menuEntries.add(new ToggleAxisZeroMarkerHandler());
        this.menuEntries.add(new ToggleSeriesLabelMarkerHandler());
        this.menuEntries.add(new ToggleLabelTooltipsHandler());
        this.menuEntries.add(new UndoSelectionHandler());
        this.menuEntries.add(new RedoSelectionHandler());
        this.handledEventProcessors = new HashSet<IHandledEventProcessor>();
        this.handledEventProcessors.add(new SelectHideSeriesEvent());
        this.handledEventProcessors.add(new ResetSeriesEvent());
        this.handledEventProcessors.add(new SelectDataPointEvent());
        this.handledEventProcessors.add(new MouseWheelEvent());
        this.handledEventProcessors.add(new MouseDownEvent());
        this.handledEventProcessors.add(new MouseMoveSelectionEvent());
        this.handledEventProcessors.add(new MouseMoveShiftEvent());
        this.handledEventProcessors.add(new MouseMoveCursorEvent());
        this.handledEventProcessors.add(new MouseUpEvent());
        this.handledEventProcessors.add(new UndoRedoEvent());
    }

    @Override
    public IChartMenuEntry getChartMenuEntryByClass(Class<?> clazz) {
        for (IChartMenuEntry menuEntry : this.menuEntries) {
            if (!menuEntry.getClass().equals(clazz)) continue;
            return menuEntry;
        }
        return null;
    }

    @Override
    public IHandledEventProcessor getHandledEventProcessorByClass(Class<?> clazz) {
        for (IHandledEventProcessor handledEventProcessor : this.handledEventProcessors) {
            if (!handledEventProcessor.getClass().equals(clazz)) continue;
            return handledEventProcessor;
        }
        return null;
    }

    @Override
    public boolean isBufferSelection() {
        return this.bufferSelection;
    }

    @Override
    public void setBufferSelection(boolean bufferSelection) {
        if (this.isMacOS()) {
            System.out.println("Can't set buffer selection on macOS true, see: https://github.com/eclipse/swtchart/issues/150");
            this.bufferSelection = false;
        } else {
            this.bufferSelection = bufferSelection;
        }
    }

    @Override
    public boolean isEnableRangeSelector() {
        return this.enableRangeSelector;
    }

    @Override
    public void setEnableRangeSelector(boolean enableRangeSelector) {
        this.enableRangeSelector = enableRangeSelector;
    }

    @Override
    public boolean isShowRangeSelectorInitially() {
        return this.showRangeSelectorInitially;
    }

    @Override
    public void setShowRangeSelectorInitially(boolean showRangeSelectorInitially) {
        this.showRangeSelectorInitially = showRangeSelectorInitially;
    }

    @Override
    public Color getColorHintRangeSelector() {
        return this.colorHintRangeSelector;
    }

    @Override
    public void setColorHintRangeSelector(Color colorHintRangeSelector) {
        this.colorHintRangeSelector = colorHintRangeSelector;
    }

    @Override
    public int getRangeSelectorDefaultAxisX() {
        return this.rangeSelectorDefaultAxisX;
    }

    @Override
    public void setRangeSelectorDefaultAxisX(int rangeSelectorDefaultAxisX) {
        this.rangeSelectorDefaultAxisX = rangeSelectorDefaultAxisX;
    }

    @Override
    public int getRangeSelectorDefaultAxisY() {
        return this.rangeSelectorDefaultAxisY;
    }

    @Override
    public void setRangeSelectorDefaultAxisY(int rangeSelectorDefaultAxisY) {
        this.rangeSelectorDefaultAxisY = rangeSelectorDefaultAxisY;
    }

    @Override
    public boolean isVerticalSliderVisible() {
        return this.verticalSliderVisible;
    }

    @Override
    public void setVerticalSliderVisible(boolean verticalSliderVisible) {
        this.verticalSliderVisible = verticalSliderVisible;
    }

    @Override
    public boolean isHorizontalSliderVisible() {
        return this.horizontalSliderVisible;
    }

    @Override
    public void setHorizontalSliderVisible(boolean horizontalSliderVisible) {
        this.horizontalSliderVisible = horizontalSliderVisible;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title != null ? title : "";
    }

    @Override
    public boolean isTitleVisible() {
        return this.titleVisible;
    }

    @Override
    public void setTitleVisible(boolean titleVisible) {
        this.titleVisible = titleVisible;
    }

    @Override
    public Color getTitleColor() {
        return this.titleColor;
    }

    @Override
    public void setTitleColor(Color titleColor) {
        this.titleColor = titleColor;
    }

    @Override
    public Font getTitleFont() {
        return this.titleFont;
    }

    @Override
    public void setTitleFont(Font titleFont) {
        this.titleFont = titleFont;
    }

    @Override
    public int getLegendPosition() {
        return this.legendPosition;
    }

    @Override
    public void setLegendPosition(int legendPosition) {
        this.legendPosition = legendPosition;
    }

    @Override
    public boolean isLegendVisible() {
        return this.legendVisible;
    }

    @Override
    public void setLegendVisible(boolean legendVisible) {
        this.legendVisible = legendVisible;
    }

    @Override
    public boolean isLegendExtendedVisible() {
        return this.legendExtendedVisible;
    }

    @Override
    public void setLegendExtendedVisible(boolean legendExtendedVisible) {
        this.legendExtendedVisible = legendExtendedVisible;
    }

    @Override
    public IPrimaryAxisSettings getPrimaryAxisSettingsX() {
        return this.primaryAxisSettingsX;
    }

    @Override
    public IPrimaryAxisSettings getPrimaryAxisSettingsY() {
        return this.primaryAxisSettingsY;
    }

    @Override
    public List<ISecondaryAxisSettings> getSecondaryAxisSettingsListX() {
        return this.secondaryAxisSettingsListX;
    }

    @Override
    public List<ISecondaryAxisSettings> getSecondaryAxisSettingsListY() {
        return this.secondaryAxisSettingsListY;
    }

    @Override
    public int getOrientation() {
        return this.orientation;
    }

    @Override
    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    @Override
    public Color getBackground() {
        return this.background;
    }

    @Override
    public void setBackground(Color background) {
        this.background = background;
    }

    @Override
    public Color getBackgroundChart() {
        return this.backgroundChart;
    }

    @Override
    public void setBackgroundChart(Color backgroundChart) {
        this.backgroundChart = backgroundChart;
    }

    @Override
    public Color getBackgroundPlotArea() {
        return this.backgroundPlotArea;
    }

    @Override
    public void setBackgroundPlotArea(Color backgroundPlotArea) {
        this.backgroundPlotArea = backgroundPlotArea;
    }

    @Override
    public boolean isEnableCompress() {
        return this.enableCompress;
    }

    @Override
    public void setEnableCompress(boolean enableCompress) {
        this.enableCompress = enableCompress;
    }

    @Override
    public RangeRestriction getRangeRestriction() {
        return this.rangeRestriction;
    }

    @Override
    public boolean isShowPositionMarker() {
        return this.showPositionMarker;
    }

    @Override
    public void setShowPositionMarker(boolean showPositionMarker) {
        this.showPositionMarker = showPositionMarker;
    }

    @Override
    public Color getColorPositionMarker() {
        return this.colorPositionMarker;
    }

    @Override
    public void setColorPositionMarker(Color colorPositionMarker) {
        this.colorPositionMarker = colorPositionMarker;
    }

    @Override
    public boolean isShowPlotCenterMarker() {
        return this.showPlotCenterMarker;
    }

    @Override
    public void setShowPlotCenterMarker(boolean showPlotCenterMarker) {
        this.showPlotCenterMarker = showPlotCenterMarker;
    }

    @Override
    public Color getColorPlotCenterMarker() {
        return this.colorPlotCenterMarker;
    }

    @Override
    public void setColorPlotCenterMarker(Color colorPlotCenterMarker) {
        this.colorPlotCenterMarker = colorPlotCenterMarker;
    }

    @Override
    public boolean isShowLegendMarker() {
        return this.showLegendMarker;
    }

    @Override
    public void setShowLegendMarker(boolean showLegendMarker) {
        this.showLegendMarker = showLegendMarker;
    }

    @Override
    public Color getColorLegendMarker() {
        return this.colorLegendMarker;
    }

    @Override
    public void setColorLegendMarker(Color colorLegendMarker) {
        this.colorLegendMarker = colorLegendMarker;
    }

    @Override
    public boolean isShowAxisZeroMarker() {
        return this.showAxisZeroMarker;
    }

    @Override
    public void setShowAxisZeroMarker(boolean showAxisZeroMarker) {
        this.showAxisZeroMarker = showAxisZeroMarker;
    }

    @Override
    public Color getColorAxisZeroMarker() {
        return this.colorAxisZeroMarker;
    }

    @Override
    public void setColorAxisZeroMarker(Color colorAxisZeroMarker) {
        this.colorAxisZeroMarker = colorAxisZeroMarker;
    }

    @Override
    public boolean isShowSeriesLabelMarker() {
        return this.showSeriesLabelMarker;
    }

    @Override
    public void setShowSeriesLabelMarker(boolean showSeriesLabelMarker) {
        this.showSeriesLabelMarker = showSeriesLabelMarker;
    }

    @Override
    public Color getColorSeriesLabelMarker() {
        return this.colorSeriesLabelMarker;
    }

    @Override
    public void setColorSeriesLabelMarker(Color colorSeriesLabelMarker) {
        this.colorSeriesLabelMarker = colorSeriesLabelMarker;
    }

    @Override
    public boolean isCreateMenu() {
        return this.createMenu;
    }

    @Override
    public void setCreateMenu(boolean createMenu) {
        this.createMenu = createMenu;
    }

    @Override
    public void addMenuEntry(IChartMenuEntry menuEntry) {
        this.menuEntries.add(menuEntry);
    }

    @Override
    public void removeMenuEntry(IChartMenuEntry menuEntry) {
        this.menuEntries.remove(menuEntry);
    }

    @Override
    public Set<IChartMenuEntry> getMenuEntries() {
        return Collections.unmodifiableSet(this.menuEntries);
    }

    @Override
    public IChartMenuEntry getChartMenuEntry(String name) {
        for (IChartMenuEntry chartMenuEntry : this.menuEntries) {
            if (!chartMenuEntry.getName().equals(name)) continue;
            return chartMenuEntry;
        }
        return null;
    }

    @Override
    public void clearMenuEntries() {
        this.menuEntries.clear();
    }

    @Override
    public boolean isSupportDataShift() {
        return this.supportDataShift;
    }

    @Override
    public void setSupportDataShift(boolean supportDataShift) {
        this.supportDataShift = supportDataShift;
    }

    @Override
    public void addHandledEventProcessor(IHandledEventProcessor handledEventProcessor) {
        this.handledEventProcessors.add(handledEventProcessor);
    }

    @Override
    public void removeHandledEventProcessor(IHandledEventProcessor handledEventProcessor) {
        this.handledEventProcessors.remove(handledEventProcessor);
    }

    @Override
    public Set<IHandledEventProcessor> getHandledEventProcessors() {
        return Collections.unmodifiableSet(this.handledEventProcessors);
    }

    @Override
    public void clearHandledEventProcessors() {
        this.handledEventProcessors.clear();
    }

    @Override
    public void setEnableTooltips(boolean enable) {
        this.enableTooltips = enable;
    }

    @Override
    public boolean isEnableTooltips() {
        return this.enableTooltips;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.defaultFont.isDisposed()) {
            this.defaultFont.dispose();
        }
    }

    private boolean isMacOS() {
        String os = System.getProperty("os.name");
        if (os != null) {
            return os.toLowerCase().indexOf("mac") >= 0;
        }
        return false;
    }
}

