/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.base.api;

import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.viatra.query.runtime.base.api.BaseIndexOptions;
import org.eclipse.viatra.query.runtime.base.api.IndexingLevel;
import org.eclipse.viatra.query.runtime.base.api.NavigationHelper;
import org.eclipse.viatra.query.runtime.base.api.TransitiveClosureHelper;
import org.eclipse.viatra.query.runtime.base.core.NavigationHelperImpl;
import org.eclipse.viatra.query.runtime.base.core.TransitiveClosureHelperImpl;

public class ViatraBaseFactory {
    private static ViatraBaseFactory instance;

    public static synchronized ViatraBaseFactory getInstance() {
        if (instance == null) {
            instance = new ViatraBaseFactory();
        }
        return instance;
    }

    protected ViatraBaseFactory() {
    }

    public NavigationHelper createNavigationHelper(Notifier emfRoot, boolean wildcardMode, Logger logger) {
        BaseIndexOptions options = new BaseIndexOptions(false, wildcardMode ? IndexingLevel.FULL : IndexingLevel.NONE);
        return this.createNavigationHelper(emfRoot, options, logger);
    }

    public NavigationHelper createNavigationHelper(Notifier emfRoot, boolean wildcardMode, boolean dynamicModel, Logger logger) {
        BaseIndexOptions options = new BaseIndexOptions(dynamicModel, wildcardMode ? IndexingLevel.FULL : IndexingLevel.NONE);
        return this.createNavigationHelper(emfRoot, options, logger);
    }

    public NavigationHelper createNavigationHelper(Notifier emfRoot, BaseIndexOptions options, Logger logger) {
        Logger l = logger;
        if (l == null) {
            l = Logger.getLogger(NavigationHelper.class);
        }
        return new NavigationHelperImpl(emfRoot, options, l);
    }

    public TransitiveClosureHelper createTransitiveClosureHelper(Notifier emfRoot, Set<EReference> referencesToObserve) {
        return new TransitiveClosureHelperImpl(ViatraBaseFactory.getInstance().createNavigationHelper(emfRoot, false, null), true, referencesToObserve);
    }

    public TransitiveClosureHelper createTransitiveClosureHelper(NavigationHelper baseIndex, Set<EReference> referencesToObserve) {
        return new TransitiveClosureHelperImpl(baseIndex, false, referencesToObserve);
    }
}

