/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.wizards.CVSWizardPage;
import org.eclipse.ui.PlatformUI;

public class CheckoutAsLocationSelectionPage
extends CVSWizardPage {
    public static final String NAME = "CheckoutAsLocationSelectionPage";
    private Button browseButton;
    private Combo locationPathField;
    private Label locationLabel;
    private boolean useDefaults = true;
    private ICVSRemoteFolder[] remoteFolders;
    private String targetLocation;
    private IProject singleProject;
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;
    private static final int COMBO_HISTORY_LENGTH = 5;
    private static final String STORE_PREVIOUS_LOCATIONS = "CheckoutAsLocationSelectionPage.STORE_PREVIOUS_LOCATIONS";

    public CheckoutAsLocationSelectionPage(ImageDescriptor titleImage, ICVSRemoteFolder[] remoteFolders) {
        super(NAME, CVSUIMessages.CheckoutAsLocationSelectionPage_title, titleImage, CVSUIMessages.CheckoutAsLocationSelectionPage_description);
        this.remoteFolders = remoteFolders;
    }

    private boolean isSingleFolder() {
        return this.remoteFolders.length == 1;
    }

    public void setProject(IProject project) {
        this.singleProject = project;
        this.setLocationForSelection(true);
    }

    public void setProjectName(String string) {
        if (string == null || string.equals(".")) {
            return;
        }
        if (this.singleProject != null && this.singleProject.getName().equals(string)) {
            return;
        }
        this.setProject(ResourcesPlugin.getWorkspace().getRoot().getProject(string));
    }

    private IProject getSingleProject() {
        if (this.singleProject == null) {
            this.setProjectName(CheckoutAsLocationSelectionPage.getPreferredFolderName(this.remoteFolders[0]));
        }
        return this.singleProject;
    }

    public void createControl(Composite parent) {
        Composite composite = this.createComposite(parent, 1, false);
        this.setControl((Control)composite);
        this.initializeDialogUnits((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.team.cvs.ui.checkout_location_selection_context");
        final Button useDefaultsButton = new Button(composite, 131104);
        useDefaultsButton.setText(CVSUIMessages.CheckoutAsLocationSelectionPage_useDefaultLabel);
        useDefaultsButton.setSelection(this.useDefaults);
        this.createUserSpecifiedProjectLocationGroup(composite, !this.useDefaults);
        this.initializeValues();
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CheckoutAsLocationSelectionPage.this.useDefaults = useDefaultsButton.getSelection();
                CheckoutAsLocationSelectionPage.this.browseButton.setEnabled(!CheckoutAsLocationSelectionPage.this.useDefaults);
                CheckoutAsLocationSelectionPage.this.locationPathField.setEnabled(!CheckoutAsLocationSelectionPage.this.useDefaults);
                CheckoutAsLocationSelectionPage.this.locationLabel.setEnabled(!CheckoutAsLocationSelectionPage.this.useDefaults);
                CheckoutAsLocationSelectionPage.this.setLocationForSelection(true);
                CheckoutAsLocationSelectionPage.this.setErrorMessage(CheckoutAsLocationSelectionPage.this.useDefaults ? null : CheckoutAsLocationSelectionPage.this.checkValidLocation());
            }
        };
        useDefaultsButton.addSelectionListener((SelectionListener)listener);
        Dialog.applyDialogFont((Control)parent);
    }

    private Composite createUserSpecifiedProjectLocationGroup(Composite parent, boolean enabled) {
        Composite projectGroup = this.createComposite(parent, 3, true);
        this.locationLabel = new Label(projectGroup, 0);
        if (this.isSingleFolder()) {
            this.locationLabel.setText(CVSUIMessages.CheckoutAsLocationSelectionPage_locationLabel);
        } else {
            this.locationLabel.setText(CVSUIMessages.CheckoutAsLocationSelectionPage_parentDirectoryLabel);
        }
        this.locationLabel.setEnabled(enabled);
        this.locationPathField = new Combo(projectGroup, 4);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.locationPathField.setLayoutData((Object)data);
        this.locationPathField.setEnabled(enabled);
        this.browseButton = new Button(projectGroup, 8);
        this.browseButton.setText(CVSUIMessages.CheckoutAsLocationSelectionPage_browseLabel);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CheckoutAsLocationSelectionPage.this.handleLocationBrowseButtonPressed();
            }
        });
        this.browseButton.setEnabled(enabled);
        this.setButtonLayoutData(this.browseButton);
        this.setLocationForSelection(true);
        this.locationPathField.addModifyListener(e -> this.setErrorMessage(this.checkValidLocation()));
        return projectGroup;
    }

    private void initializeValues() {
        String[] previouseLocations;
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null && (previouseLocations = settings.getArray(STORE_PREVIOUS_LOCATIONS)) != null) {
            String[] stringArray = previouseLocations;
            int n = previouseLocations.length;
            int n2 = 0;
            while (n2 < n) {
                String previouseLocation = stringArray[n2];
                if (this.isSingleFolder()) {
                    this.locationPathField.add(new Path(previouseLocation).append(this.getSingleProject().getName()).toOSString());
                } else {
                    this.locationPathField.add(previouseLocation);
                }
                ++n2;
            }
        }
    }

    private void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] previouseLocations = settings.getArray(STORE_PREVIOUS_LOCATIONS);
            if (previouseLocations == null) {
                previouseLocations = new String[]{};
            }
            previouseLocations = this.isSingleFolder() ? this.addToHistory(previouseLocations, new Path(this.locationPathField.getText()).removeLastSegments(1).toOSString()) : this.addToHistory(previouseLocations, this.locationPathField.getText());
            settings.put(STORE_PREVIOUS_LOCATIONS, previouseLocations);
        }
    }

    private String[] addToHistory(String[] history, String newEntry) {
        ArrayList<String> l = new ArrayList<String>(Arrays.asList(history));
        this.addToHistory(l, newEntry);
        String[] r = new String[l.size()];
        l.toArray(r);
        return r;
    }

    private void addToHistory(List<String> history, String newEntry) {
        history.remove(newEntry);
        history.add(0, newEntry);
        if (history.size() > 5) {
            history.remove(5);
        }
    }

    private String checkValidLocation() {
        if (this.useDefaults) {
            this.targetLocation = null;
            return null;
        }
        this.targetLocation = this.locationPathField.getText();
        if (this.targetLocation.isEmpty()) {
            return CVSUIMessages.CheckoutAsLocationSelectionPage_locationEmpty;
        }
        Path path = new Path("");
        if (!path.isValidPath(this.targetLocation)) {
            return CVSUIMessages.CheckoutAsLocationSelectionPage_invalidLocation;
        }
        if (this.isSingleFolder()) {
            IStatus locationStatus = ResourcesPlugin.getWorkspace().validateProjectLocation(this.getSingleProject(), (IPath)new Path(this.targetLocation));
            if (!locationStatus.isOK()) {
                return locationStatus.getMessage();
            }
        } else {
            ICVSRemoteFolder[] iCVSRemoteFolderArray = this.remoteFolders;
            int n = this.remoteFolders.length;
            int n2 = 0;
            while (n2 < n) {
                ICVSRemoteFolder remoteFolder = iCVSRemoteFolderArray[n2];
                String projectName = CheckoutAsLocationSelectionPage.getPreferredFolderName(remoteFolder);
                IStatus locationStatus = ResourcesPlugin.getWorkspace().validateProjectLocation(ResourcesPlugin.getWorkspace().getRoot().getProject(projectName), new Path(this.targetLocation).append(projectName));
                if (!locationStatus.isOK()) {
                    return locationStatus.getMessage();
                }
                ++n2;
            }
        }
        return null;
    }

    private void setLocationForSelection(boolean changed) {
        if (this.useDefaults) {
            IPath defaultPath = null;
            if (this.isSingleFolder()) {
                IProject singleProject = this.getSingleProject();
                if (singleProject != null) {
                    try {
                        defaultPath = singleProject.getDescription().getLocation();
                    }
                    catch (CoreException coreException) {}
                    if (defaultPath == null) {
                        defaultPath = Platform.getLocation().append(singleProject.getName());
                    }
                }
            } else {
                defaultPath = Platform.getLocation();
            }
            if (defaultPath != null) {
                this.locationPathField.setText(defaultPath.toOSString());
            }
            this.targetLocation = null;
        } else if (changed) {
            IPath location = null;
            IProject project = this.getSingleProject();
            if (project != null) {
                try {
                    location = project.getDescription().getLocation();
                }
                catch (CoreException coreException) {}
            }
            if (location == null) {
                this.targetLocation = null;
                this.locationPathField.setText("");
            } else {
                this.targetLocation = this.isSingleFolder() ? location.toOSString() : location.removeLastSegments(1).toOSString();
                this.locationPathField.setText(this.targetLocation);
            }
        }
    }

    private void handleLocationBrowseButtonPressed() {
        String selectedDirectory;
        File path;
        DirectoryDialog dialog = new DirectoryDialog(this.locationPathField.getShell());
        if (this.isSingleFolder()) {
            dialog.setMessage(NLS.bind((String)CVSUIMessages.CheckoutAsLocationSelectionPage_messageForSingle, (Object[])new String[]{this.getSingleProject().getName()}));
        } else {
            dialog.setMessage(NLS.bind((String)CVSUIMessages.CheckoutAsLocationSelectionPage_messageForMulti, (Object[])new String[]{Integer.valueOf(this.remoteFolders.length).toString()}));
        }
        String dirName = this.locationPathField.getText();
        if (!dirName.isEmpty() && (path = new File(dirName)).exists()) {
            dialog.setFilterPath(dirName);
        }
        if ((selectedDirectory = dialog.open()) != null) {
            if (this.isSingleFolder()) {
                this.locationPathField.setText(new Path(selectedDirectory).append(this.getSingleProject().getName()).toOSString());
            } else {
                this.locationPathField.setText(new Path(selectedDirectory).toOSString());
            }
        }
        this.targetLocation = this.locationPathField.getText();
    }

    public String getTargetLocation() {
        if (this.isCustomLocationSpecified()) {
            this.saveWidgetValues();
            return this.targetLocation;
        }
        return null;
    }

    private boolean isCustomLocationSpecified() {
        return !this.useDefaults;
    }
}

