/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.unittest.internal.ui;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.unittest.internal.ui.ITraceDisplay;
import org.eclipse.unittest.internal.ui.Images;

public class FailureTableDisplay
implements ITraceDisplay {
    private final Table fTable;
    private final Image fExceptionIcon = Images.createImage("obj16/exc_catch.png");
    private final Image fStackIcon = Images.createImage("obj16/stkfrm_obj.png");

    public FailureTableDisplay(Table table) {
        this.fTable = table;
        this.fTable.getParent().addDisposeListener(e -> this.disposeIcons());
    }

    @Override
    public void addTraceLine(int lineType, String label) {
        TableItem tableItem = this.newTableItem();
        switch (lineType) {
            case 1: {
                tableItem.setImage(this.fExceptionIcon);
                break;
            }
            case 2: {
                tableItem.setImage(this.fStackIcon);
                break;
            }
        }
        tableItem.setText(label);
    }

    public Image getExceptionIcon() {
        return this.fExceptionIcon;
    }

    public Image getStackIcon() {
        return this.fStackIcon;
    }

    public Table getTable() {
        return this.fTable;
    }

    private void disposeIcons() {
        if (this.fExceptionIcon != null && !this.fExceptionIcon.isDisposed()) {
            this.fExceptionIcon.dispose();
        }
        if (this.fStackIcon != null && !this.fStackIcon.isDisposed()) {
            this.fStackIcon.dispose();
        }
    }

    public TableItem newTableItem() {
        return new TableItem(this.fTable, 0);
    }
}

