/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.common.wsdl.helpers;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Date;
import org.eclipse.bpel.common.wsdl.SoaWsdlCommonPlugin;
import org.eclipse.core.runtime.Path;

public class UriAndUrlHelper {
    public static URI urlToUri(URL url) {
        URI uri;
        try {
            uri = url.toURI();
        }
        catch (Exception exception) {
            try {
                uri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
            }
            catch (Exception exception2) {
                throw new IllegalArgumentException("Broken URL: " + url);
            }
        }
        uri = uri.normalize();
        return uri;
    }

    public static URI urlToUri(String urlAsString) {
        try {
            URL url = new URL(urlAsString);
            return UriAndUrlHelper.urlToUri(url);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Broken URL: " + urlAsString);
        }
    }

    public static String extractOrGenerateFileName(String uriAsString) {
        String lowered;
        int index;
        String fileName = uriAsString;
        if (fileName.endsWith("/")) {
            fileName = fileName.substring(0, fileName.length() - 1);
        }
        if ((index = fileName.lastIndexOf(47)) != -1) {
            fileName = fileName.substring(++index);
        }
        if ((lowered = fileName.toLowerCase()).endsWith("?wsdl")) {
            fileName = String.valueOf(fileName.substring(0, fileName.length() - 5)) + ".wsdl";
        } else if (lowered.contains("?wsdl=")) {
            fileName = String.valueOf(fileName.replace("?wsdl=", "")) + ".wsdl";
        } else if (lowered.endsWith("?xsd")) {
            fileName = String.valueOf(fileName.substring(0, fileName.length() - 5)) + ".xsd";
        } else if (lowered.contains("?xsd=")) {
            fileName = String.valueOf(fileName.replace("?xsd=", "")) + ".xsd";
        } else {
            index = fileName.lastIndexOf(63);
            if (index != -1) {
                fileName = fileName.substring(++index);
            }
        }
        if (fileName.trim().length() == 0) {
            fileName = "importedFile__" + new Date().getTime();
        }
        if ((index = fileName.lastIndexOf(46)) != -1) {
            String ext = fileName.substring(index);
            String fwe = fileName.substring(0, index);
            fileName = String.valueOf(fwe.replaceAll("[^-0-9a-zA-Z_]", "-")) + ext;
        }
        return fileName;
    }

    public static URI buildNewURI(URI referenceUri, String uriSuffix) throws URISyntaxException {
        if (uriSuffix == null) {
            throw new NullPointerException("The URI suffix cannot be null.");
        }
        uriSuffix = uriSuffix.replaceAll("\\\\", "/");
        URI importUri = null;
        try {
            importUri = UriAndUrlHelper.urlToUri(new URL(uriSuffix));
        }
        catch (Exception exception) {
            try {
                importUri = referenceUri.resolve(new URI(null, uriSuffix, null));
            }
            catch (Exception e2) {
                String msg = "An URI could not be built from the URI " + referenceUri.toString() + " and the suffix " + uriSuffix + ".";
                throw new URISyntaxException(msg, e2.getMessage());
            }
        }
        return importUri.normalize();
    }

    public static boolean isAbsoluteUri(String uriAsString) {
        boolean result;
        try {
            URI uri = UriAndUrlHelper.urlToUri(uriAsString);
            result = uri.isAbsolute();
        }
        catch (Exception exception) {
            result = false;
        }
        return result;
    }

    public static URI getRelativeLocationToUri(URI originUri, URI uri) {
        URI result = uri;
        try {
            originUri = UriAndUrlHelper.urlToUri(originUri.toURL());
            uri = UriAndUrlHelper.urlToUri(uri.toURL());
            URI relativeUri = originUri.relativize(uri).normalize();
            if (!uri.equals(relativeUri)) {
                result = relativeUri;
            } else {
                String originScheme = originUri.getScheme();
                String scheme = uri.getScheme();
                boolean sameScheme = false;
                sameScheme = originScheme != null ? originScheme.equals(scheme) : scheme == null;
                String originHost = originUri.getHost();
                String host = uri.getHost();
                boolean sameHost = false;
                sameHost = originHost != null ? originHost.equals(host) : host == null;
                boolean samePartition = true;
                if (sameScheme && "file".equalsIgnoreCase(originScheme)) {
                    String originDevice = new Path(originUri.getPath()).getDevice();
                    String device = new Path(uri.getPath()).getDevice();
                    if (originDevice != null) {
                        samePartition = originDevice.equals(device);
                    } else {
                        boolean bl = samePartition = device == null;
                    }
                }
                if (sameScheme && sameHost && samePartition) {
                    String originPath = originUri.toString().replaceAll("\\\\", "/");
                    String path = uri.toString().replaceAll("\\\\", "/");
                    String[] originParts = originPath.split("/");
                    String[] fileParts = path.split("/");
                    int matchSegmentsCpt = 0;
                    int i = 0;
                    while (i < originParts.length) {
                        String otherSegment;
                        String segment;
                        if (i >= fileParts.length || !(segment = originParts[i]).equalsIgnoreCase(otherSegment = fileParts[i])) break;
                        ++matchSegmentsCpt;
                        ++i;
                    }
                    StringBuffer relativePath = new StringBuffer();
                    if (matchSegmentsCpt > 0) {
                        int i2 = matchSegmentsCpt;
                        while (i2 < originParts.length - 1) {
                            relativePath.append("../");
                            ++i2;
                        }
                        i2 = matchSegmentsCpt;
                        while (i2 < fileParts.length - 1) {
                            relativePath.append(String.valueOf(fileParts[i2]) + "/");
                            ++i2;
                        }
                        relativePath.append(fileParts[fileParts.length - 1]);
                        result = new URI(null, relativePath.toString(), null);
                    }
                }
            }
        }
        catch (URISyntaxException e) {
            SoaWsdlCommonPlugin.log(e, 4);
        }
        catch (MalformedURLException e) {
            SoaWsdlCommonPlugin.log(e, 4);
        }
        return result;
    }
}

