/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.packs.ui.views;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.embedcdt.packs.core.tree.Leaf;
import org.eclipse.embedcdt.packs.core.tree.PackNode;
import org.eclipse.embedcdt.packs.core.tree.Selector;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class PacksFilter
extends ViewerFilter {
    private IStructuredSelection fSelection;
    private String fSelectorType;

    public void setSelection(String selectorType, IStructuredSelection selection) {
        this.fSelection = selection;
        this.fSelectorType = selectorType;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.fSelection == null || this.fSelection.isEmpty()) {
            return true;
        }
        Leaf node = (Leaf)element;
        if ("vendor".equals(node.getType())) {
            StructuredViewer sviewer = (StructuredViewer)viewer;
            ITreeContentProvider provider = (ITreeContentProvider)sviewer.getContentProvider();
            Object[] objectArray = provider.getChildren(element);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                if (this.select(viewer, element, child)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        if (!"package".equals(node.getType())) {
            return true;
        }
        if (!(node instanceof PackNode)) {
            return false;
        }
        if (!((PackNode)node).hasSelectors()) {
            return false;
        }
        List selectors = ((PackNode)node).getSelectors();
        LinkedList<Selector> filteredSelectors = new LinkedList<Selector>();
        for (Selector selector : selectors) {
            if (!this.fSelectorType.equals(selector.getType())) continue;
            filteredSelectors.add(selector);
        }
        if (filteredSelectors.size() == 0) {
            return false;
        }
        for (Selector condition : filteredSelectors) {
            for (Object selectionNode : this.fSelection.toList()) {
                if (!(selectionNode instanceof Leaf) || !this.isNodeVisible(condition, (Leaf)selectionNode)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isNodeVisible(Selector selector, Leaf selectionNode) {
        String selectorType = selector.getType();
        String selectionNodeType = selectionNode.getType();
        return "board".equals(selectorType) ? ("vendor".equals(selectionNodeType) ? selector.getVendor().equals(selectionNode.getName()) : "board".equals(selectionNodeType) && selector.getVendor().equals(selectionNode.getProperty("vendor.name")) && selector.getValue().equals(selectionNode.getName())) : ("devicefamily".equals(selectorType) ? ("vendor".equals(selectionNodeType) ? selector.getVendorId().equals(selectionNode.getProperty("vendor.id", "")) : "family".equals(selectionNodeType) && selector.getVendorId().equals(selectionNode.getProperty("vendor.id", "")) && selector.getValue().equals(selectionNode.getName())) : "keyword".equals(selectorType) && "keyword".equals(selectionNode.getType()) && selector.getValue().equals(selectionNode.getName()));
    }
}

