/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.operations;

import javafx.scene.Node;
import javafx.scene.transform.Affine;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.fx.utils.NodeUtils;
import org.eclipse.gef.mvc.fx.operations.ITransactionalOperation;
import org.eclipse.gef.mvc.fx.parts.ITransformableContentPart;

public class TransformVisualOperation
extends AbstractOperation
implements ITransactionalOperation {
    private ITransformableContentPart<? extends Node> transformablePart;
    private Affine initialTransform;
    private Affine finalTransform;

    public TransformVisualOperation(ITransformableContentPart<? extends Node> transformablePart) {
        this(transformablePart, transformablePart.getVisualTransform());
    }

    public TransformVisualOperation(ITransformableContentPart<? extends Node> transformablePart, Affine newTransform) {
        super("Transform");
        this.transformablePart = transformablePart;
        this.initialTransform = NodeUtils.setAffine((Affine)new Affine(), (Affine)transformablePart.getVisualTransform());
        this.finalTransform = NodeUtils.setAffine((Affine)new Affine(), (Affine)newTransform);
    }

    protected void applyTransform(Affine transform) {
        if (!NodeUtils.equals((Affine)this.transformablePart.getVisualTransform(), (Affine)transform)) {
            this.transformablePart.setVisualTransform(transform);
        }
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.applyTransform(this.finalTransform);
        return Status.OK_STATUS;
    }

    public Affine getInitialTransform() {
        return this.initialTransform;
    }

    public Affine getNewTransform() {
        return this.finalTransform;
    }

    @Override
    public boolean isContentRelevant() {
        return false;
    }

    @Override
    public boolean isNoOp() {
        return NodeUtils.equals((Affine)this.initialTransform, (Affine)this.finalTransform);
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.execute(monitor, info);
    }

    public void setFinalTransform(Affine newTransform) {
        this.finalTransform = NodeUtils.setAffine((Affine)new Affine(), (Affine)newTransform);
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.applyTransform(this.initialTransform);
        return Status.OK_STATUS;
    }
}

