/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.examples.filesystem.patterns;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.graphiti.examples.mm.filesystem.File;
import org.eclipse.graphiti.examples.mm.filesystem.FilesystemFactory;
import org.eclipse.graphiti.examples.mm.filesystem.Folder;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IAreaContext;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.eclipse.graphiti.features.context.IDirectEditingContext;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.AbstractStyle;
import org.eclipse.graphiti.mm.algorithms.styles.Orientation;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.pattern.IPattern;
import org.eclipse.graphiti.pattern.id.IdLayoutContext;
import org.eclipse.graphiti.pattern.id.IdPattern;
import org.eclipse.graphiti.pattern.id.IdUpdateContext;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeCreateService;
import org.eclipse.graphiti.util.IColorConstant;
import org.eclipse.graphiti.util.PredefinedColoredAreas;

public class FolderPattern
extends IdPattern
implements IPattern {
    private static final String ID_FOLDER_NAME_TEXT = "folderNameText";
    private static final String ID_OUTER_RECTANGLE = "outerRectangle";
    private static final String ID_MAIN_RECTANGLE = "mainRectangle";
    private static final String ID_NAME_SEPARATOR = "nameSeparator";
    private static final String ID_FILE_NAMES_RECTANGLE = "fileNamesRectangle";
    private static final String ID_FILE_NAME_TEXT = "fileNameText";

    public String getCreateName() {
        return "Folder";
    }

    public boolean isMainBusinessObjectApplicable(Object mainBusinessObject) {
        return mainBusinessObject instanceof Folder;
    }

    public boolean canCreate(ICreateContext context) {
        return context.getTargetContainer() instanceof Diagram;
    }

    public Object[] create(ICreateContext context) {
        Folder newFolder = FilesystemFactory.eINSTANCE.createFolder();
        this.getDiagram().eResource().getContents().add((Object)newFolder);
        newFolder.setName(this.createNewName());
        this.addGraphicalRepresentation((IAreaContext)context, newFolder);
        return new Object[]{newFolder};
    }

    public boolean canAdd(IAddContext context) {
        return super.canAdd(context) && context.getTargetContainer() instanceof Diagram;
    }

    public PictogramElement doAdd(IAddContext context) {
        Diagram targetDiagram = (Diagram)context.getTargetContainer();
        Folder addedFolder = (Folder)context.getNewObject();
        IPeCreateService peCreateService = Graphiti.getPeCreateService();
        IGaService gaService = Graphiti.getGaService();
        ContainerShape outerContainerShape = peCreateService.createContainerShape((ContainerShape)targetDiagram, true);
        Rectangle outerRectangle = gaService.createInvisibleRectangle((PictogramElement)outerContainerShape);
        this.setId((PropertyContainer)outerRectangle, ID_OUTER_RECTANGLE);
        gaService.setLocationAndSize((GraphicsAlgorithm)outerRectangle, context.getX(), context.getY(), context.getWidth(), context.getHeight());
        Rectangle registerRectangle = gaService.createRectangle((GraphicsAlgorithmContainer)outerRectangle);
        gaService.setLocationAndSize((GraphicsAlgorithm)registerRectangle, 0, 0, 20, 20);
        registerRectangle.setFilled(Boolean.valueOf(true));
        gaService.setRenderingStyle((AbstractStyle)registerRectangle, PredefinedColoredAreas.getSilverWhiteGlossAdaptions());
        Rectangle mainRectangle = gaService.createRectangle((GraphicsAlgorithmContainer)outerRectangle);
        this.setId((PropertyContainer)mainRectangle, ID_MAIN_RECTANGLE);
        mainRectangle.setFilled(Boolean.valueOf(true));
        gaService.setRenderingStyle((AbstractStyle)mainRectangle, PredefinedColoredAreas.getSilverWhiteGlossAdaptions());
        Shape textShape = peCreateService.createShape(outerContainerShape, false);
        Text folderNameText = gaService.createText((GraphicsAlgorithmContainer)textShape, "");
        this.setId((PropertyContainer)folderNameText, ID_FOLDER_NAME_TEXT);
        folderNameText.setHorizontalAlignment(Orientation.ALIGNMENT_CENTER);
        folderNameText.setVerticalAlignment(Orientation.ALIGNMENT_CENTER);
        Shape lineShape = peCreateService.createShape(outerContainerShape, false);
        Polyline polyline = gaService.createPolyline((GraphicsAlgorithmContainer)lineShape);
        this.setId((PropertyContainer)polyline, ID_NAME_SEPARATOR);
        polyline.setForeground(this.manageColor(IColorConstant.BLACK));
        ContainerShape filesContainerShape = peCreateService.createContainerShape(outerContainerShape, false);
        Rectangle filesRectangle = gaService.createInvisibleRectangle((PictogramElement)filesContainerShape);
        this.setId((PropertyContainer)filesRectangle, ID_FILE_NAMES_RECTANGLE);
        peCreateService.createChopboxAnchor((AnchorContainer)outerContainerShape);
        this.link((PictogramElement)outerContainerShape, addedFolder);
        this.link((PictogramElement)textShape, addedFolder);
        this.link((PictogramElement)filesContainerShape, addedFolder);
        return outerContainerShape;
    }

    protected boolean layout(IdLayoutContext context, String id) {
        boolean changesDone = false;
        Rectangle outerRectangle = (Rectangle)context.getRootPictogramElement().getGraphicsAlgorithm();
        GraphicsAlgorithm ga = context.getGraphicsAlgorithm();
        if (id.equals(ID_MAIN_RECTANGLE)) {
            Graphiti.getGaService().setLocationAndSize(ga, 0, 10, outerRectangle.getWidth(), outerRectangle.getHeight() - 10);
            changesDone = true;
        } else if (id.equals(ID_FOLDER_NAME_TEXT)) {
            Graphiti.getGaService().setLocationAndSize(ga, 0, 10, outerRectangle.getWidth(), 20);
            changesDone = true;
        } else if (id.equals(ID_NAME_SEPARATOR)) {
            Polyline polyline = (Polyline)ga;
            polyline.getPoints().clear();
            int[] nArray = new int[4];
            nArray[1] = 30;
            nArray[2] = outerRectangle.getWidth();
            nArray[3] = 30;
            List pointList = Graphiti.getGaService().createPointList(nArray);
            polyline.getPoints().addAll((Collection)pointList);
            changesDone = true;
        } else if (id.equals(ID_FILE_NAMES_RECTANGLE)) {
            Graphiti.getGaService().setLocationAndSize(ga, 0, 30, outerRectangle.getWidth(), outerRectangle.getHeight() - 30);
            changesDone = true;
        } else if (id.equals(ID_FILE_NAME_TEXT)) {
            int index = this.getIndex((PropertyContainer)context.getGraphicsAlgorithm());
            Graphiti.getGaService().setLocationAndSize(ga, 5, 30 + 20 * index, outerRectangle.getWidth() - 10, 20);
            changesDone = true;
        }
        return changesDone;
    }

    protected IReason updateNeeded(IdUpdateContext context, String id) {
        if (id.equals(ID_FOLDER_NAME_TEXT)) {
            Text nameText = (Text)context.getGraphicsAlgorithm();
            Folder domainObject = (Folder)context.getDomainObject();
            if (domainObject.getName() == null || !domainObject.getName().equals(nameText.getValue())) {
                return Reason.createTrueReason((String)("Name differs. Expected: '" + domainObject.getName() + "'"));
            }
        } else if (id.equals(ID_FILE_NAMES_RECTANGLE)) {
            ContainerShape filesContainerShape = (ContainerShape)context.getPictogramElement();
            Folder folder = (Folder)context.getDomainObject();
            if (filesContainerShape.getChildren().size() != folder.getFiles().size()) {
                return Reason.createTrueReason((String)("Number of files differ. Expected: " + folder.getFiles().size()));
            }
        } else if (id.equals(ID_FILE_NAME_TEXT)) {
            Text nameText = (Text)context.getGraphicsAlgorithm();
            File file = (File)context.getDomainObject();
            if (file.getName() == null || !file.getName().equals(nameText.getValue())) {
                return Reason.createTrueReason((String)("Name differs. Expected: '" + file.getName() + "'"));
            }
        }
        return Reason.createFalseReason();
    }

    protected boolean update(IdUpdateContext context, String id) {
        if (id.equals(ID_FOLDER_NAME_TEXT)) {
            Text nameText = (Text)context.getGraphicsAlgorithm();
            Folder domainObject = (Folder)context.getDomainObject();
            nameText.setValue(domainObject.getName());
            return true;
        }
        if (id.equals(ID_FILE_NAMES_RECTANGLE)) {
            EList children = ((ContainerShape)context.getPictogramElement()).getChildren();
            Shape[] toDelete = (Shape[])children.toArray((Object[])new Shape[children.size()]);
            Shape[] shapeArray = toDelete;
            int n = toDelete.length;
            int n2 = 0;
            while (n2 < n) {
                Shape shape = shapeArray[n2];
                EcoreUtil.delete((EObject)shape, (boolean)true);
                ++n2;
            }
            EList files = ((Folder)context.getDomainObject()).getFiles();
            int index = 0;
            for (File file : files) {
                Shape shape = Graphiti.getPeCreateService().createShape((ContainerShape)context.getPictogramElement(), true);
                Text fileNameText = Graphiti.getGaService().createText((GraphicsAlgorithmContainer)shape, file.getName());
                this.setId((PropertyContainer)fileNameText, ID_FILE_NAME_TEXT);
                this.setIndex((PropertyContainer)fileNameText, index);
                ++index;
                fileNameText.setHorizontalAlignment(Orientation.ALIGNMENT_LEFT);
                fileNameText.setVerticalAlignment(Orientation.ALIGNMENT_CENTER);
                this.link((PictogramElement)shape, file);
            }
            return true;
        }
        if (id.equals(ID_FILE_NAME_TEXT)) {
            Text nameText = (Text)context.getGraphicsAlgorithm();
            File file = (File)context.getDomainObject();
            nameText.setValue(file.getName());
            return true;
        }
        return false;
    }

    public int getEditingType() {
        return 1;
    }

    public boolean canDirectEdit(IDirectEditingContext context) {
        Object domainObject = this.getBusinessObjectForPictogramElement(context.getPictogramElement());
        GraphicsAlgorithm ga = context.getGraphicsAlgorithm();
        return domainObject instanceof Folder && ga instanceof Text;
    }

    public String getInitialValue(IDirectEditingContext context) {
        Folder folder = (Folder)this.getBusinessObjectForPictogramElement(context.getPictogramElement());
        return folder.getName();
    }

    public String checkValueValid(String value, IDirectEditingContext context) {
        if (value == null || value.length() == 0) {
            return "Folder name must not be empty";
        }
        Folder folder = (Folder)this.getBusinessObjectForPictogramElement(context.getPictogramElement());
        EList children = this.getDiagram().getChildren();
        for (Shape child : children) {
            Object domainObject = this.getBusinessObjectForPictogramElement((PictogramElement)child);
            if (!(domainObject instanceof Folder) || domainObject.equals(folder) || !value.equals(((Folder)domainObject).getName())) continue;
            return "A folder with name '" + ((Folder)domainObject).getName() + "' already exists.";
        }
        return null;
    }

    public void setValue(String value, IDirectEditingContext context) {
        Folder folder = (Folder)this.getBusinessObjectForPictogramElement(context.getPictogramElement());
        folder.setName(value);
        this.updatePictogramElement(context.getPictogramElement());
    }

    private String createNewName() {
        String initialName;
        String name = initialName = "NewFolder";
        int number = 0;
        while (this.findFolder(name) != null) {
            name = String.valueOf(initialName) + ++number;
        }
        return name;
    }

    private Folder findFolder(String name) {
        EList contents = this.getDiagram().eResource().getContents();
        for (EObject eObject : contents) {
            if (!(eObject instanceof Folder) || !name.equals(((Folder)eObject).getName())) continue;
            return (Folder)eObject;
        }
        return null;
    }
}

