/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.common.ui.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.graphics.Image;

class BrowserNode
implements IAdaptable {
    private final EObject myEObject;
    private final BrowserNode myParent;
    private List<BrowserNode> myChildren;
    private List<BrowserNode> myAllChildren;

    public BrowserNode() {
        this(null, null);
    }

    public BrowserNode(EObject eObject, BrowserNode parent) {
        this.myEObject = eObject;
        this.myParent = parent;
    }

    public Object getAdapter(Class adapter) {
        if (this.getEObject() != null && adapter.isAssignableFrom(this.getEObject().getClass())) {
            return this.getEObject();
        }
        return null;
    }

    public EObject getEObject() {
        return this.myEObject;
    }

    public BrowserNode getParent() {
        return this.myParent;
    }

    public boolean hasChildren(boolean includeInheritedFeatures) {
        return this.getChildren(includeInheritedFeatures).size() > 0;
    }

    public List<BrowserNode> getChildren(boolean includeInheritedFeatures) {
        if (this.getEObject() != null) {
            if (includeInheritedFeatures && this.getEObject() instanceof EClass) {
                if (this.myAllChildren == null) {
                    ArrayList<BrowserNode> allChildren = new ArrayList<BrowserNode>();
                    EClass eClass = (EClass)this.getEObject();
                    for (EObject feature : eClass.getEAllStructuralFeatures()) {
                        allChildren.add(new BrowserNode(feature, this));
                    }
                    for (EObject operation : eClass.getEAllOperations()) {
                        allChildren.add(new BrowserNode(operation, this));
                    }
                    for (EObject annotation : eClass.getEAnnotations()) {
                        allChildren.add(new BrowserNode(annotation, this));
                    }
                    this.myAllChildren = allChildren;
                }
                return this.myAllChildren;
            }
            if (this.myChildren == null) {
                ArrayList<BrowserNode> children = new ArrayList<BrowserNode>();
                for (EObject child : this.getEObject().eContents()) {
                    children.add(new BrowserNode(child, this));
                }
                this.myChildren = children;
            }
            return this.myChildren;
        }
        return this.myChildren != null ? this.myChildren : Collections.emptyList();
    }

    public void addChild(BrowserNode child) {
        if (this.myChildren == null) {
            this.myChildren = new ArrayList<BrowserNode>();
        }
        this.myChildren.add(child);
    }

    public void removeChild(BrowserNode child) {
        if (this.myChildren != null) {
            this.myChildren.remove(child);
        }
    }

    public Image getImage() {
        return null;
    }

    public String getText() {
        return null;
    }

    public static BrowserNode findNodeForInstance(BrowserNode node, EObject ownedEObject) {
        if (node.getEObject() == ownedEObject) {
            return node;
        }
        List<BrowserNode> children = node.getChildren(false);
        BrowserNode foundNode = null;
        int i = 0;
        while (i < children.size()) {
            foundNode = BrowserNode.findNodeForInstance(children.get(i), ownedEObject);
            if (foundNode != null) break;
            ++i;
        }
        return foundNode;
    }
}

