/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.internal.panes;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.IResultTable;
import org.eclipse.mat.query.refined.Filter;
import org.eclipse.mat.query.refined.RefinedStructuredResult;
import org.eclipse.mat.query.refined.RefinedTable;
import org.eclipse.mat.query.registry.QueryResult;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.query.TQuantize;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.Messages;
import org.eclipse.mat.ui.internal.panes.QueryResultPane;
import org.eclipse.mat.ui.internal.viewer.RefinedResultViewer;
import org.eclipse.mat.ui.internal.viewer.RefinedTableViewer;
import org.eclipse.mat.ui.util.EasyToolBarDropDown;
import org.eclipse.mat.ui.util.ErrorHelper;
import org.eclipse.mat.ui.util.PopupMenu;
import org.eclipse.mat.ui.util.ProgressMonitorWrapper;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.swt.widgets.MessageBox;

public class TableResultPane
extends QueryResultPane {
    protected RefinedStructuredResult srcStructured;
    protected TQuantize.Target groupedBy;

    @Override
    public void initWithArgument(Object argument) {
        super.initWithArgument(argument);
        this.srcStructured = this.viewer.getResult();
    }

    @Override
    public void contributeToToolBar(IToolBarManager manager) {
        if (this.srcStructured instanceof RefinedTable) {
            this.addGroupingOptions(manager);
        }
        super.contributeToToolBar(manager);
    }

    private void addGroupingOptions(IToolBarManager manager) {
        EasyToolBarDropDown groupingAction = new EasyToolBarDropDown(Messages.TableResultPane_GroupResultBy, MemoryAnalyserPlugin.getImageDescriptor("$nl$/icons/grouping.gif"), this){

            @Override
            public void contribute(PopupMenu menu) {
                GroupingAction action = new GroupingAction(null);
                if (TableResultPane.this.groupedBy == null) {
                    action.setEnabled(false);
                }
                menu.add(action);
                action = new GroupingAction(TQuantize.Target.CLASSLOADER);
                if (TableResultPane.this.groupedBy == TQuantize.Target.CLASSLOADER) {
                    action.setEnabled(false);
                }
                menu.add(action);
                action = new GroupingAction(TQuantize.Target.PACKAGE);
                if (TableResultPane.this.groupedBy == TQuantize.Target.PACKAGE) {
                    action.setEnabled(false);
                }
                menu.add(action);
            }
        };
        manager.add((IAction)groupingAction);
    }

    public RefinedStructuredResult getSrcStructured() {
        return this.srcStructured;
    }

    public TQuantize.Target getGroupedBy() {
        return this.groupedBy;
    }

    class GroupingAction
    extends Action {
        private TQuantize.Target target;

        public GroupingAction(TQuantize.Target target) {
            this.target = target;
            if (target == null) {
                this.setText(Messages.TableResultPane_NoGrouping);
            } else {
                this.setText(target.getLabel());
                this.setImageDescriptor(MemoryAnalyserPlugin.getDefault().getImageDescriptor(target.getIcon()));
            }
        }

        public void run() {
            if (this.target == null) {
                TableResultPane.this.deactivateViewer();
                TableResultPane.this.groupedBy = this.target;
                TableResultPane.this.activateViewer(new RefinedTableViewer(TableResultPane.this.getQueryContext(), TableResultPane.this.srcQueryResult, (RefinedTable)TableResultPane.this.srcStructured));
            } else {
                if (TableResultPane.this.srcStructured.hasActiveFilter()) {
                    StringBuilder buf = new StringBuilder();
                    buf.append(Messages.TableResultPane_TableIsFiltered);
                    Column[] columns = TableResultPane.this.srcStructured.getColumns();
                    Filter[] filters = TableResultPane.this.srcStructured.getFilter();
                    int index = 0;
                    while (index < filters.length) {
                        if (filters[index].isActive()) {
                            buf.append("\n").append(MessageUtil.format((String)Messages.TableResultPane_onColumn, (Object[])new Object[]{filters[index].getCriteria(), columns[index].getLabel()}));
                        }
                        ++index;
                    }
                    MessageBox msg = new MessageBox(TableResultPane.this.viewer.getControl().getShell(), 288);
                    msg.setText(Messages.TableResultPane_Info);
                    msg.setMessage(buf.toString());
                    if (msg.open() != 32) {
                        return;
                    }
                }
                new Job(this.getText()){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            ISnapshot snapshot = (ISnapshot)TableResultPane.this.getQueryContext().get(ISnapshot.class, null);
                            TQuantize t = TQuantize.defaultValueDistribution((ISnapshot)snapshot, (IResultTable)((RefinedTable)((GroupingAction)GroupingAction.this).TableResultPane.this.srcStructured), (TQuantize.Target)GroupingAction.this.target);
                            final IResult subject = t.process((IProgressListener)new ProgressMonitorWrapper(monitor));
                            ((GroupingAction)GroupingAction.this).TableResultPane.this.top.getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    TableResultPane.this.deactivateViewer();
                                    QueryResult qr = new QueryResult(((GroupingAction)(this).GroupingAction.this).TableResultPane.this.srcQueryResult.getQuery(), ((GroupingAction)(this).GroupingAction.this).TableResultPane.this.srcQueryResult.getCommand(), subject);
                                    ((GroupingAction)(this).GroupingAction.this).TableResultPane.this.groupedBy = GroupingAction.this.target;
                                    RefinedResultViewer v = TableResultPane.this.createViewer(qr);
                                    TableResultPane.this.activateViewer(v);
                                }
                            });
                        }
                        catch (SnapshotException e) {
                            return ErrorHelper.createErrorStatus(e);
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
        }
    }
}

