/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.ids;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.TemplateParameter;
import org.eclipse.ocl.pivot.ids.BindingsId;
import org.eclipse.ocl.pivot.ids.ElementId;
import org.eclipse.ocl.pivot.ids.IdVisitor;
import org.eclipse.ocl.pivot.ids.TemplateBinding;
import org.eclipse.ocl.pivot.ids.TemplateParameterId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.ids.AbstractTypeId;
import org.eclipse.ocl.pivot.utilities.ClassUtil;

public class TemplateBindingImpl
extends AbstractTypeId
implements TemplateBinding {
    private TemplateParameter templateParameter;
    private TemplateParameterId templateParameterId;

    public TemplateBindingImpl(@NonNull TemplateParameter templateParameter) {
        this.templateParameter = templateParameter;
    }

    @Override
    public <R> R accept(@NonNull IdVisitor<R> visitor) {
        return visitor.visitTemplateBinding(this);
    }

    @Override
    public @NonNull String getDisplayName() {
        String string = String.valueOf(this.templateParameter != null ? this.templateParameter : this.templateParameterId);
        assert (string != null);
        return string;
    }

    @Override
    public @NonNull TemplateParameter getTemplateParameter() {
        return ClassUtil.nonNullState(this.templateParameter);
    }

    @Override
    public int hashCode() {
        return this.templateParameter.hashCode();
    }

    @Override
    public void install(@NonNull TemplateParameterId templateParameterId) {
        this.templateParameterId = templateParameterId;
        this.templateParameter = null;
    }

    @Override
    public @NonNull TypeId specialize(@NonNull BindingsId templateBindings) {
        int index = this.templateParameterId.getIndex();
        ElementId templateBinding = (ElementId)templateBindings.get(index);
        if (templateBinding instanceof TemplateBinding) {
            return new TemplateBindingImpl(((TemplateBinding)templateBinding).getTemplateParameter());
        }
        assert (templateBinding != null);
        return (TypeId)templateBinding;
    }
}

