/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.editor;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;

public final class IndentUtil {
    private static final String SLASHES = "//";

    public static int computeVisualLength(CharSequence seq, int tablen) {
        int size = 0;
        int i = 0;
        while (i < seq.length()) {
            char ch = seq.charAt(i);
            if (ch == '\t') {
                if (tablen != 0) {
                    size += tablen - size % tablen;
                }
            } else {
                ++size;
            }
            ++i;
        }
        return size;
    }

    public static String getCurrentIndent(IDocument document, int line, boolean indentInsideLineComments) throws BadLocationException {
        IRegion region = document.getLineInformation(line);
        int from = region.getOffset();
        int endOffset = region.getOffset() + region.getLength();
        int to = from;
        if (indentInsideLineComments) {
            while (to < endOffset - 2 && document.get(to, 2).equals(SLASHES)) {
                to += 2;
            }
        }
        while (to < endOffset) {
            char ch = document.getChar(to);
            if (!Character.isWhitespace(ch)) break;
            ++to;
        }
        return document.get(from, to - from);
    }

    public static String changePrefix(String prefix, int displayedWidth, int tabWidth, boolean useSpaces) {
        int column = IndentUtil.computeVisualLength(prefix, tabWidth);
        if (column > displayedWidth) {
            return prefix;
        }
        StringBuilder buffer = new StringBuilder(prefix);
        IndentUtil.appendIndent(buffer, displayedWidth, tabWidth, useSpaces, column);
        return buffer.toString();
    }

    private static StringBuilder appendIndent(StringBuilder buffer, int width, int tabWidth, boolean useSpaces, int startColumn) {
        assert (tabWidth > 0);
        int tabStop = startColumn - startColumn % tabWidth;
        int tabs = useSpaces ? 0 : (width - tabStop) / tabWidth;
        int i = 0;
        while (i < tabs) {
            buffer.append('\t');
            startColumn = tabStop += tabWidth;
            ++i;
        }
        int spaces = width - startColumn;
        int i2 = 0;
        while (i2 < spaces) {
            buffer.append(' ');
            ++i2;
        }
        return buffer;
    }
}

