import { TextDocuments } from 'vscode-languageserver/node';
import { TextDocument } from 'vscode-languageserver-textdocument';
// This class is responsible for handling all the settings
export class SettingsState {
    constructor() {
        this.yamlConfigurationSettings = undefined;
        this.schemaAssociations = undefined;
        this.formatterRegistration = null;
        this.specificValidatorPaths = [];
        this.schemaConfigurationSettings = [];
        this.yamlShouldValidate = true;
        this.yamlFormatterSettings = {
            singleQuote: false,
            bracketSpacing: true,
            proseWrap: 'preserve',
            printWidth: 80,
            enable: true,
        };
        this.yamlShouldHover = true;
        this.yamlShouldCompletion = true;
        this.schemaStoreSettings = [];
        this.customTags = [];
        this.schemaStoreEnabled = true;
        this.indentation = undefined;
        // File validation helpers
        this.pendingValidationRequests = {};
        this.validationDelayMs = 200;
        // Create a simple text document manager. The text document manager
        // supports full document sync only
        this.documents = new TextDocuments(TextDocument);
        this.workspaceRoot = null;
        this.workspaceFolders = [];
        this.clientDynamicRegisterSupport = false;
        this.hierarchicalDocumentSymbolSupport = false;
        this.hasWorkspaceFolderCapability = false;
        this.useVSCodeContentRequest = false;
    }
}
export class TextDocumentTestManager extends TextDocuments {
    constructor() {
        super(TextDocument);
        this.testTextDocuments = new Map();
    }
    get(uri) {
        return this.testTextDocuments.get(uri);
    }
    set(textDocument) {
        this.testTextDocuments.set(textDocument.uri, textDocument);
    }
}
//# sourceMappingURL=yamlSettings.js.map