/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ui;

import java.util.Set;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.internal.ui.messages.Messages;
import org.eclipse.emf.cdo.transaction.CDOConflictResolver;
import org.eclipse.emf.cdo.transaction.CDOConflictResolver3;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.ui.shared.SharedIcons;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CDOCommitCommentPrompter {
    private final CDOConflictResolver3 impl = new CDOConflictResolver3(){

        public CDOTransaction getTransaction() {
            return CDOCommitCommentPrompter.this.transaction;
        }

        public void setTransaction(CDOTransaction tx) {
            CDOCommitCommentPrompter.this.transaction = tx;
            CDOCommitCommentPrompter.this.comment = "";
        }

        public boolean preCommit() {
            CommentDialog dialog = CDOCommitCommentPrompter.this.createDialog(CDOCommitCommentPrompter.this.comment);
            int[] result = new int[1];
            UIUtil.syncExec(() -> {
                int n = dialog.open();
            });
            if (result[0] != 0) {
                return false;
            }
            CDOCommitCommentPrompter.this.comment = dialog.getComment();
            CDOCommitCommentPrompter.this.transaction.setCommitComment(CDOCommitCommentPrompter.this.comment.length() == 0 ? null : CDOCommitCommentPrompter.this.comment.trim());
            return true;
        }

        public void resolveConflicts(Set<CDOObject> conflicts) {
        }
    };
    private CDOTransaction transaction;
    private String comment;

    public CDOCommitCommentPrompter(CDOTransaction transaction) {
        transaction.options().addConflictResolver((CDOConflictResolver)this.impl);
    }

    public final CDOTransaction getTransaction() {
        return this.transaction;
    }

    public void dispose() {
        this.transaction.options().removeConflictResolver((CDOConflictResolver)this.impl);
        this.transaction = null;
    }

    protected CommentDialog createDialog(String defaultComment) {
        return new CommentDialog(this.getParentShell(), defaultComment);
    }

    protected Shell getParentShell() {
        return UIUtil.getShell();
    }

    public static class CommentDialog
    extends TitleAreaDialog {
        public static final String TITLE = Messages.getString("CDOCommitCommentPrompter.0");
        private String comment;

        public CommentDialog(Shell parentShell, String defaultComment) {
            super(parentShell);
            this.setShellStyle(this.getShellStyle() | 0x10000 | 0x400 | 0x20 | 0x10);
            this.comment = defaultComment == null ? "" : defaultComment;
        }

        public String getComment() {
            return this.comment;
        }

        protected Control createDialogArea(Composite parent) {
            this.getShell().setText(TITLE);
            this.setTitle(TITLE);
            this.setTitleImage(SharedIcons.getImage((String)"wizban/commit.gif"));
            GridLayout layout = UIUtil.createGridLayout((int)1);
            layout.marginWidth = 10;
            layout.marginHeight = 10;
            Composite composite = new Composite((Composite)super.createDialogArea(parent), 0);
            composite.setLayoutData((Object)UIUtil.createGridData());
            composite.setLayout((Layout)layout);
            Text text = new Text(composite, 2562);
            text.setLayoutData((Object)UIUtil.createGridData());
            text.setBackground(text.getDisplay().getSystemColor(1));
            text.setText(this.comment);
            text.selectAll();
            text.addModifyListener(e -> {
                String string = this.comment = text.getText();
            });
            text.addTraverseListener(e -> {
                if (e.detail == 4 && (e.stateMask & 0x40000) != 0) {
                    this.close();
                    e.doit = true;
                }
            });
            return composite;
        }
    }
}

