/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.warproducts.ui.editor;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.libra.warproducts.core.WARProduct;
import org.eclipse.libra.warproducts.ui.Messages;
import org.eclipse.libra.warproducts.ui.editor.ConfigurationPage;
import org.eclipse.pde.internal.core.iproduct.IProductFeature;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.core.iproduct.IProductPlugin;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.editor.FormOutlinePage;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.swt.graphics.Image;

public class WARProductOutlinePage
extends FormOutlinePage {
    private Object[] plugins;
    private Object[] libraries;
    private final Comparator libraryComparator = new LibraryComparator();

    public WARProductOutlinePage(PDEFormEditor editor) {
        super(editor);
    }

    public void sort(boolean sorting) {
    }

    public ILabelProvider createLabelProvider() {
        ILabelProvider labelProvider = super.createLabelProvider();
        return new ConfigurationPageLabelProvider(labelProvider);
    }

    protected Object[] getChildren(Object parent) {
        Object[] result = new Object[]{};
        if (parent instanceof ConfigurationPage) {
            result = this.getConfigurationPageChildren(parent);
        } else if (parent instanceof Object[]) {
            result = (Object[])parent;
        }
        return result;
    }

    private Object[] getConfigurationPageChildren(Object parent) {
        ConfigurationPage page = (ConfigurationPage)((Object)parent);
        IProductModel productModel = (IProductModel)page.getModel();
        WARProduct product = (WARProduct)productModel.getProduct();
        this.plugins = product.getPlugins();
        this.libraries = product.getLibraries();
        Arrays.sort(this.libraries, this.libraryComparator);
        Object[] result = new Object[]{this.plugins, this.libraries};
        return result;
    }

    protected String getParentPageId(Object item) {
        String result = super.getParentPageId(item);
        if (item instanceof IProductPlugin || item instanceof IPath) {
            result = "plugin-dependencies";
        }
        if (item instanceof IProductFeature) {
            result = "feature-dependencies";
        }
        return result;
    }

    private class ConfigurationPageLabelProvider
    extends LabelProvider {
        private final ILabelProvider labelProvider;
        private final PDELabelProvider pdeLabelProvider;

        public ConfigurationPageLabelProvider(ILabelProvider labelProvider) {
            this.labelProvider = labelProvider;
            this.pdeLabelProvider = PDEPlugin.getDefault().getLabelProvider();
        }

        public String getText(Object element) {
            String result = "";
            if (element instanceof IPath) {
                IPath path = (IPath)element;
                result = path.segment(path.segmentCount() - 1);
            } else {
                result = element == WARProductOutlinePage.this.libraries ? Messages.LibrarySectionLibraries : (element == WARProductOutlinePage.this.plugins ? Messages.OutlinePluginsTitle : this.labelProvider.getText(element));
            }
            return result;
        }

        public Image getImage(Object element) {
            Image result = null;
            result = element instanceof IPath || element == WARProductOutlinePage.this.libraries ? this.pdeLabelProvider.get(PDEPluginImages.DESC_JAR_LIB_OBJ) : (element == WARProductOutlinePage.this.plugins ? this.pdeLabelProvider.get(PDEPluginImages.DESC_PLUGIN_OBJ) : this.labelProvider.getImage(element));
            return result;
        }
    }

    private class LibraryComparator
    implements Comparator {
        private LibraryComparator() {
        }

        public int compare(Object o1, Object o2) {
            IPath p1 = (IPath)o1;
            IPath p2 = (IPath)o2;
            return p1.toOSString().compareTo(p2.toOSString());
        }
    }
}

