/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.project.registry;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.m2e.core.embedder.IMavenConfiguration;
import org.eclipse.m2e.core.embedder.IMavenExecutionContext;
import org.eclipse.m2e.core.internal.Messages;
import org.eclipse.m2e.core.internal.jobs.IBackgroundProcessingQueue;
import org.eclipse.m2e.core.internal.project.registry.MutableProjectRegistry;
import org.eclipse.m2e.core.internal.project.registry.ProjectRegistryManager;
import org.eclipse.m2e.core.project.MavenUpdateRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectRegistryRefreshJob
extends Job
implements IResourceChangeListener,
IEclipsePreferences.IPreferenceChangeListener,
IBackgroundProcessingQueue {
    private static final Logger log = LoggerFactory.getLogger(ProjectRegistryRefreshJob.class);
    private static final long SCHEDULE_DELAY = 1000L;
    private final Set<MavenUpdateRequest> queue = new LinkedHashSet<MavenUpdateRequest>();
    final ProjectRegistryManager manager;
    private final IMavenConfiguration mavenConfiguration;

    public ProjectRegistryRefreshJob(ProjectRegistryManager manager, IMavenConfiguration mavenConfiguration) {
        super(Messages.ProjectRegistryRefreshJob_title);
        this.manager = manager;
        this.mavenConfiguration = mavenConfiguration;
    }

    public void refresh(MavenUpdateRequest updateRequest) {
        this.queue(updateRequest);
        this.schedule(1000L);
    }

    /*
     * Exception decompiling
     */
    @Override
    public IStatus run(IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resourceChanged(IResourceChangeEvent event) {
        boolean offline = this.mavenConfiguration.isOffline();
        boolean forceDependencyUpdate = false;
        int type = event.getType();
        if (2 == type || 4 == type) {
            IProject project = (IProject)event.getResource();
            if (this.isMavenProject(project)) {
                this.queue(new MavenUpdateRequest(project, offline, forceDependencyUpdate));
            }
        } else {
            IResourceDelta[] projectDeltas;
            IResourceDelta delta = event.getDelta();
            IResourceDelta[] iResourceDeltaArray = projectDeltas = delta.getAffectedChildren();
            int n = projectDeltas.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta projectDelta = iResourceDeltaArray[n2];
                IProject project = (IProject)projectDelta.getResource();
                if (this.isMavenProject(project) && projectDelta.getKind() == 4 && (projectDelta.getFlags() & 0x4000) != 0) {
                    this.queue(new MavenUpdateRequest(project, offline, forceDependencyUpdate));
                }
                ++n2;
            }
        }
        Set<MavenUpdateRequest> set = this.queue;
        synchronized (set) {
            if (!this.queue.isEmpty()) {
                this.schedule(1000L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queue(MavenUpdateRequest updateRequest) {
        Set<MavenUpdateRequest> set = this.queue;
        synchronized (set) {
            this.queue.add(updateRequest);
            log.debug("Queued refresh request: {}", (Object)updateRequest.toString());
        }
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        boolean offline = this.mavenConfiguration.isOffline();
        boolean updateSnapshots = false;
        if (event.getSource() instanceof IProject) {
            this.queue(new MavenUpdateRequest((IProject)event.getSource(), offline, updateSnapshots));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Set<MavenUpdateRequest> set = this.queue;
        synchronized (set) {
            return this.queue.isEmpty();
        }
    }

    private boolean isMavenProject(IProject project) {
        try {
            return project != null && project.isAccessible() && project.hasNature("org.eclipse.m2e.core.maven2Nature");
        }
        catch (CoreException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return false;
        }
    }

    private /* synthetic */ Object lambda$0(MutableProjectRegistry mutableProjectRegistry, ArrayList arrayList, IProgressMonitor iProgressMonitor, IMavenExecutionContext context, IProgressMonitor theMonitor) throws CoreException {
        HashSet<IFile> offlineForceDependencyUpdate = new HashSet<IFile>();
        HashSet<IFile> offlineNotForceDependencyUpdate = new HashSet<IFile>();
        HashSet<IFile> notOfflineForceDependencyUpdate = new HashSet<IFile>();
        HashSet<IFile> notOfflineNotForceDependencyUpdate = new HashSet<IFile>();
        for (MavenUpdateRequest request : arrayList) {
            if (theMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (request.isOffline() && request.isForceDependencyUpdate()) {
                offlineForceDependencyUpdate.addAll(request.getPomFiles());
                continue;
            }
            if (request.isOffline() && !request.isForceDependencyUpdate()) {
                offlineNotForceDependencyUpdate.addAll(request.getPomFiles());
                continue;
            }
            if (!request.isOffline() && request.isForceDependencyUpdate()) {
                notOfflineForceDependencyUpdate.addAll(request.getPomFiles());
                continue;
            }
            if (request.isOffline() || request.isForceDependencyUpdate()) continue;
            notOfflineNotForceDependencyUpdate.addAll(request.getPomFiles());
        }
        if (theMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (!offlineForceDependencyUpdate.isEmpty()) {
            this.manager.getMaven().execute(true, true, (aContext, aMonitor) -> {
                this.manager.refresh(mutableProjectRegistry, offlineForceDependencyUpdate, aMonitor);
                return null;
            }, theMonitor);
        }
        if (theMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (!offlineNotForceDependencyUpdate.isEmpty()) {
            this.manager.getMaven().execute(true, false, (aContext, aMonitor) -> {
                this.manager.refresh(mutableProjectRegistry, offlineNotForceDependencyUpdate, aMonitor);
                return null;
            }, theMonitor);
        }
        if (theMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (!notOfflineForceDependencyUpdate.isEmpty()) {
            this.manager.getMaven().execute(false, true, (aContext, aMonitor) -> {
                this.manager.refresh(mutableProjectRegistry, notOfflineForceDependencyUpdate, aMonitor);
                return null;
            }, theMonitor);
        }
        if (theMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (!notOfflineNotForceDependencyUpdate.isEmpty()) {
            this.manager.getMaven().execute(false, false, (aContext, aMonitor) -> {
                this.manager.refresh(mutableProjectRegistry, notOfflineNotForceDependencyUpdate, aMonitor);
                return null;
            }, theMonitor);
        }
        IWorkspaceRoot rule = ResourcesPlugin.getWorkspace().getRoot();
        ProjectRegistryRefreshJob.getJobManager().beginRule((ISchedulingRule)rule, iProgressMonitor);
        try {
            this.manager.applyMutableProjectRegistry(mutableProjectRegistry, iProgressMonitor);
        }
        finally {
            ProjectRegistryRefreshJob.getJobManager().endRule((ISchedulingRule)rule);
        }
        return null;
    }
}

