/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.snapshot.registry;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.internal.MATPlugin;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.snapshot.extension.IClassSpecificNameResolver;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.registry.SubjectRegistry;
import org.eclipse.mat.util.MessageUtil;

public final class ClassSpecificNameResolverRegistry {
    private static ClassSpecificNameResolverRegistry instance = new ClassSpecificNameResolverRegistry();
    private RegistryImpl registry = new RegistryImpl();

    public static ClassSpecificNameResolverRegistry instance() {
        return instance;
    }

    private ClassSpecificNameResolverRegistry() {
    }

    @Deprecated
    public static void registerResolver(String className, IClassSpecificNameResolver resolver) {
        ClassSpecificNameResolverRegistry.instance().registry.resolvers.put(className, resolver);
    }

    public static String resolve(IObject object) {
        if (object == null) {
            throw new NullPointerException(Messages.ClassSpecificNameResolverRegistry_Error_MissingObject);
        }
        return ClassSpecificNameResolverRegistry.instance().registry.doResolve(object);
    }

    private static class RegistryImpl
    extends SubjectRegistry<IClassSpecificNameResolver> {
        private Map<String, IClassSpecificNameResolver> resolvers = new HashMap<String, IClassSpecificNameResolver>();

        public RegistryImpl() {
            this.init(MATPlugin.getDefault().getExtensionTracker(), "org.eclipse.mat.api.nameResolver");
        }

        @Override
        protected IClassSpecificNameResolver doCreateDelegate(IConfigurationElement configElement) throws CoreException {
            return (IClassSpecificNameResolver)configElement.createExecutableExtension("impl");
        }

        private String doResolve(IObject object) {
            try {
                IClass clazz = object.getClazz();
                while (clazz != null) {
                    IClassSpecificNameResolver resolver = this.resolvers.get(clazz.getName());
                    if (resolver != null) {
                        return resolver.resolve(object);
                    }
                    resolver = (IClassSpecificNameResolver)this.lookup(clazz.getName());
                    if (resolver != null) {
                        return resolver.resolve(object);
                    }
                    clazz = clazz.getSuperClass();
                }
                return null;
            }
            catch (RuntimeException e) {
                Logger.getLogger(ClassSpecificNameResolverRegistry.class.getName()).log(Level.SEVERE, MessageUtil.format((String)Messages.ClassSpecificNameResolverRegistry_ErrorMsg_DuringResolving, (Object[])new Object[]{object.getTechnicalName()}), e);
                return null;
            }
            catch (SnapshotException e) {
                Logger.getLogger(ClassSpecificNameResolverRegistry.class.getName()).log(Level.SEVERE, MessageUtil.format((String)Messages.ClassSpecificNameResolverRegistry_ErrorMsg_DuringResolving, (Object[])new Object[]{object.getTechnicalName()}), e);
                return null;
            }
        }
    }
}

