/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.github.ui.pr;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.op.MergeOperation;
import org.eclipse.egit.github.core.PullRequest;
import org.eclipse.egit.ui.internal.branch.BranchOperationUI;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.mylyn.internal.github.core.pr.PullRequestComposite;
import org.eclipse.mylyn.internal.github.core.pr.PullRequestConnector;
import org.eclipse.mylyn.internal.github.core.pr.PullRequestUtils;
import org.eclipse.mylyn.internal.github.ui.GitHubUi;
import org.eclipse.mylyn.internal.github.ui.TaskDataHandler;
import org.eclipse.mylyn.internal.github.ui.pr.Messages;
import org.eclipse.mylyn.tasks.core.data.TaskData;

public class MergePullRequestHandler
extends TaskDataHandler {
    public static final String ID = "org.eclipse.mylyn.github.ui.command.mergePullRequest";

    public Object execute(final ExecutionEvent event) throws ExecutionException {
        final TaskData data = this.getTaskData(event);
        if (data == null) {
            return null;
        }
        Job job = new Job(MessageFormat.format(Messages.MergePullRequestHandler_MergeJob, data.getTaskId())){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    PullRequestComposite prComp = PullRequestConnector.getPullRequest((TaskData)data);
                    if (prComp == null) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    PullRequest request = prComp.getRequest();
                    Repository repo = PullRequestUtils.getRepository((PullRequest)request);
                    if (repo == null) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    String target = request.getBase().getRef();
                    String branchName = PullRequestUtils.getBranchName((PullRequest)request);
                    try {
                        Ref sourceRef = repo.findRef(branchName);
                        if (sourceRef != null) {
                            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
                            if (!PullRequestUtils.isCurrentBranch((String)target, (Repository)repo)) {
                                progress.subTask(MessageFormat.format(Messages.MergePullRequestHandler_TaskCheckout, target));
                                BranchOperationUI.checkout((Repository)repo, (String)target).run((IProgressMonitor)progress.newChild(1));
                            }
                            progress.subTask(MessageFormat.format(Messages.MergePullRequestHandler_TaskMerge, branchName, target));
                            new MergeOperation(repo, branchName).execute((IProgressMonitor)progress.newChild(1));
                            MergePullRequestHandler.this.executeCallback(event);
                        }
                    }
                    catch (IOException e) {
                        GitHubUi.logError(e);
                    }
                    catch (CoreException e) {
                        GitHubUi.logError(e);
                    }
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                finally {
                    if (monitor != null) {
                        monitor.done();
                    }
                }
            }
        };
        this.schedule(job, event);
        return null;
    }
}

