/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.base.restrictions;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.passage.lic.api.conditions.evaluation.Permission;
import org.eclipse.passage.lic.api.diagnostic.Trouble;
import org.eclipse.passage.lic.api.diagnostic.TroubleCode;
import org.eclipse.passage.lic.api.restrictions.ExaminationCertificate;
import org.eclipse.passage.lic.api.restrictions.Restriction;
import org.eclipse.passage.lic.base.diagnostic.SumOfLists;
import org.eclipse.passage.lic.base.diagnostic.TroubleExplained;
import org.eclipse.passage.lic.internal.base.i18n.ExaminationExplanedMessages;

public final class ExaminationExplained
implements Supplier<String> {
    private final ExaminationCertificate certificate;

    public ExaminationExplained(ExaminationCertificate certificate) {
        Objects.requireNonNull(certificate, "ExaminationExplained::certificate");
        this.certificate = certificate;
    }

    @Override
    public String get() {
        StringBuilder out = new StringBuilder();
        List<String> features = this.features();
        out.append(String.format(ExaminationExplanedMessages.getString("ExaminationExplained.prelude"), features.size(), this.date(this.certificate.stamp()), this.certificate.restrictions().size())).append("\r\n");
        this.appendFeatures(features, out);
        this.appendRestriction(out);
        this.appendPermissions(out);
        this.appendAgreements(out);
        return out.toString();
    }

    private void appendFeatures(List<String> features, StringBuilder out) {
        out.append(String.format(ExaminationExplanedMessages.getString("ExaminationExplained.features_prelude"), features.size()));
        features.forEach(feature -> {
            StringBuilder stringBuilder2 = out.append("\t").append((String)feature).append("\r\n");
        });
    }

    private void appendRestriction(StringBuilder out) {
        out.append(String.format(ExaminationExplanedMessages.getString("ExaminationExplained.restrictions_prelude"), this.certificate.restrictions().size()));
        this.certificate.restrictions().forEach(restriction -> {
            StringBuilder stringBuilder2 = out.append("\t").append(ExaminationExplanedMessages.getString("ExaminationExplained.restriction_feature")).append(" [").append(this.feature((Restriction)restriction)).append("] ").append(ExaminationExplanedMessages.getString("ExaminationExplained.restriction_reason")).append(" [").append(this.reason(restriction.reason())).append("] ").append(ExaminationExplanedMessages.getString("ExaminationExplained.restriction_level")).append(" [").append(restriction.unsatisfiedRequirement().restrictionLevel()).append("] ").append("\r\n");
        });
    }

    private String reason(TroubleCode code) {
        return String.format("%d: %s", code.code(), code.explanation());
    }

    private void appendPermissions(StringBuilder out) {
        Collection satisfied = this.certificate.satisfied();
        out.append(String.format(ExaminationExplanedMessages.getString("ExaminationExplained.permissions_prelude"), satisfied.size()));
        satisfied.stream().map(arg_0 -> ((ExaminationCertificate)this.certificate).satisfaction(arg_0)).forEach(permission -> {
            StringBuilder stringBuilder2 = out.append("\t").append(ExaminationExplanedMessages.getString("ExaminationExplained.permission_feature")).append(" [").append(this.feature((Permission)permission)).append("]\r\n\t\t").append(ExaminationExplanedMessages.getString("ExaminationExplained.permission_period")).append(" [").append(this.date(permission.leaseDate())).append(" - ").append(this.date(permission.expireDate())).append("]\r\n\t\t").append(ExaminationExplanedMessages.getString("ExaminationExplained.permission_condition")).append(": ").append(ExaminationExplanedMessages.getString("ExaminationExplained.permission_condition_version")).append("=[").append(permission.condition().versionMatch().version()).append(", ").append(permission.condition().versionMatch().rule().identifier()).append("] ").append(ExaminationExplanedMessages.getString("ExaminationExplained.permission_condition_evaluation")).append("=[").append(permission.condition().evaluationInstructions().type().identifier()).append(", ").append(permission.condition().evaluationInstructions().expression()).append("] ").append("\r\n");
        });
    }

    private void appendAgreements(StringBuilder out) {
        Collection agreements = this.certificate.agreements();
        out.append(String.format("Agreements state contains %d entries.\r\n", agreements.size()));
        agreements.forEach(agreement -> {
            out.append("\tagreement [").append(agreement.definition().path()).append("]\r\n\tdeclared by [").append(agreement.origin()).append("]\r\n\thas [").append(agreement.acceptance().accepted() ? "accepted" : "not accepted").append("] state.\r\n");
            if (agreement.acceptance().error().isPresent()) {
                out.append("\terror:\r\n\t").append(new TroubleExplained((Trouble)agreement.acceptance().error().get()).get()).append("\r\n");
            }
        });
    }

    private List<String> features() {
        List permitted = this.certificate.satisfied().stream().map(arg_0 -> ((ExaminationCertificate)this.certificate).satisfaction(arg_0)).map(this::feature).distinct().collect(Collectors.toList());
        List prohibited = this.certificate.restrictions().stream().map(this::feature).distinct().collect(Collectors.toList());
        return new SumOfLists().apply(permitted, prohibited);
    }

    private String feature(Permission permission) {
        return String.format(ExaminationExplanedMessages.getString("ExaminationExplained.feature_format"), permission.condition().feature(), permission.condition().versionMatch().version());
    }

    private String feature(Restriction restriction) {
        return String.format(ExaminationExplanedMessages.getString("ExaminationExplained.feature_format"), restriction.unsatisfiedRequirement().feature().identifier(), restriction.unsatisfiedRequirement().feature().version());
    }

    private String date(ZonedDateTime date) {
        return DateTimeFormatter.RFC_1123_DATE_TIME.format(date);
    }
}

