/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.menukit;

import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.rwt.internal.protocol.WidgetOperationHandler;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class MenuOperationHandler
extends WidgetOperationHandler<Menu> {
    public MenuOperationHandler(Menu menu) {
        super(menu);
    }

    @Override
    public void handleNotify(Menu menu, String eventName, JsonObject properties) {
        if ("Show".equals(eventName)) {
            this.handleNotifyShow(menu);
        } else if ("Hide".equals(eventName)) {
            this.handleNotifyHide(menu);
        } else if ("Help".equals(eventName)) {
            this.handleNotifyHelp(menu);
        } else {
            super.handleNotify(menu, eventName, properties);
        }
    }

    public void handleNotifyShow(Menu menu) {
        menu.notifyListeners(22, new Event());
        MenuItem[] menuItemArray = menu.getItems();
        int n = menuItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem item = menuItemArray[n2];
            if (MenuOperationHandler.isArmingMenuItem(item)) {
                item.notifyListeners(30, new Event());
            }
            ++n2;
        }
    }

    public void handleNotifyHide(Menu menu) {
        menu.notifyListeners(23, new Event());
    }

    public void handleNotifyHelp(Menu menu) {
        menu.notifyListeners(28, new Event());
    }

    private static boolean isArmingMenuItem(MenuItem item) {
        return (item.getStyle() & 0x78) != 0;
    }
}

