/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.internal.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.sirius.common.tools.api.resource.FileModificationValidatorProvider;
import org.eclipse.sirius.common.tools.api.resource.IFileModificationValidator;
import org.eclipse.sirius.common.tools.internal.resource.FileModificationValidatorDescriptor;

public final class FileModificationValidatorProviderImpl
implements FileModificationValidatorProvider {
    private static final String VALIDATION_EXTENSION_POINT = "org.eclipse.sirius.common.fileModificationValidator";
    private Collection<FileModificationValidatorDescriptor> validationEditDescriptors = new HashSet<FileModificationValidatorDescriptor>();

    @Override
    public ArrayList<IFileModificationValidator> getFileModificationValidator() {
        ArrayList<IFileModificationValidator> fileModificationValidators = new ArrayList<IFileModificationValidator>();
        for (FileModificationValidatorDescriptor validationDescriptor : this.getValidationDescriptor()) {
            fileModificationValidators.add(validationDescriptor.createFileModificationValidator());
        }
        return fileModificationValidators;
    }

    @Override
    public Collection<FileModificationValidatorDescriptor> getValidationDescriptor() {
        if (this.validationEditDescriptors.isEmpty()) {
            this.loadExtensions();
        }
        return this.validationEditDescriptors;
    }

    private void loadExtensions() {
        this.parseExtensionMetadata();
    }

    private void parseExtensionMetadata() {
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = Platform.getExtensionRegistry().getExtensionPoint(VALIDATION_EXTENSION_POINT).getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configElements;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = configElements = extension.getConfigurationElements();
                int n3 = configElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configElement = iConfigurationElementArray[n4];
                    FileModificationValidatorDescriptor descriptor = new FileModificationValidatorDescriptor(configElement);
                    if (descriptor.createFileModificationValidator() != null) {
                        this.validationEditDescriptors.add(descriptor);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }
}

