/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.boundary;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuples;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.rete.boundary.ExternalInputEnumeratorNode;
import org.eclipse.viatra.query.runtime.rete.boundary.ExternalInputStatelessFilterNode;
import org.eclipse.viatra.query.runtime.rete.network.Network;
import org.eclipse.viatra.query.runtime.rete.network.Node;
import org.eclipse.viatra.query.runtime.rete.recipes.InputFilterRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.InputRecipe;
import org.eclipse.viatra.query.runtime.rete.remote.Address;

public final class InputConnector {
    Network network;
    private Map<IInputKey, Map<Tuple, Address<ExternalInputEnumeratorNode>>> externalInputRoots = CollectionsFactory.createMap();

    public InputConnector(Network network) {
        this.network = network;
    }

    public Network getNetwork() {
        return this.network;
    }

    public void connectInputFilter(InputFilterRecipe recipe, Node freshNode) {
        ExternalInputStatelessFilterNode inputNode = (ExternalInputStatelessFilterNode)freshNode;
        IInputKey inputKey = (IInputKey)recipe.getInputKey();
        inputNode.connectThroughContext(this.network.getEngine(), inputKey);
    }

    public void connectInput(InputRecipe recipe, Node freshNode) {
        ExternalInputEnumeratorNode inputNode = (ExternalInputEnumeratorNode)freshNode;
        IInputKey inputKey = (IInputKey)recipe.getInputKey();
        Tuple seed = this.nopSeed(inputKey);
        Address<ExternalInputEnumeratorNode> freshAddress = Address.of(inputNode);
        this.externalInputRoots.computeIfAbsent(inputKey, k -> CollectionsFactory.createMap()).put(seed, freshAddress);
        inputNode.connectThroughContext(this.network.getEngine(), inputKey, seed);
    }

    public Stream<Address<ExternalInputEnumeratorNode>> getAllExternalInputNodes() {
        return this.externalInputRoots.values().stream().flatMap(map -> map.values().stream());
    }

    public Collection<Address<ExternalInputEnumeratorNode>> getAllExternalInputNodesForKey(IInputKey inputKey) {
        return this.externalInputRoots.getOrDefault(inputKey, Collections.emptyMap()).values();
    }

    public Address<ExternalInputEnumeratorNode> getExternalInputNodeForKeyUnseeded(IInputKey inputKey) {
        return (Address)this.externalInputRoots.getOrDefault(inputKey, Collections.emptyMap()).get(this.nopSeed(inputKey));
    }

    public Address<ExternalInputEnumeratorNode> getExternalInputNode(IInputKey inputKey, Tuple seed) {
        if (seed == null) {
            seed = this.nopSeed(inputKey);
        }
        return (Address)this.externalInputRoots.getOrDefault(inputKey, Collections.emptyMap()).get(seed);
    }

    Tuple nopSeed(IInputKey inputKey) {
        return Tuples.flatTupleOf((Object[])new Object[inputKey.getArity()]);
    }
}

