/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.common.reflect;

import com.google.common.reflect.TypeToken;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Base64;

public class Types {
    private static Method isTypeTokenAssignableMethod;

    public static final TypeToken<?> deserialize(String string) {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(Base64.getDecoder().decode(string));
            ObjectInputStream ois = new ObjectInputStream(bis);
            TypeToken typeToken = (TypeToken)ois.readObject();
            ois.close();
            return typeToken;
        }
        catch (ClassCastException | ClassNotFoundException e) {
            throw new IllegalArgumentException("String does not seem to be of type TokeToken.");
        }
        catch (IOException e2) {
            throw new IllegalArgumentException("Could not deserialize TypeToken.");
        }
    }

    public static final boolean isAssignable(TypeToken<?> superType, TypeToken<?> subType) {
        if (isTypeTokenAssignableMethod == null) {
            try {
                isTypeTokenAssignableMethod = TypeToken.class.getDeclaredMethod("isSupertypeOf", TypeToken.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            if (isTypeTokenAssignableMethod == null) {
                try {
                    isTypeTokenAssignableMethod = TypeToken.class.getDeclaredMethod("isAssignableFrom", TypeToken.class);
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalArgumentException("Neither TypeToken.isAssignableFrom(TypeToken), nor TypeToken.isSuperTypeOf(TypeToken) seems to be supported by the given Guava version.");
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            return (Boolean)isTypeTokenAssignableMethod.invoke(superType, subType);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static final String serialize(TypeToken<?> typeToken) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream os = new ObjectOutputStream(bos);
            os.writeObject(typeToken);
            os.close();
            return Base64.getEncoder().encodeToString(bos.toByteArray());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not serialize " + typeToken);
        }
    }
}

