/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.project;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.archetype.ArchetypeGenerationRequest;
import org.apache.maven.archetype.ArchetypeGenerationResult;
import org.apache.maven.archetype.ArchetypeManager;
import org.apache.maven.archetype.catalog.Archetype;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ICallable;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.embedder.IMavenConfiguration;
import org.eclipse.m2e.core.embedder.IMavenExecutionContext;
import org.eclipse.m2e.core.embedder.MavenModelManager;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.internal.Messages;
import org.eclipse.m2e.core.internal.embedder.AbstractRunnable;
import org.eclipse.m2e.core.internal.embedder.MavenExecutionContext;
import org.eclipse.m2e.core.internal.lifecyclemapping.LifecycleMappingFactory;
import org.eclipse.m2e.core.internal.markers.IMavenMarkerManager;
import org.eclipse.m2e.core.internal.preferences.ProblemSeverity;
import org.eclipse.m2e.core.internal.project.LifecycleMappingConfiguration;
import org.eclipse.m2e.core.internal.project.MavenProjectImportResult;
import org.eclipse.m2e.core.internal.project.ResolverConfigurationIO;
import org.eclipse.m2e.core.internal.project.registry.MavenProjectFacade;
import org.eclipse.m2e.core.internal.project.registry.ProjectRegistryManager;
import org.eclipse.m2e.core.project.IMavenProjectChangedListener;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectImportResult;
import org.eclipse.m2e.core.project.IProjectConfigurationManager;
import org.eclipse.m2e.core.project.IProjectCreationListener;
import org.eclipse.m2e.core.project.LocalProjectScanner;
import org.eclipse.m2e.core.project.MavenProjectChangedEvent;
import org.eclipse.m2e.core.project.MavenProjectInfo;
import org.eclipse.m2e.core.project.MavenUpdateRequest;
import org.eclipse.m2e.core.project.ProjectImportConfiguration;
import org.eclipse.m2e.core.project.ResolverConfiguration;
import org.eclipse.m2e.core.project.configurator.AbstractProjectConfigurator;
import org.eclipse.m2e.core.project.configurator.ILifecycleMapping;
import org.eclipse.m2e.core.project.configurator.ProjectConfigurationRequest;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectConfigurationManager
implements IProjectConfigurationManager,
IMavenProjectChangedListener,
IResourceChangeListener {
    static final Logger log = LoggerFactory.getLogger(ProjectConfigurationManager.class);
    final ProjectRegistryManager projectManager;
    final MavenModelManager mavenModelManager;
    final IMavenMarkerManager mavenMarkerManager;
    final IMaven maven;
    final IMavenConfiguration mavenConfiguration;

    public ProjectConfigurationManager(IMaven maven, ProjectRegistryManager projectManager, MavenModelManager mavenModelManager, IMavenMarkerManager mavenMarkerManager, IMavenConfiguration mavenConfiguration) {
        this.projectManager = projectManager;
        this.mavenModelManager = mavenModelManager;
        this.mavenMarkerManager = mavenMarkerManager;
        this.maven = maven;
        this.mavenConfiguration = mavenConfiguration;
    }

    @Override
    public List<IMavenProjectImportResult> importProjects(Collection<MavenProjectInfo> projectInfos, ProjectImportConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        return this.importProjects(projectInfos, configuration, null, monitor);
    }

    @Override
    public List<IMavenProjectImportResult> importProjects(Collection<MavenProjectInfo> projectInfos, ProjectImportConfiguration configuration, IProjectCreationListener listener, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ProjectConfigurationManager_task_importing, (int)100);
        return this.maven.execute((context, monitor1) -> {
            long t1 = System.currentTimeMillis();
            ArrayList<MavenProjectImportResult> result = new ArrayList<MavenProjectImportResult>();
            int total = projectInfos.size();
            ArrayList<IProject> projects = new ArrayList<IProject>(total);
            int i = 0;
            List<IProject> existingProjects = this.findExistingProjectsToHideFrom();
            for (MavenProjectInfo projectInfo : projectInfos) {
                long t11 = System.currentTimeMillis();
                if (monitor1.isCanceled()) {
                    throw new OperationCanceledException();
                }
                SubMonitor subProgress = SubMonitor.convert((IProgressMonitor)progress.newChild(10), (int)(projectInfos.size() * 100));
                IProject project = this.create(projectInfo, configuration, listener, (IProgressMonitor)subProgress.newChild(100));
                result.add(new MavenProjectImportResult(projectInfo, project));
                if (project == null) continue;
                projects.add(project);
                long importTime = System.currentTimeMillis() - t11;
                log.debug("Imported project {} ({}/{}) in {} ms", new Object[]{project.getName(), ++i, total, importTime});
            }
            this.hideNestedProjectsFromParents(projects, existingProjects, monitor1);
            this.configureNewMavenProjects(projects, (IProgressMonitor)progress.newChild(90));
            long t2 = System.currentTimeMillis();
            log.info("Imported and configured {} project(s) in {} sec", (Object)total, (Object)((t2 - t1) / 1000L));
            return result;
        }, monitor);
    }

    private void setHidden(IResource resource) {
        try {
            resource.setHidden(true);
        }
        catch (Exception ex) {
            log.error("Failed to hide resource: " + (resource.getLocation() == null ? resource.getName() : resource.getLocation().toOSString()), (Throwable)ex);
        }
    }

    void hideNestedProjectsFromParents(List<IProject> projects, List<IProject> existingProjects, IProgressMonitor monitor) {
        if (!MavenPlugin.getMavenConfiguration().isHideFoldersOfNestedProjects()) {
            return;
        }
        HashMap<File, IProject> projectFileMap = new HashMap<File, IProject>();
        if (existingProjects != null) {
            for (IProject project : existingProjects) {
                if (project.getLocation() == null) continue;
                projectFileMap.put(project.getLocation().toFile(), project);
            }
        }
        for (IProject project : projects) {
            if (project.getLocation() == null) continue;
            projectFileMap.put(project.getLocation().toFile(), project);
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        HashSet<IProject> refreshedProjects = new HashSet<IProject>();
        for (IProject project : projects) {
            IFolder folder;
            File projectFile;
            IProject physicalParentProject;
            block13: {
                if (monitor.isCanceled()) {
                    return;
                }
                if (project.getLocation() == null || (physicalParentProject = (IProject)projectFileMap.get((projectFile = project.getLocation().toFile()).getParentFile())) == null) continue;
                if (!refreshedProjects.contains(physicalParentProject)) {
                    try {
                        try {
                            physicalParentProject.refreshLocal(1, monitor);
                        }
                        catch (Exception e) {
                            log.error("Failed to refresh " + physicalParentProject.getName(), (Throwable)e);
                            refreshedProjects.add(physicalParentProject);
                            break block13;
                        }
                    }
                    catch (Throwable throwable) {
                        refreshedProjects.add(physicalParentProject);
                        throw throwable;
                    }
                    refreshedProjects.add(physicalParentProject);
                }
            }
            if (!(folder = physicalParentProject.getFolder(projectFile.getName())).exists()) continue;
            this.setHidden((IResource)folder);
        }
    }

    void configureNewMavenProjects(List<IProject> projects, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ProjectConfigurationManager_task_configuring, (int)100);
        LinkedHashSet<IFile> pomFiles = new LinkedHashSet<IFile>();
        for (IProject project : projects) {
            pomFiles.add(project.getFile("pom.xml"));
        }
        progress.subTask(Messages.ProjectConfigurationManager_task_refreshing);
        this.projectManager.refresh(pomFiles, (IProgressMonitor)progress.newChild(75));
        SubMonitor subProgress = SubMonitor.convert((IProgressMonitor)progress.newChild(5), (int)(projects.size() * 100));
        ArrayList<IMavenProjectFacade> facades = new ArrayList<IMavenProjectFacade>(projects.size());
        for (IProject project : projects) {
            if (progress.isCanceled()) {
                throw new OperationCanceledException();
            }
            MavenProjectFacade facade = this.projectManager.create(project, (IProgressMonitor)subProgress.newChild(100));
            if (facade == null) continue;
            facades.add(facade);
        }
        this.sortProjects(facades, (IProgressMonitor)progress.newChild(5));
        subProgress = SubMonitor.convert((IProgressMonitor)progress.newChild(15), (int)(facades.size() * 100));
        for (IMavenProjectFacade facade : facades) {
            if (progress.isCanceled()) {
                throw new OperationCanceledException();
            }
            progress.subTask(NLS.bind((String)Messages.ProjectConfigurationManager_task_updating, (Object)facade.getProject().getName()));
            MavenProject mavenProject = facade.getMavenProject((IProgressMonitor)subProgress.newChild(5));
            ProjectConfigurationRequest request = new ProjectConfigurationRequest(facade, mavenProject);
            this.updateProjectConfiguration(request, (IProgressMonitor)subProgress.newChild(90));
        }
    }

    public void sortProjects(List<IMavenProjectFacade> facades, IProgressMonitor monitor) throws CoreException {
        HashMap<MavenProject, IMavenProjectFacade> mavenProjectToFacadeMap = new HashMap<MavenProject, IMavenProjectFacade>(facades.size());
        for (IMavenProjectFacade facade : facades) {
            mavenProjectToFacadeMap.put(facade.getMavenProject(monitor), facade);
        }
        facades.clear();
        for (MavenProject mavenProject : this.maven.getSortedProjects(new ArrayList<MavenProject>(mavenProjectToFacadeMap.keySet()))) {
            facades.add((IMavenProjectFacade)mavenProjectToFacadeMap.get(mavenProject));
        }
    }

    @Override
    public void updateProjectConfiguration(IProject project, IProgressMonitor monitor) throws CoreException {
        this.updateProjectConfiguration(new MavenUpdateRequest(project, this.mavenConfiguration.isOffline(), false), monitor);
    }

    @Override
    public void updateProjectConfiguration(MavenUpdateRequest request, IProgressMonitor monitor) throws CoreException {
        if (request.getPomFiles().size() != 1) {
            throw new IllegalArgumentException();
        }
        Map<String, IStatus> updateStatus = this.updateProjectConfiguration(request, true, true, monitor);
        IStatus status = updateStatus.values().iterator().next();
        if (!status.isOK()) {
            throw new CoreException(status);
        }
    }

    public Map<String, IStatus> updateProjectConfiguration(MavenUpdateRequest request, boolean updateConfiguration, boolean cleanProjects, IProgressMonitor monitor) {
        return this.updateProjectConfiguration(request, updateConfiguration, cleanProjects, false, monitor);
    }

    /*
     * Unable to fully structure code
     */
    public Map<String, IStatus> updateProjectConfiguration(MavenUpdateRequest request, boolean updateConfiguration, boolean cleanProjects, boolean refreshFromLocal, IProgressMonitor monitor) {
        try {
            return this.maven.execute(request.isOffline(), request.isForceDependencyUpdate(), (ICallable<Map>)LambdaMetafactory.metafactory(null, null, null, (Lorg/eclipse/m2e/core/embedder/IMavenExecutionContext;Lorg/eclipse/core/runtime/IProgressMonitor;)Ljava/lang/Object;, lambda$1(org.eclipse.m2e.core.project.MavenUpdateRequest boolean boolean boolean org.eclipse.m2e.core.embedder.IMavenExecutionContext org.eclipse.core.runtime.IProgressMonitor ), (Lorg/eclipse/m2e/core/embedder/IMavenExecutionContext;Lorg/eclipse/core/runtime/IProgressMonitor;)Ljava/util/Map;)((ProjectConfigurationManager)this, (MavenUpdateRequest)request, (boolean)updateConfiguration, (boolean)cleanProjects, (boolean)refreshFromLocal), monitor);
        }
        catch (CoreException ex) {
            result = new LinkedHashMap<String, IStatus>();
            ** for (pomFile : request.getPomFiles())
        }
lbl-1000:
        // 1 sources

        {
            result.put(pomFile.getProject().getName(), ex.getStatus());
            continue;
        }
lbl9:
        // 1 sources

        return result;
    }

    /*
     * Unable to fully structure code
     */
    Map<String, IStatus> updateProjectConfiguration0(Collection<IFile> pomFiles, boolean updateConfiguration, boolean cleanProjects, boolean refreshFromLocal, IProgressMonitor monitor) {
        block21: {
            monitor.beginTask(Messages.ProjectConfigurationManager_task_updating_projects, pomFiles.size() * (1 + (updateConfiguration != false ? 1 : 0) + (cleanProjects != false ? 1 : 0) + (refreshFromLocal != false ? 1 : 0)));
            l1 = System.currentTimeMillis();
            ProjectConfigurationManager.log.info("Update started");
            projects = new LinkedHashMap<IFile, IMavenProjectFacade>();
            updateStatus = new HashMap<String, IStatus>();
            pomsToRefresh = new ArrayList<IFile>();
            if (refreshFromLocal) {
                for (IFile pom : pomFiles) {
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    project = pom.getProject();
                    try {
                        project.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2));
                        pomsToRefresh.add(pom);
                    }
                    catch (CoreException ex) {
                        updateStatus.put(project.getName(), ex.getStatus());
                    }
                }
            } else {
                pomsToRefresh.addAll(pomFiles);
            }
            try {
                this.projectManager.refresh(pomsToRefresh, (IProgressMonitor)new SubProgressMonitor(monitor, pomFiles.size()));
                for (IFile pom : pomsToRefresh) {
                    project = pom.getProject();
                    facade = this.projectManager.getProject(project);
                    if (facade != null) {
                        projects.put(pom, facade);
                    }
                    updateStatus.put(project.getName(), Status.OK_STATUS);
                }
                break block21;
            }
            catch (CoreException ex) {
                ** for (pom : pomsToRefresh)
            }
lbl-1000:
            // 1 sources

            {
                project = pom.getProject();
                updateStatus.put(project.getName(), ex.getStatus());
                continue;
            }
        }
        if (updateConfiguration) {
            iterator = projects.entrySet().iterator();
            while (iterator.hasNext()) {
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                facade = (IMavenProjectFacade)iterator.next().getValue();
                monitor.subTask(facade.getProject().getName());
                submonitor = new SubProgressMonitor(monitor, 1, 2);
                try {
                    cfgRequest = new ProjectConfigurationRequest(facade, facade.getMavenProject((IProgressMonitor)submonitor));
                    this.updateProjectConfiguration(cfgRequest, (IProgressMonitor)submonitor);
                }
                catch (CoreException ex) {
                    iterator.remove();
                    updateStatus.put(facade.getProject().getName(), ex.getStatus());
                }
            }
        }
        if (cleanProjects) {
            iterator = projects.entrySet().iterator();
            while (iterator.hasNext()) {
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                facade = (IMavenProjectFacade)iterator.next().getValue();
                project = facade.getProject();
                monitor.subTask(project.getName());
                submonitor = new SubProgressMonitor(monitor, 1, 2);
                try {
                    status = (IStatus)updateStatus.get(project.getName());
                    if (status != null && !status.isOK()) continue;
                    project.build(15, (IProgressMonitor)submonitor);
                }
                catch (CoreException ex) {
                    iterator.remove();
                    updateStatus.put(project.getName(), ex.getStatus());
                }
            }
        }
        l2 = System.currentTimeMillis();
        ProjectConfigurationManager.log.info(NLS.bind((String)"Update completed: {0} sec", (Object)((l2 - l1) / 1000L)));
        return updateStatus;
    }

    private void updateProjectConfiguration(ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        IProject project = request.getProject();
        long start = System.currentTimeMillis();
        IMavenProjectFacade mavenProjectFacade = request.getMavenProjectFacade();
        log.debug("Updating project configuration for {}.", (Object)mavenProjectFacade.toString());
        this.addMavenNature(project, monitor);
        MavenProject mavenProject = request.getMavenProject();
        Properties mavenProperties = mavenProject.getProperties();
        String sourceEncoding = mavenProperties.getProperty("project.build.sourceEncoding");
        log.debug("Setting encoding for project {}: {}", (Object)project.getName(), (Object)sourceEncoding);
        project.setDefaultCharset(sourceEncoding, monitor);
        MavenExecutionContext executionContext = this.projectManager.createExecutionContext(mavenProjectFacade.getPom(), mavenProjectFacade.getResolverConfiguration());
        executionContext.execute(mavenProject, (context, monitor1) -> {
            ILifecycleMapping lifecycleMapping = this.getLifecycleMapping(mavenProjectFacade);
            if (lifecycleMapping != null) {
                this.mavenMarkerManager.deleteMarkers((IResource)mavenProjectFacade.getProject(), "org.eclipse.m2e.core.maven2Problem.configuration");
                lifecycleMapping.configure(request, monitor1);
                LifecycleMappingConfiguration.persist(request.getMavenProjectFacade(), monitor1);
            } else {
                log.debug("LifecycleMapping is null for project {}", (Object)mavenProjectFacade.toString());
            }
            return null;
        }, monitor);
        log.debug("Updated project configuration for {} in {} ms.", (Object)mavenProjectFacade.toString(), (Object)(System.currentTimeMillis() - start));
    }

    @Override
    public void enableMavenNature(final IProject project, final ResolverConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        monitor.subTask(Messages.ProjectConfigurationManager_task_enable_nature);
        this.maven.execute(new AbstractRunnable(){

            @Override
            protected void run(IMavenExecutionContext context, IProgressMonitor monitor) throws CoreException {
                ProjectConfigurationManager.this.enableBasicMavenNature(project, configuration, monitor);
                ProjectConfigurationManager.this.configureNewMavenProjects(Collections.singletonList(project), monitor);
            }
        }, monitor);
    }

    void enableBasicMavenNature(IProject project, ResolverConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        ResolverConfigurationIO.saveResolverConfiguration(project, configuration);
        this.addMavenNature(project, monitor);
    }

    private void addMavenNature(IProject project, IProgressMonitor monitor) throws CoreException {
        if (!project.hasNature("org.eclipse.m2e.core.maven2Nature")) {
            IProjectDescription description = project.getDescription();
            String[] prevNatures = description.getNatureIds();
            String[] newNatures = new String[prevNatures.length + 1];
            System.arraycopy(prevNatures, 0, newNatures, 1, prevNatures.length);
            newNatures[0] = "org.eclipse.m2e.core.maven2Nature";
            description.setNatureIds(newNatures);
            project.setDescription(description, monitor);
        }
    }

    @Override
    public void disableMavenNature(IProject project, IProgressMonitor monitor) throws CoreException {
        ILifecycleMapping lifecycleMapping;
        monitor.subTask(Messages.ProjectConfigurationManager_task_disable_nature);
        MavenProjectFacade facade = this.projectManager.create(project, monitor);
        if (facade != null && (lifecycleMapping = this.getLifecycleMapping(facade)) != null) {
            ProjectConfigurationRequest request = new ProjectConfigurationRequest(facade, facade.getMavenProject(monitor));
            lifecycleMapping.unconfigure(request, monitor);
        }
        project.deleteMarkers("org.eclipse.m2e.core.maven2Problem", true, 2);
        IProjectDescription description = project.getDescription();
        ArrayList<String> newNatures = new ArrayList<String>();
        String[] stringArray = description.getNatureIds();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String natureId = stringArray[n2];
            if (!"org.eclipse.m2e.core.maven2Nature".equals(natureId)) {
                newNatures.add(natureId);
            }
            ++n2;
        }
        description.setNatureIds(newNatures.toArray(new String[newNatures.size()]));
        this.removeMavenBuilder(project, description, monitor);
        project.setDescription(description, monitor);
        MavenPlugin.getMavenProjectRegistry().refresh(new MavenUpdateRequest(project, this.mavenConfiguration.isOffline(), false));
    }

    @Override
    public boolean addMavenBuilder(IProject project, IProjectDescription description, IProgressMonitor monitor) throws CoreException {
        boolean setProjectDescription = false;
        if (description == null) {
            description = project.getDescription();
            setProjectDescription = true;
        }
        ICommand mavenBuilder = null;
        ArrayList<ICommand> newSpec = new ArrayList<ICommand>();
        int i = 0;
        ICommand[] iCommandArray = description.getBuildSpec();
        int n = iCommandArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICommand command = iCommandArray[n2];
            if (this.isMavenBuilderCommand(project, command)) {
                mavenBuilder = command;
                if (i == description.getBuildSpec().length - 1) {
                    return false;
                }
            } else {
                newSpec.add(command);
            }
            ++i;
            ++n2;
        }
        if (mavenBuilder == null) {
            mavenBuilder = description.newCommand();
            mavenBuilder.setBuilderName("org.eclipse.m2e.core.maven2Builder");
        }
        newSpec.add(mavenBuilder);
        description.setBuildSpec(newSpec.toArray(new ICommand[newSpec.size()]));
        if (setProjectDescription) {
            project.setDescription(description, monitor);
        }
        return true;
    }

    @Override
    public boolean removeMavenBuilder(IProject project, IProjectDescription description, IProgressMonitor monitor) throws CoreException {
        boolean setProjectDescription = false;
        if (description == null) {
            description = project.getDescription();
            setProjectDescription = true;
        }
        boolean foundMavenBuilder = false;
        ArrayList<ICommand> newSpec = new ArrayList<ICommand>();
        ICommand[] iCommandArray = description.getBuildSpec();
        int n = iCommandArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICommand command = iCommandArray[n2];
            if (!this.isMavenBuilderCommand(project, command)) {
                newSpec.add(command);
            } else {
                foundMavenBuilder = true;
            }
            ++n2;
        }
        if (!foundMavenBuilder) {
            return false;
        }
        description.setBuildSpec(newSpec.toArray(new ICommand[newSpec.size()]));
        if (setProjectDescription) {
            project.setDescription(description, monitor);
        }
        return true;
    }

    private boolean isMavenBuilderCommand(IProject project, ICommand command) {
        return "org.eclipse.m2e.core.maven2Builder".equals(command.getBuilderName());
    }

    @Override
    public void createSimpleProject(IProject project, IPath location, Model model, String[] directories, ProjectImportConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        this.createSimpleProject(project, location, model, directories, configuration, null, monitor);
    }

    @Override
    public void createSimpleProject(IProject project, IPath location, Model model, String[] directories, ProjectImportConfiguration configuration, IProjectCreationListener listener, IProgressMonitor monitor) throws CoreException {
        String projectName = project.getName();
        monitor.beginTask(NLS.bind((String)Messages.ProjectConfigurationManager_task_creating, (Object)projectName), 5);
        monitor.subTask(Messages.ProjectConfigurationManager_task_creating_workspace);
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(projectName);
        description.setLocation(location);
        project.create(description, monitor);
        project.open(monitor);
        monitor.worked(1);
        monitor.subTask(Messages.ProjectConfigurationManager_task_creating_pom);
        IFile pomFile = project.getFile("pom.xml");
        this.mavenModelManager.createMavenModel(pomFile, model);
        monitor.worked(1);
        monitor.subTask(Messages.ProjectConfigurationManager_task_creating_folders);
        String[] stringArray = directories;
        int n = directories.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            ProjectConfigurationManager.createFolder(project.getFolder(element), false);
            ++n2;
        }
        monitor.worked(1);
        if (listener != null) {
            listener.projectCreated(project);
        }
        monitor.subTask(Messages.ProjectConfigurationManager_task_creating_project);
        this.enableMavenNature(project, configuration.getResolverConfiguration(), monitor);
        monitor.worked(1);
        IProject parent = this.findParentProject(model);
        if (parent != null) {
            this.hideNestedProjectsFromParents(Collections.singletonList(project), Collections.singletonList(parent), monitor);
            monitor.worked(1);
        }
    }

    private IProject findParentProject(Model model) {
        Parent parent = model.getParent();
        if (parent == null) {
            return null;
        }
        MavenProjectFacade parentProjectFacade = this.projectManager.getMavenProject(parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
        return parentProjectFacade == null ? null : parentProjectFacade.getProject();
    }

    public static void createFolder(IFolder folder, boolean derived) throws CoreException {
        if (!folder.exists()) {
            IContainer parent = folder.getParent();
            if (parent != null && !parent.exists()) {
                ProjectConfigurationManager.createFolder((IFolder)parent, false);
            }
            folder.create(true, true, null);
        }
        if (folder.isAccessible() && derived) {
            folder.setDerived(true);
        }
    }

    @Override
    @Deprecated
    public void createArchetypeProject(IProject project, IPath location, Archetype archetype, String groupId, String artifactId, String version, String javaPackage, Properties properties, ProjectImportConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        this.createArchetypeProjects(location, archetype, groupId, artifactId, version, javaPackage, properties, configuration, monitor);
    }

    @Override
    public List<IProject> createArchetypeProjects(IPath location, Archetype archetype, String groupId, String artifactId, String version, String javaPackage, Properties properties, ProjectImportConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        return this.createArchetypeProjects(location, archetype, groupId, artifactId, version, javaPackage, properties, configuration, null, monitor);
    }

    @Override
    public List<IProject> createArchetypeProjects(IPath location, Archetype archetype, String groupId, String artifactId, String version, String javaPackage, Properties properties, ProjectImportConfiguration configuration, IProjectCreationListener listener, IProgressMonitor monitor) throws CoreException {
        return this.maven.execute((context, monitor1) -> this.createArchetypeProjects0(location, archetype, groupId, artifactId, version, javaPackage, properties, configuration, listener, monitor1), monitor);
    }

    List<IProject> createArchetypeProjects0(IPath location, Archetype archetype, String groupId, String artifactId, String version, String javaPackage, Properties properties, ProjectImportConfiguration configuration, IProjectCreationListener listener, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(NLS.bind((String)Messages.ProjectConfigurationManager_task_creating_project1, (Object)artifactId), 2);
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        monitor.subTask(NLS.bind((String)Messages.ProjectConfigurationManager_task_executing_archetype, (Object)archetype.getGroupId(), (Object)archetype.getArtifactId()));
        if (location == null) {
            location = workspaceRoot.getLocation();
        }
        ArrayList<IProject> createdProjects = new ArrayList<IProject>();
        try {
            Artifact artifact = this.resolveArchetype(archetype, monitor);
            ArchetypeGenerationRequest request = new ArchetypeGenerationRequest().setTransferListener(this.maven.createTransferListener(monitor)).setArchetypeGroupId(artifact.getGroupId()).setArchetypeArtifactId(artifact.getArtifactId()).setArchetypeVersion(artifact.getVersion()).setArchetypeRepository(archetype.getRepository()).setGroupId(groupId).setArtifactId(artifactId).setVersion(version).setPackage(javaPackage).setLocalRepository(this.maven.getLocalRepository()).setRemoteArtifactRepositories(this.maven.getArtifactRepositories(true)).setProperties(properties).setOutputDirectory(location.toPortableString());
            ArchetypeGenerationResult result = this.getArchetyper().generateProjectFromArchetype(request);
            Exception cause = result.getCause();
            if (cause != null) {
                String msg = NLS.bind((String)Messages.ProjectConfigurationManager_error_unable_archetype, (Object)archetype.toString());
                log.error(msg, (Throwable)cause);
                throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, msg, (Throwable)cause));
            }
            monitor.worked(1);
            String projectFolder = location.append(artifactId).toFile().getAbsolutePath();
            LocalProjectScanner scanner = new LocalProjectScanner(workspaceRoot.getLocation().toFile(), projectFolder, true, this.mavenModelManager);
            scanner.run(monitor);
            Set<MavenProjectInfo> projectSet = this.collectProjects(scanner.getProjects());
            List<IMavenProjectImportResult> importResults = this.importProjects(projectSet, configuration, listener, monitor);
            for (IMavenProjectImportResult r : importResults) {
                IProject p = r.getProject();
                if (p == null || !p.exists()) continue;
                createdProjects.add(p);
            }
            monitor.worked(1);
        }
        catch (CoreException e) {
            throw e;
        }
        catch (InterruptedException e) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        catch (Exception ex) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e", Messages.ProjectConfigurationManager_error_failed, (Throwable)ex));
        }
        return Collections.unmodifiableList(createdProjects);
    }

    private Artifact resolveArchetype(Archetype a, IProgressMonitor monitor) throws CoreException {
        ArrayList<ArtifactRepository> repos = new ArrayList<ArtifactRepository>();
        repos.addAll(this.maven.getArtifactRepositories());
        String artifactRemoteRepository = a.getRepository();
        try {
            if (StringUtils.isNotBlank((String)artifactRemoteRepository)) {
                ArtifactRepository archetypeRepository = this.maven.createArtifactRepository(String.valueOf(a.getArtifactId()) + "-repo", a.getRepository().trim());
                repos.add(0, archetypeRepository);
            }
            this.maven.resolve(a.getGroupId(), a.getArtifactId(), a.getVersion(), "pom", null, repos, monitor);
            return this.maven.resolve(a.getGroupId(), a.getArtifactId(), a.getVersion(), "jar", null, repos, monitor);
        }
        catch (CoreException e) {
            StringBuilder sb = new StringBuilder();
            sb.append(Messages.ProjectConfigurationManager_error_resolve).append(a.getGroupId()).append(':').append(a.getArtifactId()).append(':').append(a.getVersion());
            sb.append(Messages.ProjectConfigurationManager_error_resolve2);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, sb.toString(), (Throwable)e));
        }
    }

    private ArchetypeManager getArchetyper() {
        return MavenPluginActivator.getDefault().getArchetypeManager().getArchetyper();
    }

    @Override
    public Set<MavenProjectInfo> collectProjects(Collection<MavenProjectInfo> projects) {
        return new LinkedHashSet<MavenProjectInfo>(){
            private static final long serialVersionUID = 1L;

            public Set<MavenProjectInfo> collectProjects(Collection<MavenProjectInfo> projects) {
                for (MavenProjectInfo projectInfo : projects) {
                    log.info("Collecting project info " + projectInfo);
                    this.add(projectInfo);
                    this.collectProjects(projectInfo.getProjects());
                }
                return this;
            }
        }.collectProjects(projects);
    }

    @Override
    public ISchedulingRule getRule() {
        return ResourcesPlugin.getWorkspace().getRuleFactory().buildRule();
    }

    IProject create(MavenProjectInfo projectInfo, ProjectImportConfiguration configuration, IProjectCreationListener listener, IProgressMonitor monitor) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        File pomFile = projectInfo.getPomFile();
        Model model = projectInfo.getModel();
        if (model == null) {
            try {
                Throwable throwable = null;
                Object var10_12 = null;
                try (InputStream pomStream = Files.newInputStream(pomFile.toPath(), new OpenOption[0]);){
                    model = this.maven.readModel(pomStream);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException ex) {
                log.error(Messages.MavenImpl_error_read_pom, (Throwable)ex);
            }
            projectInfo.setModel(model);
        }
        String projectName = configuration.getProjectName(model);
        File projectDir = pomFile.getParentFile();
        String projectParent = projectDir.getParentFile().getAbsolutePath();
        if (projectInfo.getBasedirRename() == 2) {
            File newProject = new File(projectDir.getParent(), projectName);
            if (!projectDir.equals(newProject)) {
                boolean renamed = projectDir.renameTo(newProject);
                if (!renamed) {
                    StringBuilder msg = new StringBuilder();
                    msg.append(NLS.bind((String)Messages.ProjectConfigurationManager_error_rename, (Object)projectDir.getAbsolutePath())).append('.');
                    if (newProject.exists()) {
                        msg.append(NLS.bind((String)Messages.ProjectConfigurationManager_error_targetDir, (Object)newProject.getAbsolutePath()));
                    }
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, msg.toString(), null));
                }
                projectInfo.setPomFile(this.getCanonicalPomFile(newProject));
                projectDir = newProject;
            }
        } else if (projectParent.equals(root.getLocation().toFile().getAbsolutePath())) {
            projectName = projectDir.getName();
        }
        monitor.subTask(NLS.bind((String)Messages.ProjectConfigurationManager_task_importing2, (Object)projectName));
        IProject project = root.getProject(projectName);
        if (project.exists()) {
            log.error("Project " + projectName + " already exists");
            return null;
        }
        if (projectDir.equals(root.getLocation().toFile())) {
            log.error("Can't create project " + projectName + " at Workspace folder");
            return null;
        }
        if (projectParent.equals(root.getLocation().toFile().getAbsolutePath())) {
            project.create(monitor);
        } else {
            IProjectDescription description = workspace.newProjectDescription(projectName);
            description.setLocation((IPath)new Path(projectDir.getAbsolutePath()));
            project.create(description, monitor);
        }
        if (!project.isOpen()) {
            project.open(monitor);
        }
        if (listener != null) {
            listener.projectCreated(project);
        }
        ResolverConfiguration resolverConfiguration = configuration.getResolverConfiguration();
        this.enableBasicMavenNature(project, resolverConfiguration, monitor);
        LifecycleMappingConfiguration.persistEmpty(project);
        return project;
    }

    private File getCanonicalPomFile(File projectDir) throws CoreException {
        try {
            return new File(projectDir.getCanonicalFile(), "pom.xml");
        }
        catch (IOException ex) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, NLS.bind((String)Messages.ProjectConfigurationManager_0, (Object)projectDir.getAbsolutePath()), null));
        }
    }

    @Override
    public void mavenProjectChanged(MavenProjectChangedEvent[] events, IProgressMonitor monitor) {
        MavenProjectChangedEvent[] mavenProjectChangedEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            MavenProjectChangedEvent event = mavenProjectChangedEventArray[n2];
            try {
                IMavenProjectFacade facade = event.getMavenProject();
                ILifecycleMapping lifecycleMapping = this.getLifecycleMapping(facade);
                if (lifecycleMapping != null) {
                    for (AbstractProjectConfigurator configurator : lifecycleMapping.getProjectConfigurators(facade, monitor)) {
                        configurator.mavenProjectChanged(event, monitor);
                    }
                }
                if (facade != null) {
                    LifecycleMappingConfiguration oldConfiguration;
                    ProblemSeverity outOfDateSeverity = ProblemSeverity.get(this.mavenConfiguration.getOutOfDateProjectSeverity());
                    this.mavenMarkerManager.deleteMarkers((IResource)facade.getProject(), "org.eclipse.m2e.core.maven2Problem.configuration");
                    if (!ProblemSeverity.ignore.equals((Object)outOfDateSeverity) && (oldConfiguration = LifecycleMappingConfiguration.restore(facade, monitor)) != null && LifecycleMappingFactory.isLifecycleMappingChanged(facade, oldConfiguration, monitor)) {
                        this.mavenMarkerManager.addMarker((IResource)facade.getProject(), "org.eclipse.m2e.core.maven2Problem.configuration", Messages.ProjectConfigurationUpdateRequired, -1, outOfDateSeverity.getSeverity());
                    }
                } else {
                    IMavenProjectFacade oldFacade = event.getOldMavenProject();
                    if (oldFacade != null) {
                        this.mavenMarkerManager.deleteMarkers((IResource)oldFacade.getPom(), "org.eclipse.m2e.core.maven2Problem.configuration");
                    }
                }
            }
            catch (CoreException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            ++n2;
        }
    }

    @Override
    public ILifecycleMapping getLifecycleMapping(IMavenProjectFacade projectFacade) {
        if (projectFacade == null) {
            return null;
        }
        return LifecycleMappingFactory.getLifecycleMapping(projectFacade);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 4 && event.getResource() instanceof IProject) {
            LifecycleMappingConfiguration.remove((IProject)event.getResource());
        }
    }

    @Override
    public ResolverConfiguration getResolverConfiguration(IProject project) {
        return ResolverConfigurationIO.readResolverConfiguration(project);
    }

    @Override
    public boolean setResolverConfiguration(IProject project, ResolverConfiguration configuration) {
        return ResolverConfigurationIO.saveResolverConfiguration(project, configuration);
    }

    List<IProject> findExistingProjectsToHideFrom() {
        if (!MavenPlugin.getMavenConfiguration().isHideFoldersOfNestedProjects()) {
            return Collections.emptyList();
        }
        IMavenProjectFacade[] existingFacades = this.projectManager.getProjects();
        if (existingFacades == null || existingFacades.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<IProject> existingProjects = new ArrayList<IProject>(existingFacades.length);
        IMavenProjectFacade[] iMavenProjectFacadeArray = existingFacades;
        int n = existingFacades.length;
        int n2 = 0;
        while (n2 < n) {
            IMavenProjectFacade f = iMavenProjectFacadeArray[n2];
            existingProjects.add(f.getProject());
            ++n2;
        }
        return existingProjects;
    }

    private /* synthetic */ Map lambda$1(MavenUpdateRequest mavenUpdateRequest, boolean bl, boolean bl2, boolean bl3, IMavenExecutionContext context, IProgressMonitor monitor1) throws CoreException {
        return this.updateProjectConfiguration0(mavenUpdateRequest.getPomFiles(), bl, bl2, bl3, monitor1);
    }
}

