/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.emf.validation.validity.ui.actions;

import java.net.URL;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ocl.examples.emf.validation.validity.RootNode;
import org.eclipse.ocl.examples.emf.validation.validity.ui.messages.ValidityUIMessages;
import org.eclipse.ocl.examples.emf.validation.validity.ui.plugin.ValidityUIPlugin;
import org.eclipse.ocl.examples.emf.validation.validity.ui.view.ValidityView;

public final class CollapseAllNodesAction
extends Action {
    private final @NonNull ValidityView validityView;
    private final boolean isValidatableCollapseAction;
    private final boolean isConstrainingCollapseAction;

    public CollapseAllNodesAction(@NonNull ValidityView validityView, boolean isValidatableCollapseAction, boolean isConstrainingCollapseAction) {
        super(ValidityUIMessages.ValidityView_Action_CollapseAllNodes_Title);
        this.validityView = validityView;
        this.isValidatableCollapseAction = isValidatableCollapseAction;
        this.isConstrainingCollapseAction = isConstrainingCollapseAction;
        if (isValidatableCollapseAction && isConstrainingCollapseAction) {
            this.setToolTipText(ValidityUIMessages.ValidityView_Action_CollapseAllNodes_ToolTipText);
        } else if (isValidatableCollapseAction) {
            this.setToolTipText(ValidityUIMessages.ValidityView_Action_CollapseAllValidatableNodes_ToolTipText);
        } else if (isConstrainingCollapseAction) {
            this.setToolTipText(ValidityUIMessages.ValidityView_Action_CollapseAllConstrainingNodes_ToolTipText);
        }
        URL image = (URL)ValidityUIPlugin.INSTANCE.getImage(ValidityUIMessages.ValidityView_Action_CollapseAllNodes_ImageLocation);
        this.setImageDescriptor(ImageDescriptor.createFromURL((URL)image));
    }

    public void run() {
        RootNode rootNode = this.validityView.getValidityManager().getRootNode();
        if (rootNode != null) {
            if (this.isValidatableCollapseAction && this.isConstrainingCollapseAction) {
                this.validityView.getValidatableNodesViewer().collapseAll();
                this.validityView.getConstrainingNodesViewer().collapseAll();
            } else if (this.isValidatableCollapseAction) {
                this.validityView.getValidatableNodesViewer().collapseAll();
            } else if (this.isConstrainingCollapseAction) {
                this.validityView.getConstrainingNodesViewer().collapseAll();
            }
        }
    }
}

