/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.properties.modelelements;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.papyrus.infra.emf.expressions.booleanexpressions.IBooleanEObjectExpression;
import org.eclipse.papyrus.infra.emf.expressions.properties.utils.BooleanEObjectExpressionPropertyEditorFactory;
import org.eclipse.papyrus.infra.nattable.contentprovider.MatrixDirectionContentProvider;
import org.eclipse.papyrus.infra.nattable.contentprovider.MatrixRelationshipOwnerStrategyContentProvider;
import org.eclipse.papyrus.infra.nattable.manager.table.IMatrixTableWidgetManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.NattablePackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.IAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.LocalTableHeaderAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.NattableaxisconfigurationPackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.TreeFillingConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.AbstractAxisProvider;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.IMasterAxisProvider;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.NattableaxisproviderPackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablecelleditor.GenericRelationshipMatrixCellEditorConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablecelleditor.ICellEditorConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablecelleditor.NattablecelleditorPackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablewrapper.EObjectWrapper;
import org.eclipse.papyrus.infra.nattable.provider.MatrixRelationshipDirectionLabelProvider;
import org.eclipse.papyrus.infra.nattable.provider.MatrixRelationshipOwnerStrategyLabelProvider;
import org.eclipse.papyrus.infra.properties.ui.modelelement.EMFModelElement;
import org.eclipse.papyrus.infra.ui.emf.utils.ProviderHelper;
import org.eclipse.papyrus.infra.widgets.creation.ReferenceValueFactory;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.uml.nattable.properties.observables.MatrixCellContentsFilterObservableValue;
import org.eclipse.papyrus.uml.nattable.properties.observables.MatrixColumnRootFilterObservableValue;
import org.eclipse.papyrus.uml.nattable.properties.observables.MatrixColumnSourcesEMFObservableList;
import org.eclipse.papyrus.uml.nattable.properties.observables.MatrixDirectionObservableValue;
import org.eclipse.papyrus.uml.nattable.properties.observables.MatrixManagedElementTypeObservableValue;
import org.eclipse.papyrus.uml.nattable.properties.observables.MatrixRelationshipOwnerStrategyObservableValue;
import org.eclipse.papyrus.uml.nattable.properties.observables.MatrixRelationshipOwneryObservableValue;
import org.eclipse.papyrus.uml.nattable.properties.observables.MatrixRowRootFilterObservableValue;
import org.eclipse.papyrus.uml.nattable.properties.observables.MatrixRowSourcesEMFObservableList;
import org.eclipse.papyrus.uml.nattable.properties.providers.GenericRelationshipMatrixElementTypeContentProvider;
import org.eclipse.papyrus.uml.nattable.properties.providers.GenericRelationshipMatrixElementTypeLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class GenericUMLRelationshipMatrixModelElement
extends EMFModelElement {
    private IMatrixTableWidgetManager tableModelManager;
    private Adapter changeListener;
    private List<EStructuralFeature> interestingFeatures;
    private List<EObject> listenEObjects;

    public GenericUMLRelationshipMatrixModelElement(IMatrixTableWidgetManager tableManager, TransactionalEditingDomain domain) {
        super((EObject)tableManager.getTable(), (EditingDomain)domain);
        this.tableModelManager = tableManager;
        this.init();
    }

    protected void init() {
        this.listenEObjects = new ArrayList<EObject>();
        this.interestingFeatures = new ArrayList<EStructuralFeature>();
        this.interestingFeatures.add((EStructuralFeature)NattablePackage.eINSTANCE.getTable_LocalColumnHeaderAxisConfiguration());
        this.interestingFeatures.add((EStructuralFeature)NattableaxisconfigurationPackage.eINSTANCE.getLocalTableHeaderAxisConfiguration_AxisManagerConfigurations());
        this.interestingFeatures.add((EStructuralFeature)NattableaxisconfigurationPackage.eINSTANCE.getTreeFillingConfiguration_AxisUsedAsAxisProvider());
        this.interestingFeatures.add((EStructuralFeature)NattableaxisconfigurationPackage.eINSTANCE.getTreeFillingConfiguration_FilterRule());
        this.interestingFeatures.add((EStructuralFeature)NattableaxisproviderPackage.eINSTANCE.getIMasterAxisProvider_Sources());
        this.interestingFeatures.add((EStructuralFeature)NattablecelleditorPackage.eINSTANCE.getGenericRelationshipMatrixCellEditorConfiguration_CellContentsFilter());
        this.interestingFeatures.add((EStructuralFeature)NattablecelleditorPackage.eINSTANCE.getGenericRelationshipMatrixCellEditorConfiguration_Direction());
        this.interestingFeatures.add((EStructuralFeature)NattablecelleditorPackage.eINSTANCE.getGenericRelationshipMatrixCellEditorConfiguration_EditedElement());
        this.interestingFeatures.add((EStructuralFeature)NattablecelleditorPackage.eINSTANCE.getGenericRelationshipMatrixCellEditorConfiguration_RelationshipOwner());
        this.interestingFeatures.add((EStructuralFeature)NattablecelleditorPackage.eINSTANCE.getGenericRelationshipMatrixCellEditorConfiguration_RelationshipOwnerStrategy());
        this.changeListener = new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                if (GenericUMLRelationshipMatrixModelElement.this.interestingFeatures.contains(msg.getFeature())) {
                    GenericUMLRelationshipMatrixModelElement.this.updateValues();
                }
            }
        };
        this.cleanAndReinitListenObjects();
    }

    private void cleanAndReinitListenObjects() {
        AbstractAxisProvider axisProvider2;
        AbstractAxisProvider axisProvider;
        ICellEditorConfiguration cellEditorConfiguration;
        LocalTableHeaderAxisConfiguration rowHeaderAxisConfiguration;
        this.removeListener();
        Table table = this.getEditedTable();
        if (table == null) {
            return;
        }
        this.registerListener((EObject)table);
        LocalTableHeaderAxisConfiguration columnHeaderAxisConfiguration = table.getLocalColumnHeaderAxisConfiguration();
        if (columnHeaderAxisConfiguration instanceof LocalTableHeaderAxisConfiguration) {
            this.registerListener((EObject)columnHeaderAxisConfiguration);
            for (IAxisConfiguration current : columnHeaderAxisConfiguration.getOwnedAxisConfigurations()) {
                if (!(current instanceof TreeFillingConfiguration) || ((TreeFillingConfiguration)current).getDepth() != 1) continue;
                Iterator treeFillingConfiguration = (TreeFillingConfiguration)current;
                this.registerListener((EObject)treeFillingConfiguration);
                IAxis provider = treeFillingConfiguration.getAxisUsedAsAxisProvider();
                this.registerListener((EObject)provider);
                IBooleanEObjectExpression filterRule = treeFillingConfiguration.getFilterRule();
                this.registerListener((EObject)filterRule);
            }
        }
        if ((rowHeaderAxisConfiguration = table.getLocalRowHeaderAxisConfiguration()) instanceof LocalTableHeaderAxisConfiguration) {
            this.registerListener((EObject)rowHeaderAxisConfiguration);
            for (IAxisConfiguration current : rowHeaderAxisConfiguration.getOwnedAxisConfigurations()) {
                if (!(current instanceof TreeFillingConfiguration) || ((TreeFillingConfiguration)current).getDepth() != 1) continue;
                TreeFillingConfiguration treeFillingConfiguration = (TreeFillingConfiguration)current;
                this.registerListener((EObject)treeFillingConfiguration);
                IAxis provider = treeFillingConfiguration.getAxisUsedAsAxisProvider();
                this.registerListener((EObject)provider);
                IBooleanEObjectExpression filterRule = treeFillingConfiguration.getFilterRule();
                this.registerListener((EObject)filterRule);
            }
        }
        if ((cellEditorConfiguration = table.getOwnedCellEditorConfigurations()) != null) {
            this.registerListener((EObject)cellEditorConfiguration);
            if (cellEditorConfiguration instanceof GenericRelationshipMatrixCellEditorConfiguration) {
                GenericRelationshipMatrixCellEditorConfiguration tmp = (GenericRelationshipMatrixCellEditorConfiguration)cellEditorConfiguration;
                IBooleanEObjectExpression filter = tmp.getCellContentsFilter();
                this.registerListener((EObject)filter);
            }
        }
        if ((axisProvider = this.getEditedTable().getCurrentColumnAxisProvider()) instanceof IMasterAxisProvider) {
            this.registerListener((EObject)axisProvider);
        }
        if ((axisProvider2 = this.getEditedTable().getCurrentRowAxisProvider()) instanceof IMasterAxisProvider) {
            this.registerListener((EObject)axisProvider2);
        }
    }

    private void registerListener(EObject eobject) {
        if (eobject != null && this.changeListener != null) {
            eobject.eAdapters().add((Object)this.changeListener);
            this.listenEObjects.add(eobject);
        }
    }

    private void removeListener() {
        for (EObject current : this.listenEObjects) {
            current.eAdapters().remove((Object)this.changeListener);
        }
        this.listenEObjects.clear();
    }

    public void dispose() {
        this.removeListener();
        this.tableModelManager = null;
        super.dispose();
        this.changeListener = null;
    }

    private Table getEditedTable() {
        return this.tableModelManager.getTable();
    }

    public void updateTableWidgetMatrixManager(IMatrixTableWidgetManager tableModelManager) {
        this.tableModelManager = tableModelManager;
        this.updateValues();
    }

    private void updateValues() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                GenericUMLRelationshipMatrixModelElement.this.cleanAndReinitListenObjects();
                Event event = new Event();
                for (IObservable current : GenericUMLRelationshipMatrixModelElement.this.getObservables().values()) {
                    if (current.isDisposed() || !(current instanceof Listener)) continue;
                    ((Listener)current).handleEvent(event);
                }
            }
        });
    }

    protected IObservable doGetObservable(String propertyPath) {
        Object value = null;
        value = "rowSources".equals(propertyPath) ? new MatrixRowSourcesEMFObservableList(this.getDomain(), this.getEditedTable(), this.tableModelManager) : ("columnSources".equals(propertyPath) ? new MatrixColumnSourcesEMFObservableList(this.getDomain(), this.getEditedTable(), this.tableModelManager) : ("rowFilter".equals(propertyPath) ? new MatrixRowRootFilterObservableValue(this.getEditedTable()) : ("columnFilter".equals(propertyPath) ? new MatrixColumnRootFilterObservableValue(this.getEditedTable()) : ("managedElementType".equals(propertyPath) ? new MatrixManagedElementTypeObservableValue(this.getEditedTable()) : ("relationshipDirection".equals(propertyPath) ? new MatrixDirectionObservableValue(this.getEditedTable()) : ("cellContentsFilter".equals(propertyPath) ? new MatrixCellContentsFilterObservableValue(this.getEditedTable()) : ("relationshipOwnerStrategy".equals(propertyPath) ? new MatrixRelationshipOwnerStrategyObservableValue(this.getEditedTable()) : ("relationshipOwner".equals(propertyPath) ? new MatrixRelationshipOwneryObservableValue(this.getEditedTable()) : super.doGetObservable(propertyPath)))))))));
        return value;
    }

    public IStaticContentProvider getContentProvider(String propertyPath) {
        Object provider = null;
        if ("rowSources".equals(propertyPath)) {
            ResourceSet resourceSet = this.getRoot(this.getEditedTable().getContext()).eResource().getResourceSet();
            provider = ProviderHelper.encapsulateProvider((ITreeContentProvider)ProviderHelper.getContentProvider((ResourceSet)resourceSet), (ResourceSet)resourceSet, (String)"rowSources");
        } else if ("columnSources".equals(propertyPath)) {
            ResourceSet resourceSet = this.getRoot(this.getEditedTable().getContext()).eResource().getResourceSet();
            provider = ProviderHelper.encapsulateProvider((ITreeContentProvider)ProviderHelper.getContentProvider((ResourceSet)resourceSet), (ResourceSet)resourceSet, (String)"columnSources");
        } else if ("managedElementType".equals(propertyPath)) {
            provider = new GenericRelationshipMatrixElementTypeContentProvider(this.getRoot(this.getEditedTable().getContext()));
        } else if ("relationshipDirection".equals(propertyPath)) {
            provider = new MatrixDirectionContentProvider();
        } else if ("relationshipOwnerStrategy".equals(propertyPath)) {
            provider = new MatrixRelationshipOwnerStrategyContentProvider();
        } else if ("relationshipOwner".equals(propertyPath)) {
            ResourceSet resourceSet = this.getRoot(this.getEditedTable().getContext()).eResource().getResourceSet();
            provider = ProviderHelper.encapsulateProvider((ITreeContentProvider)ProviderHelper.getContentProvider((ResourceSet)resourceSet), (ResourceSet)resourceSet, (String)"relationshipOwner");
        } else {
            provider = super.getContentProvider(propertyPath);
        }
        return provider;
    }

    public EStructuralFeature getFeature(String propertyPath) {
        if ("rowFilter".equals(propertyPath) || "columnFilter".equals(propertyPath)) {
            return NattableaxisconfigurationPackage.eINSTANCE.getTreeFillingConfiguration_FilterRule();
        }
        if ("rowSources".equals(propertyPath) || "columnSources".equals(propertyPath)) {
            return NattableaxisproviderPackage.eINSTANCE.getIMasterAxisProvider_Sources();
        }
        if ("relationshipDirection".equals(propertyPath)) {
            return NattablecelleditorPackage.eINSTANCE.getGenericRelationshipMatrixCellEditorConfiguration_Direction();
        }
        if ("managedElementType".equals(propertyPath)) {
            return NattablecelleditorPackage.eINSTANCE.getGenericRelationshipMatrixCellEditorConfiguration_EditedElement();
        }
        if ("cellContentsFilter".equals(propertyPath)) {
            return NattablecelleditorPackage.eINSTANCE.getGenericRelationshipMatrixCellEditorConfiguration_CellContentsFilter();
        }
        if ("relationshipOwnerStrategy".equals(propertyPath)) {
            return NattablecelleditorPackage.eINSTANCE.getGenericRelationshipMatrixCellEditorConfiguration_RelationshipOwnerStrategy();
        }
        if ("relationshipOwner".equals(propertyPath)) {
            return NattablecelleditorPackage.eINSTANCE.getGenericRelationshipMatrixCellEditorConfiguration_RelationshipOwner();
        }
        return super.getFeature(propertyPath);
    }

    private EObject getRoot(EObject obj) {
        EObject current = obj;
        EObject parent = obj.eContainer();
        while (parent != null) {
            current = parent;
            parent = parent.eContainer();
        }
        return current;
    }

    public ILabelProvider getLabelProvider(String propertyPath) {
        ILabelProvider provider = super.getLabelProvider(propertyPath);
        if ("columnSources".equals(propertyPath) || "rowSources".equals(propertyPath) || "relationshipOwner".equals(propertyPath)) {
            provider = new WrappedLabelProvider(provider);
        }
        if ("relationshipDirection".equals(propertyPath)) {
            provider = new MatrixRelationshipDirectionLabelProvider();
        }
        if ("relationshipOwnerStrategy".equals(propertyPath)) {
            provider = new MatrixRelationshipOwnerStrategyLabelProvider();
        }
        if ("managedElementType".equals(propertyPath)) {
            provider = new GenericRelationshipMatrixElementTypeLabelProvider();
        }
        return provider;
    }

    public boolean isOrdered(String propertyPath) {
        if ("rowSources".equals(propertyPath)) {
            return false;
        }
        if ("columnSources".equals(propertyPath)) {
            return false;
        }
        if ("cellContentsFilter".equals(propertyPath)) {
            return false;
        }
        return super.isOrdered(propertyPath);
    }

    public boolean getDirectCreation(String propertyPath) {
        if ("rowSources".equals(propertyPath) || "columnSources".equals(propertyPath)) {
            return false;
        }
        if ("relationshipOwner".equals(propertyPath)) {
            return false;
        }
        return super.getDirectCreation(propertyPath);
    }

    public ReferenceValueFactory getValueFactory(String propertyPath) {
        if ("rowFilter".equals(propertyPath) || "columnFilter".equals(propertyPath)) {
            if (this.domain instanceof AdapterFactoryEditingDomain) {
                BooleanEObjectExpressionPropertyEditorFactory factory = new BooleanEObjectExpressionPropertyEditorFactory((AdapterFactoryEditingDomain)this.domain, NattableaxisconfigurationPackage.eINSTANCE.getTreeFillingConfiguration_FilterRule());
                factory.setNsUri("http://www.eclipse.org/papyrus/umlexpressions");
                return factory;
            }
        } else if ("cellContentsFilter".equals(propertyPath)) {
            if (this.domain instanceof AdapterFactoryEditingDomain) {
                BooleanEObjectExpressionPropertyEditorFactory factory = new BooleanEObjectExpressionPropertyEditorFactory((AdapterFactoryEditingDomain)this.domain, NattablecelleditorPackage.eINSTANCE.getGenericRelationshipMatrixCellEditorConfiguration_CellContentsFilter());
                factory.setNsUri("http://www.eclipse.org/papyrus/umlexpressions");
                return factory;
            }
        } else if ("relationshipOwner".equals(propertyPath)) {
            return null;
        }
        return super.getValueFactory(propertyPath);
    }

    private class WrappedLabelProvider
    implements ILabelProvider {
        private ILabelProvider wrappedLabelProvider;

        public WrappedLabelProvider(ILabelProvider provider) {
            this.wrappedLabelProvider = provider;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getImage(Object element) {
            if (element instanceof EObjectWrapper) {
                return this.wrappedLabelProvider.getImage((Object)((EObjectWrapper)element).getElement());
            }
            return this.wrappedLabelProvider.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof EObjectWrapper) {
                return this.wrappedLabelProvider.getText((Object)((EObjectWrapper)element).getElement());
            }
            return this.wrappedLabelProvider.getText(element);
        }
    }
}

