/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.resources.util;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.ContentHandler;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.xmi.impl.RootXMLContentHandlerImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLContentHandlerImpl;
import org.eclipse.uml2.types.TypesPackage;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.UMLPlugin;
import org.eclipse.uml2.uml.profile.standard.StandardPackage;
import org.eclipse.uml2.uml.resource.UMLResource;
import org.eclipse.uml2.uml.util.UMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UMLResourcesUtil
extends UMLUtil {
    private static final ContentHandler XMI_CONTENT_HANDLER = new XMLContentHandlerImpl.XMI();
    private static final ContentHandler UML2_1_0_0_CONTENT_HANDLER = new RootXMLContentHandlerImpl("org.eclipse.uml2", new String[]{"uml2"}, "xmi", "http://www.eclipse.org/uml2/1.0.0/UML", null);
    private static final ContentHandler UML2_2_0_0_CONTENT_HANDLER = new RootXMLContentHandlerImpl("org.eclipse.uml2.uml_2_0_0", new String[]{"uml"}, "xmi", "http://www.eclipse.org/uml2/2.0.0/UML", null);
    private static final ContentHandler UML2_2_1_0_CONTENT_HANDLER = new RootXMLContentHandlerImpl("org.eclipse.uml2.uml_2_1_0", new String[]{"uml"}, "xmi", "http://www.eclipse.org/uml2/2.1.0/UML", null);
    private static final ContentHandler UML2_3_0_0_CONTENT_HANDLER = new RootXMLContentHandlerImpl("org.eclipse.uml2.uml_3_0_0", new String[]{"uml"}, "xmi", "http://www.eclipse.org/uml2/3.0.0/UML", null);
    private static final ContentHandler UML2_4_0_0_CONTENT_HANDLER = new RootXMLContentHandlerImpl("org.eclipse.uml2.uml_4_0_0", new String[]{"uml"}, "xmi", "http://www.eclipse.org/uml2/4.0.0/UML", null);
    private static final ContentHandler UML2_5_0_0_CONTENT_HANDLER = new RootXMLContentHandlerImpl("org.eclipse.uml2.uml_5_0_0", new String[]{"uml"}, "xmi", "http://www.eclipse.org/uml2/5.0.0/UML", null);
    private static final ContentHandler OMG_2_1_CONTENT_HANDLER = new RootXMLContentHandlerImpl("org.omg.uml_2_1", new String[]{"xmi"}, "xmi", "http://schema.omg.org/spec/UML/2.1", null);
    private static final ContentHandler OMG_2_1_1_CONTENT_HANDLER = new RootXMLContentHandlerImpl("org.omg.uml_2_1_1", new String[]{"xmi"}, "xmi", "http://schema.omg.org/spec/UML/2.1.1", null);
    private static final ContentHandler OMG_2_2_CONTENT_HANDLER = new RootXMLContentHandlerImpl("org.omg.uml_2_2", new String[]{"xmi"}, "xmi", "http://schema.omg.org/spec/UML/2.2", null);
    private static final ContentHandler OMG_2_4_CONTENT_HANDLER = new RootXMLContentHandlerImpl("org.omg.uml_2_4", new String[]{"xmi"}, "xmi", "http://www.omg.org/spec/UML/20100901", null);
    private static final ContentHandler OMG_2_4_1_CONTENT_HANDLER = new RootXMLContentHandlerImpl("org.omg.uml_2_4_1", new String[]{"xmi"}, "xmi", "http://www.omg.org/spec/UML/20110701", null);
    private static final ContentHandler OMG_2_5_CONTENT_HANDLER = new RootXMLContentHandlerImpl("org.omg.uml_2_5", new String[]{"xmi"}, "xmi", "http://www.omg.org/spec/UML/20131001", null);
    private static final ContentHandler CMOF_2_0_CONTENT_HANDLER = new RootXMLContentHandlerImpl("org.omg.mof.cmof_2_0", new String[]{"cmof", "xmi"}, "xmi", "http://schema.omg.org/spec/MOF/2.0/cmof.xml", null);
    private static final ContentHandler CMOF_2_4_CONTENT_HANDLER = new RootXMLContentHandlerImpl("org.omg.mof.cmof_2_4", new String[]{"cmof", "xmi"}, "xmi", "http://www.omg.org/spec/MOF/20100901/cmof.xmi", null);
    private static final ContentHandler CMOF_2_4_1_CONTENT_HANDLER = new RootXMLContentHandlerImpl("org.omg.mof.cmof_2_4_1", new String[]{"cmof", "xmi"}, "xmi", "http://www.omg.org/spec/MOF/20110701/cmof.xmi", null);
    private static final ContentHandler CMOF_2_5_CONTENT_HANDLER = new RootXMLContentHandlerImpl("org.omg.mof.cmof_2_5", new String[]{"cmof", "xmi"}, "xmi", "http://www.omg.org/spec/MOF/20131001/cmof.xmi", null);

    public static void initGlobalRegistries() {
        UMLResourcesUtil.initPackageRegistry(EPackage.Registry.INSTANCE);
        UMLResourcesUtil.initEPackageNsURIToProfileLocationMap(UMLPlugin.getEPackageNsURIToProfileLocationMap());
        UMLResourcesUtil.initURIConverterURIMap(URIConverter.URI_MAP);
        UMLResourcesUtil.initContentHandlerRegistry(ContentHandler.Registry.INSTANCE);
        UMLResourcesUtil.initResourceFactoryRegistry(Resource.Factory.Registry.INSTANCE);
    }

    public static void initLocalRegistries(ResourceSet resourceSet) {
        UMLResourcesUtil.initPackageRegistry(resourceSet.getPackageRegistry());
        UMLResourcesUtil.initEPackageNsURIToProfileLocationMap(UMLPlugin.getEPackageNsURIToProfileLocationMap());
        UMLResourcesUtil.initURIConverterURIMap(resourceSet.getURIConverter().getURIMap());
        UMLResourcesUtil.initContentHandlerRegistry(ContentHandler.Registry.INSTANCE);
        UMLResourcesUtil.initResourceFactoryRegistry(resourceSet.getResourceFactoryRegistry());
    }

    public static ResourceSet init(ResourceSet resourceSet) {
        UMLResourcesUtil.initGlobalRegistries();
        return UMLUtil.init((ResourceSet)resourceSet);
    }

    public static EPackage.Registry initPackageRegistry(EPackage.Registry packageRegistry) {
        packageRegistry.put((Object)"http://www.eclipse.org/emf/2002/Ecore", (Object)EcorePackage.eINSTANCE);
        packageRegistry.put((Object)"http://www.eclipse.org/uml2/4.0.0/Types", (Object)TypesPackage.eINSTANCE);
        packageRegistry.put((Object)"http://www.eclipse.org/uml2/5.0.0/Types", (Object)TypesPackage.eINSTANCE);
        packageRegistry.put((Object)"http://www.eclipse.org/uml2/2.0.0/UML", (Object)UMLPackage.eINSTANCE);
        packageRegistry.put((Object)"http://www.eclipse.org/uml2/2.1.0/UML", (Object)UMLPackage.eINSTANCE);
        packageRegistry.put((Object)"http://www.eclipse.org/uml2/3.0.0/UML", (Object)UMLPackage.eINSTANCE);
        packageRegistry.put((Object)"http://www.eclipse.org/uml2/4.0.0/UML", (Object)UMLPackage.eINSTANCE);
        packageRegistry.put((Object)"http://www.eclipse.org/uml2/5.0.0/UML", (Object)UMLPackage.eINSTANCE);
        packageRegistry.put((Object)"http://www.eclipse.org/uml2/schemas/Standard/1", (Object)StandardPackage.eINSTANCE);
        packageRegistry.put((Object)"http://www.eclipse.org/uml2/4.0.0/UML/Profile/L2", (Object)StandardPackage.eINSTANCE);
        packageRegistry.put((Object)"http://www.eclipse.org/uml2/4.0.0/UML/Profile/L3", (Object)StandardPackage.eINSTANCE);
        packageRegistry.put((Object)"http://www.eclipse.org/uml2/5.0.0/UML/Profile/Standard", (Object)StandardPackage.eINSTANCE);
        return packageRegistry;
    }

    public static Resource.Factory.Registry initResourceFactoryRegistry(Resource.Factory.Registry resourceFactoryRegistry) {
        Map extensionToFactoryMap = resourceFactoryRegistry.getExtensionToFactoryMap();
        extensionToFactoryMap.put("uml", UMLResource.Factory.INSTANCE);
        Map contentTypeToFactoryMap = resourceFactoryRegistry.getContentTypeToFactoryMap();
        contentTypeToFactoryMap.put("org.eclipse.uml2.uml_5_0_0", UMLResource.Factory.INSTANCE);
        return resourceFactoryRegistry;
    }

    public static ContentHandler.Registry initContentHandlerRegistry(ContentHandler.Registry contentHandlerRegistry) {
        ArrayList<ContentHandler> contentHandlers = (ArrayList<ContentHandler>)contentHandlerRegistry.get((Object)1000);
        if (contentHandlers == null || !contentHandlers.contains(XMI_CONTENT_HANDLER)) {
            contentHandlerRegistry.put(1000, XMI_CONTENT_HANDLER);
        }
        if ((contentHandlers = (List)contentHandlerRegistry.get((Object)0)) == null) {
            contentHandlers = new ArrayList<ContentHandler>();
            contentHandlerRegistry.put((Object)0, contentHandlers);
        }
        if (!contentHandlers.contains(UML2_5_0_0_CONTENT_HANDLER)) {
            contentHandlers.add(UML2_5_0_0_CONTENT_HANDLER);
        }
        if (!contentHandlers.contains(UML2_4_0_0_CONTENT_HANDLER)) {
            contentHandlers.add(UML2_4_0_0_CONTENT_HANDLER);
        }
        if (!contentHandlers.contains(UML2_3_0_0_CONTENT_HANDLER)) {
            contentHandlers.add(UML2_3_0_0_CONTENT_HANDLER);
        }
        if (!contentHandlers.contains(UML2_2_1_0_CONTENT_HANDLER)) {
            contentHandlers.add(UML2_2_1_0_CONTENT_HANDLER);
        }
        if (!contentHandlers.contains(UML2_2_0_0_CONTENT_HANDLER)) {
            contentHandlers.add(UML2_2_0_0_CONTENT_HANDLER);
        }
        if (!contentHandlers.contains(UML2_1_0_0_CONTENT_HANDLER)) {
            contentHandlers.add(UML2_1_0_0_CONTENT_HANDLER);
        }
        if (!contentHandlers.contains(OMG_2_5_CONTENT_HANDLER)) {
            contentHandlers.add(OMG_2_5_CONTENT_HANDLER);
        }
        if (!contentHandlers.contains(OMG_2_4_1_CONTENT_HANDLER)) {
            contentHandlers.add(OMG_2_4_1_CONTENT_HANDLER);
        }
        if (!contentHandlers.contains(OMG_2_4_CONTENT_HANDLER)) {
            contentHandlers.add(OMG_2_4_CONTENT_HANDLER);
        }
        if (!contentHandlers.contains(OMG_2_2_CONTENT_HANDLER)) {
            contentHandlers.add(OMG_2_2_CONTENT_HANDLER);
        }
        if (!contentHandlers.contains(OMG_2_1_1_CONTENT_HANDLER)) {
            contentHandlers.add(OMG_2_1_1_CONTENT_HANDLER);
        }
        if (!contentHandlers.contains(OMG_2_1_CONTENT_HANDLER)) {
            contentHandlers.add(OMG_2_1_CONTENT_HANDLER);
        }
        if (!contentHandlers.contains(CMOF_2_5_CONTENT_HANDLER)) {
            contentHandlers.add(CMOF_2_5_CONTENT_HANDLER);
        }
        if (!contentHandlers.contains(CMOF_2_4_1_CONTENT_HANDLER)) {
            contentHandlers.add(CMOF_2_4_1_CONTENT_HANDLER);
        }
        if (!contentHandlers.contains(CMOF_2_4_CONTENT_HANDLER)) {
            contentHandlers.add(CMOF_2_4_CONTENT_HANDLER);
        }
        if (!contentHandlers.contains(CMOF_2_0_CONTENT_HANDLER)) {
            contentHandlers.add(CMOF_2_0_CONTENT_HANDLER);
        }
        return contentHandlerRegistry;
    }

    public static Map<URI, URI> initURIConverterURIMap(Map<URI, URI> uriMap) {
        URI umlURI = UMLResourcesUtil.getBaseUMLURI();
        UMLResourcesUtil.mapURIs(uriMap, "platform:/plugin/org.eclipse.uml2.uml/model/", umlURI.appendSegment("model"), "org.eclipse.uml2.uml");
        URI umlResourcesURI = UMLResourcesUtil.getBaseUMLResourcesURI();
        UMLResourcesUtil.mapURIs(uriMap, "pathmap://UML_METAMODELS/", umlResourcesURI.appendSegment("metamodels"), "org.eclipse.uml2.uml.resources");
        UMLResourcesUtil.mapURIs(uriMap, "pathmap://UML_PROFILES/", umlResourcesURI.appendSegment("profiles"), "org.eclipse.uml2.uml.resources");
        UMLResourcesUtil.mapURIs(uriMap, "pathmap://UML_LIBRARIES/", umlResourcesURI.appendSegment("libraries"), "org.eclipse.uml2.uml.resources");
        return uriMap;
    }

    public static Map<String, URI> initEPackageNsURIToProfileLocationMap(Map<String, URI> ePackageNsURIToProfileLocationMap) {
        ePackageNsURIToProfileLocationMap.put("http://www.eclipse.org/uml2/5.0.0/UML/Profile/Standard", URI.createURI((String)"pathmap://UML_PROFILES/Standard.profile.uml#_0"));
        ePackageNsURIToProfileLocationMap.put("http://www.eclipse.org/uml2/schemas/Ecore/5", URI.createURI((String)"pathmap://UML_PROFILES/Ecore.profile.uml#_0"));
        ePackageNsURIToProfileLocationMap.put("http://www.eclipse.org/uml2/schemas/UML2/2", URI.createURI((String)"pathmap://UML_PROFILES/UML2.profile.uml#_0"));
        return ePackageNsURIToProfileLocationMap;
    }

    private static URI getBaseUMLURI() {
        URI result;
        URL resultURL = UMLUtil.class.getClassLoader().getResource(String.format("model/%s", "UML.ecore"));
        if (resultURL != null) {
            result = URI.createURI((String)resultURL.toExternalForm(), (boolean)true).trimSegments(2);
        } else {
            resultURL = UMLUtil.class.getResource("UMLUtil.class");
            String baseURL = resultURL.toExternalForm();
            int index = baseURL.lastIndexOf("/bin/");
            if (index != -1) {
                baseURL = baseURL.substring(0, index);
            }
            result = URI.createURI((String)baseURL, (boolean)true);
        }
        return result;
    }

    private static URI getBaseUMLResourcesURI() {
        URI result;
        URI umlMetamodel = URI.createURI((String)"pathmap://UML_METAMODELS/UML.metamodel.uml");
        URL resultURL = UMLResourcesUtil.class.getClassLoader().getResource(String.format("metamodels/%s", umlMetamodel.lastSegment()));
        if (resultURL != null) {
            result = URI.createURI((String)resultURL.toExternalForm(), (boolean)true).trimSegments(2);
        } else {
            resultURL = UMLResourcesUtil.class.getResource("UMLResourcesUtil.class");
            String baseURL = resultURL.toExternalForm();
            int index = baseURL.lastIndexOf("/bin/");
            if (index != -1) {
                baseURL = baseURL.substring(0, index);
            }
            result = URI.createURI((String)baseURL, (boolean)true);
        }
        return result;
    }

    private static void mapURIs(Map<URI, URI> uriMap, String uri, URI location, String pluginID) {
        URI prefix = URI.createURI((String)uri);
        if (!prefix.hasTrailingPathSeparator()) {
            prefix = prefix.appendSegment("");
        }
        if (!location.hasTrailingPathSeparator()) {
            location = location.appendSegment("");
        }
        uriMap.put(prefix, location);
        String folder = location.segment(location.segmentCount() - 2);
        String platformURI = String.format("%s/%s/", pluginID, folder);
        uriMap.put(URI.createPlatformPluginURI((String)platformURI, (boolean)true), location);
        uriMap.put(URI.createPlatformResourceURI((String)platformURI, (boolean)true), location);
    }
}

