/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.settings.model.extension.impl;

import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationData;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationDataProvider;
import org.eclipse.cdt.core.settings.model.extension.impl.CDataFactory;
import org.eclipse.cdt.core.settings.model.util.CDataSerializer;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class CDefaultConfigurationDataProvider
extends CConfigurationDataProvider {
    private static final String DEFAULT_STORAGE_ID = "defaultConfigurationDataProvider";

    @Override
    public CConfigurationData applyConfiguration(ICConfigurationDescription cfgDescription, ICConfigurationDescription baseCfgDescription, CConfigurationData baseData, IProgressMonitor monitor) throws CoreException {
        ICStorageElement el = this.getStorageElement(cfgDescription, true);
        CDataSerializer serializer = this.getDataSerializer();
        serializer.store(baseData, el);
        return baseData;
    }

    @Override
    public CConfigurationData createConfiguration(ICConfigurationDescription cfgDescription, ICConfigurationDescription baseCfgDescription, CConfigurationData baseData, boolean clone, IProgressMonitor monitor) throws CoreException {
        CDataFactory factory = this.getDataFactory();
        return factory.createConfigurationdata(cfgDescription.getId(), cfgDescription.getName(), baseData, clone);
    }

    @Override
    public CConfigurationData loadConfiguration(ICConfigurationDescription cfgDescription, IProgressMonitor monitor) throws CoreException {
        ICStorageElement el = this.getStorageElement(cfgDescription, false);
        if (el != null) {
            CDataSerializer serializer = this.getDataSerializer();
            CDataFactory factory = this.getDataFactory();
            try {
                return serializer.loadConfigurationData(factory, el);
            }
            catch (CoreException e) {
                if (cfgDescription.isPreferenceConfiguration()) {
                    return this.createPreferenceConfig(factory);
                }
                throw e;
            }
        }
        if (cfgDescription.isPreferenceConfiguration()) {
            return this.createPreferenceConfig(this.getDataFactory());
        }
        return null;
    }

    @Override
    public void removeConfiguration(ICConfigurationDescription cfgDescription, CConfigurationData data, IProgressMonitor monitor) {
    }

    protected CDataFactory getDataFactory() {
        return CDataFactory.getDefault();
    }

    protected CDataSerializer getDataSerializer() {
        return CDataSerializer.getDefault();
    }

    protected String getStorageId() {
        return DEFAULT_STORAGE_ID;
    }

    protected ICStorageElement getStorageElement(ICConfigurationDescription cfgDescription, boolean create) throws CoreException {
        return cfgDescription.getStorage(this.getStorageId(), create);
    }

    protected CConfigurationData createPreferenceConfig(CDataFactory factory) {
        return CDataUtil.createEmptyData(null, "preference", factory, true);
    }
}

