/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.migrator.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.cdo.internal.messages.Messages;
import org.eclipse.emf.cdo.internal.migrator.CDOMigratorUtil;
import org.eclipse.emf.codegen.ecore.genmodel.GenDelegationKind;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class MigrateAction
implements IObjectActionDelegate {
    private ISelection selection;

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        new Job(Messages.getString("MigrateAction_0")){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IFile file = MigrateAction.this.getFile();
                    if (file == null) {
                        MigrateAction.this.showMessage(Messages.getString("MigrateAction_1"), true);
                    } else {
                        GenModel genModel = MigrateAction.this.getGenModel(file);
                        if (genModel == null) {
                            MigrateAction.this.showMessage(Messages.getString("MigrateAction_2"), true);
                        } else {
                            GenDelegationKind featureDelegation = MigrateAction.this.getFeatureDelegation();
                            String msg = CDOMigratorUtil.adjustGenModel(genModel, featureDelegation);
                            if (msg == null) {
                                MigrateAction.this.showMessage(Messages.getString("MigrateAction_3"), false);
                            } else {
                                genModel.eResource().save(null);
                                MigrateAction.this.showMessage(String.valueOf(Messages.getString("MigrateAction_4")) + msg, false);
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    return new Status(4, "org.eclipse.emf.cdo.internal.migrator", Messages.getString("MigrateAction_6"), (Throwable)ex);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    protected GenDelegationKind getFeatureDelegation() {
        return GenDelegationKind.REFLECTIVE_LITERAL;
    }

    protected IFile getFile() {
        IFile file;
        Object element;
        if (this.selection instanceof IStructuredSelection && (element = ((IStructuredSelection)this.selection).getFirstElement()) instanceof IFile && "genmodel".equals((file = (IFile)element).getFileExtension())) {
            return file;
        }
        return null;
    }

    protected GenModel getGenModel(IFile file) {
        String path = file.getFullPath().toString();
        return CDOMigratorUtil.getGenModel(path);
    }

    protected void showMessage(final String msg, final boolean error) {
        try {
            Display display = PlatformUI.getWorkbench().getDisplay();
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (error) {
                            MessageDialog.openError((Shell)UIUtil.getShell(), (String)Messages.getString("MigrateAction_10"), (String)msg);
                        } else {
                            MessageDialog.openInformation((Shell)UIUtil.getShell(), (String)Messages.getString("MigrateAction_10"), (String)msg);
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
            });
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

