/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.log.stream;

import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.equinox.internal.log.stream.LogStreamProviderFactory;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;
import org.osgi.service.log.stream.LogStreamProvider;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class LogStreamManager
implements BundleActivator,
ServiceTrackerCustomizer<LogReaderService, AtomicReference<LogReaderService>>,
LogListener {
    private ServiceRegistration<LogStreamProvider> logStreamServiceRegistration;
    private LogStreamProviderFactory logStreamProviderFactory;
    private ServiceTracker<LogReaderService, AtomicReference<LogReaderService>> logReaderService;
    private BundleContext context;
    private final ReentrantLock eventProducerLock = new ReentrantLock();

    public void start(BundleContext bc) throws Exception {
        this.context = bc;
        this.logReaderService = new ServiceTracker(this.context, LogReaderService.class, (ServiceTrackerCustomizer)this);
        this.logReaderService.open();
        this.logStreamProviderFactory = new LogStreamProviderFactory(this.logReaderService);
        this.logStreamServiceRegistration = this.context.registerService(LogStreamProvider.class, (ServiceFactory)this.logStreamProviderFactory, null);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.logReaderService.close();
        this.logStreamServiceRegistration.unregister();
        this.logStreamServiceRegistration = null;
        this.logStreamProviderFactory.shutdownExecutor();
    }

    public AtomicReference<LogReaderService> addingService(ServiceReference<LogReaderService> reference) {
        AtomicReference<LogReaderService> tracked = new AtomicReference<LogReaderService>();
        this.modifiedService(reference, tracked);
        return tracked;
    }

    public void modifiedService(ServiceReference<LogReaderService> modifiedServiceRef, AtomicReference<LogReaderService> modifiedTracked) {
        this.eventProducerLock.lock();
        try {
            LogReaderService readerService;
            ServiceReference currentServiceRef = this.logReaderService.getServiceReference();
            if ((currentServiceRef == null || modifiedServiceRef.compareTo((Object)currentServiceRef) > 0) && (readerService = (LogReaderService)this.context.getService(modifiedServiceRef)) != null) {
                LogReaderService currentLogReader;
                AtomicReference currentTracked;
                if (modifiedTracked.get() == null) {
                    modifiedTracked.set(readerService);
                }
                if (currentServiceRef != null && (currentTracked = (AtomicReference)this.logReaderService.getService(currentServiceRef)) != null && (currentLogReader = (LogReaderService)currentTracked.get()) != null) {
                    currentLogReader.removeLogListener((LogListener)this);
                    this.context.ungetService(currentServiceRef);
                    currentTracked.set(null);
                }
                readerService.addLogListener((LogListener)this);
            }
        }
        finally {
            this.eventProducerLock.unlock();
        }
    }

    public void removedService(ServiceReference<LogReaderService> removedRef, AtomicReference<LogReaderService> removedTracked) {
        this.eventProducerLock.lock();
        try {
            AtomicReference currentTracked;
            ServiceReference currentRef;
            LogReaderService removedLogReader = removedTracked.get();
            if (removedLogReader != null) {
                removedLogReader.removeLogListener((LogListener)this);
                this.context.ungetService(removedRef);
                removedTracked.set(null);
            }
            if ((currentRef = this.logReaderService.getServiceReference()) != null && (currentTracked = (AtomicReference)this.logReaderService.getService(currentRef)) != null) {
                LogReaderService currentLogReader = (LogReaderService)currentTracked.get();
                if (currentLogReader == null) {
                    currentLogReader = (LogReaderService)this.context.getService(currentRef);
                    currentTracked.set(currentLogReader);
                }
                if (currentLogReader != null) {
                    currentLogReader.addLogListener((LogListener)this);
                }
            }
        }
        finally {
            this.eventProducerLock.unlock();
        }
    }

    public void logged(LogEntry entry) {
        this.logStreamProviderFactory.postLogEntry(entry);
    }
}

