/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.xml.pomeditor;

import org.apache.maven.project.MavenProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.m2e.editor.pom.MavenPomEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProviderExtension3;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.internal.contentoutline.ConfigurableContentOutlinePage;

class MavenStructuredSourceTextEditor
extends StructuredTextEditor {
    private final MavenPomEditor mavenPomEditor;
    private long fModificationStamp = -1L;
    private boolean oldDirty;

    MavenStructuredSourceTextEditor(MavenPomEditor mavenPomEditor) {
        this.mavenPomEditor = mavenPomEditor;
    }

    protected void updateModificationStamp() {
        IDocumentProvider p = this.getDocumentProvider();
        if (p == null) {
            return;
        }
        if (p instanceof IDocumentProviderExtension3) {
            this.fModificationStamp = p.getModificationStamp((Object)this.mavenPomEditor.getEditorInput());
        }
    }

    protected StructuredTextViewer createStructedTextViewer(Composite parent, IVerticalRuler verticalRuler, int styles) {
        return new MavenStructuredTextViewer(parent, verticalRuler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
    }

    protected void sanityCheckState(IEditorInput input) {
        IDocumentProvider p = this.getDocumentProvider();
        if (p == null) {
            return;
        }
        if (p instanceof IDocumentProviderExtension3) {
            IDocumentProviderExtension3 p3 = (IDocumentProviderExtension3)p;
            long stamp = p.getModificationStamp((Object)input);
            if (stamp != this.fModificationStamp) {
                this.fModificationStamp = stamp;
                if (!p3.isSynchronized((Object)input)) {
                    this.handleEditorInputChanged();
                }
            }
        } else {
            long stamp;
            if (this.fModificationStamp == -1L) {
                this.fModificationStamp = p.getSynchronizationStamp((Object)input);
            }
            if ((stamp = p.getModificationStamp((Object)input)) != this.fModificationStamp) {
                this.fModificationStamp = stamp;
                if (stamp != p.getSynchronizationStamp((Object)input)) {
                    this.handleEditorInputChanged();
                }
            }
        }
        this.updateState(this.getEditorInput());
        this.updateStatusField("ElementState");
    }

    public boolean isDirty() {
        boolean dirty = super.isDirty();
        if (this.oldDirty != dirty) {
            this.oldDirty = dirty;
            this.updatePropertyDependentActions();
        }
        return dirty;
    }

    public void dispose() {
        Object outlinePage = this.getAdapter(IContentOutlinePage.class);
        if (outlinePage instanceof ConfigurableContentOutlinePage) {
            ((ConfigurableContentOutlinePage)outlinePage).setEditorPart(null);
        }
        super.dispose();
    }

    protected class MavenStructuredTextViewer
    extends StructuredTextViewer
    implements IAdaptable {
        public MavenStructuredTextViewer(Composite parent, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, boolean showAnnotationsOverview, int styles) {
            super(parent, verticalRuler, overviewRuler, showAnnotationsOverview, styles);
        }

        public MavenProject getMavenProject() {
            return MavenStructuredSourceTextEditor.this.mavenPomEditor.getMavenProject();
        }

        public <T> T getAdapter(Class<T> adapter) {
            if (MavenProject.class.equals(adapter)) {
                return adapter.cast(this.getMavenProject());
            }
            return null;
        }
    }
}

