/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.sourcelookup.internal.launch;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.codec.digest.DigestUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.internal.index.IIndex;
import org.eclipse.m2e.core.internal.index.IndexedArtifactFile;
import org.eclipse.m2e.core.internal.index.nexus.CompositeIndex;
import org.eclipse.m2e.sourcelookup.internal.launch.MetaInfMavenScanner;

public class MavenArtifactIdentifier {
    private static final MetaInfMavenScanner<Properties> scanner = new MetaInfMavenScanner<Properties>(){

        @Override
        protected Properties visitFile(File file) throws IOException {
            Throwable throwable = null;
            Object var3_4 = null;
            try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));){
                return this.loadProperties(is);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        @Override
        protected Properties visitJarEntry(JarFile jar, JarEntry entry) throws IOException {
            Throwable throwable = null;
            Object var4_5 = null;
            try (InputStream is = jar.getInputStream(entry);){
                return this.loadProperties(is);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        private Properties loadProperties(InputStream is) throws IOException {
            Properties properties = new Properties();
            properties.load(is);
            return properties;
        }
    };

    public Collection<ArtifactKey> identify(File classesLocation) {
        Collection<ArtifactKey> classesArtifacts = this.identifyNexusIndexer(classesLocation);
        if (classesArtifacts == null) {
            classesArtifacts = this.identifyCentralSearch(classesLocation);
        }
        if (classesArtifacts == null) {
            classesArtifacts = this.scanPomProperties(classesLocation);
        }
        return classesArtifacts;
    }

    protected Collection<ArtifactKey> identifyNexusIndexer(File file) {
        if (!file.isFile()) {
            return null;
        }
        try {
            IndexedArtifactFile indexed2;
            IIndex index = MavenPlugin.getIndexManager().getAllIndexes();
            List<Object> identified = index instanceof CompositeIndex ? ((CompositeIndex)index).identifyAll(file) : ((indexed2 = index.identify(file)) != null ? Collections.singletonList(indexed2) : Collections.emptyList());
            for (IndexedArtifactFile indexed2 : identified) {
                if (indexed2.sourcesExists != 1) continue;
                return Collections.singleton(indexed2.getArtifactKey());
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return null;
    }

    protected Collection<ArtifactKey> identifyCentralSearch(File file) {
        if (!file.isFile()) {
            return null;
        }
        try {
            String sha1;
            Throwable throwable = null;
            Throwable throwable2 = null;
            try (FileInputStream fis = new FileInputStream(file);){
                sha1 = DigestUtils.sha1Hex((InputStream)fis);
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
            URL url = new URL("https://search.maven.org/solrsearch/select?q=1:" + sha1);
            throwable2 = null;
            Object var5_7 = null;
            try (InputStreamReader reader = new InputStreamReader(url.openStream(), StandardCharsets.UTF_8);){
                LinkedHashSet<ArtifactKey> result = new LinkedHashSet<ArtifactKey>();
                JsonObject container = (JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class);
                JsonArray docs = container.get("response").getAsJsonObject().get("docs").getAsJsonArray();
                for (JsonElement element : docs) {
                    JsonObject doc = element.getAsJsonObject();
                    String g = doc.get("g").getAsString();
                    String a = doc.get("a").getAsString();
                    String v = doc.get("v").getAsString();
                    result.add(new ArtifactKey(g, a, v, null));
                }
                Set<ArtifactKey> set = !result.isEmpty() ? Set.copyOf(result) : null;
                return set;
            }
            catch (Throwable throwable4) {
                if (throwable2 == null) {
                    throwable2 = throwable4;
                } else if (throwable2 != throwable4) {
                    throwable2.addSuppressed(throwable4);
                }
                throw throwable2;
            }
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public Collection<ArtifactKey> scanPomProperties(File classesLocation) {
        LinkedHashSet<ArtifactKey> artifacts = new LinkedHashSet<ArtifactKey>();
        for (Properties pomProperties : scanner.scan(classesLocation, "pom.properties")) {
            String groupId = pomProperties.getProperty("groupId");
            String artifactId = pomProperties.getProperty("artifactId");
            String version = pomProperties.getProperty("version");
            if (groupId == null || artifactId == null || version == null) continue;
            artifacts.add(new ArtifactKey(groupId, artifactId, version, null));
        }
        return Set.copyOf(artifacts);
    }
}

