/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.glazedlists.copy;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public final class ComparatorChain<T>
implements Comparator<T> {
    private final Comparator<T>[] comparators;

    public ComparatorChain(List<Comparator<T>> comparators) {
        this.comparators = comparators.toArray(new Comparator[comparators.size()]);
    }

    @Override
    public int compare(T alpha, T beta) {
        int i = 0;
        while (i < this.comparators.length) {
            int compareResult = this.comparators[i].compare(alpha, beta);
            if (compareResult != 0) {
                return compareResult;
            }
            ++i;
        }
        return 0;
    }

    public Comparator<T>[] getComparators() {
        return this.comparators;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComparatorChain that = (ComparatorChain)o;
        return Arrays.equals(this.comparators, that.comparators);
    }

    public int hashCode() {
        return 0;
    }
}

