/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.modelexplorer.actions;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.DiSashModelManager;
import org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.IOpenable;
import org.eclipse.papyrus.infra.core.sashwindows.di.service.IPageManager;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.views.modelexplorer.Activator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;

public class OpenWithMenu
extends ContributionItem
implements IWorkbenchContribution {
    private IServiceLocator serviceLocator;

    public OpenWithMenu() {
    }

    public OpenWithMenu(String id) {
        super(id);
    }

    public void fill(Menu menu, int index) {
        IPageManager pageManager;
        ISelectionService selectionService = (ISelectionService)this.serviceLocator.getService(ISelectionService.class);
        if (selectionService == null) {
            return;
        }
        ISelection currentSelection = selectionService.getSelection();
        if (!(currentSelection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)currentSelection;
        if (selection.isEmpty()) {
            return;
        }
        IWorkbenchPart part = (IWorkbenchPart)this.serviceLocator.getService(IWorkbenchPart.class);
        if (part == null) {
            return;
        }
        ServicesRegistry registry = (ServicesRegistry)part.getAdapter(ServicesRegistry.class);
        if (registry == null) {
            return;
        }
        try {
            pageManager = (IPageManager)registry.getService(IPageManager.class);
            if (pageManager == null) {
                return;
            }
        }
        catch (ServiceException ex) {
            return;
        }
        Iterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            Map editorIDs;
            IOpenable papyrusPage;
            final EObject selectedElement = EMFHelper.getEObject(iterator.next());
            if (selectedElement == null || (papyrusPage = (IOpenable)Platform.getAdapterManager().getAdapter((Object)selectedElement, IOpenable.class)) == null) continue;
            try {
                DiSashModelManager modelManager = (DiSashModelManager)registry.getService(DiSashModelManager.class);
                editorIDs = modelManager.getEditorIDsFor((Object)selectedElement);
            }
            catch (ServiceException ex) {
                Activator.log.error((Throwable)ex);
                return;
            }
            if (editorIDs == null || editorIDs.size() < 2) {
                return;
            }
            MenuItem openWith = new MenuItem(menu, 64);
            openWith.setText("Open with...");
            Menu subMenu = new Menu(menu);
            openWith.setMenu(subMenu);
            for (final Map.Entry editorID : editorIDs.entrySet()) {
                MenuItem gmfItem = new MenuItem(subMenu, 0);
                gmfItem.setText((String)editorID.getValue());
                gmfItem.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        pageManager.openPage((Object)selectedElement, (String)editorID.getKey());
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
            }
        }
    }

    public void initialize(IServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
    }
}

