/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.etfw.tau.selinst;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IFunctionDeclaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Selector {
    private final LinkedHashSet<String> routInc = new LinkedHashSet();
    private final LinkedHashSet<String> routEx = new LinkedHashSet();
    private final LinkedHashSet<String> fileInc = new LinkedHashSet();
    private final LinkedHashSet<String> fileEx = new LinkedHashSet();
    private final LinkedHashSet<String> instSec = new LinkedHashSet();
    private final String selString;

    public static String fixStars(String signature) {
        int star = signature.indexOf(42);
        while (star >= 1) {
            if (signature.charAt(star - 1) != '*') {
                signature = String.valueOf(signature.substring(0, star)) + " " + signature.substring(star);
                ++star;
            }
            star = signature.indexOf(42, star + 1);
        }
        return signature;
    }

    public static String getFullSigniture(IFunctionDeclaration fun) {
        String returntype = Selector.fixStars(fun.getReturnType());
        try {
            String signature = Selector.fixStars(fun.getSignature());
            return String.valueOf(returntype) + " " + signature + "#";
        }
        catch (CModelException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getRoutine(IFunctionDeclaration fun) {
        return "routine=\"" + Selector.getFullSigniture(fun) + "\"";
    }

    public Selector(String path) {
        this.selString = String.valueOf(path) + File.separator + "tau.selective";
        this.readSelFile();
    }

    public void addInst(HashSet<String> instlines) {
        this.instSec.addAll(instlines);
        this.writeSelFile();
    }

    public void clearFile(HashSet<String> remfile) {
        this.fileInc.removeAll(remfile);
        this.fileEx.removeAll(remfile);
        this.writeSelFile();
    }

    public void clearGenInst(HashSet<String> remlines) {
        try {
            Iterator<String> remit = remlines.iterator();
            HashSet<String> removethese = new HashSet<String>();
            String remtem = "";
            String remcan2 = "";
            while (remit.hasNext()) {
                remtem = remit.next();
                for (String remcan2 : this.instSec) {
                    if (remcan2.indexOf(remtem) != 0) continue;
                    removethese.add(remcan2);
                }
            }
            this.instSec.removeAll(removethese);
            this.writeSelFile();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void clearInstrumentSection(HashSet<String> elementNames) {
        Iterator<String> elementIt = elementNames.iterator();
        HashSet<String> toRemove = new HashSet<String>();
        String curElement = "";
        String curSelLine2 = "";
        while (elementIt.hasNext()) {
            curElement = elementIt.next();
            for (String curSelLine2 : this.instSec) {
                if (curSelLine2.indexOf(curElement) < 0) continue;
                toRemove.add(curSelLine2);
            }
        }
        this.instSec.removeAll(toRemove);
        this.writeSelFile();
    }

    public void clearRout(HashSet<String> remrouts) {
        this.routInc.removeAll(remrouts);
        this.routEx.removeAll(remrouts);
        this.writeSelFile();
    }

    public void excludeFile(HashSet<String> exfiles) {
        this.fileEx.addAll(exfiles);
        this.fileInc.removeAll(exfiles);
        this.writeSelFile();
    }

    public void excludeRout(HashSet<String> exrouts) {
        this.routEx.addAll(exrouts);
        this.routInc.removeAll(exrouts);
        this.writeSelFile();
    }

    public void includeFile(HashSet<String> incfiles) {
        this.fileInc.addAll(incfiles);
        this.fileEx.removeAll(incfiles);
        this.writeSelFile();
    }

    public void includeRout(HashSet<String> incrouts) {
        this.routInc.addAll(incrouts);
        this.routEx.removeAll(incrouts);
        this.writeSelFile();
    }

    private void readSelFile() {
        try {
            File selfile = new File(this.selString);
            if (!selfile.exists()) {
                return;
            }
            BufferedReader in = new BufferedReader(new FileReader(selfile));
            String ourline = in.readLine();
            while (ourline != null) {
                if (ourline.equals("BEGIN_EXCLUDE_LIST")) {
                    ourline = in.readLine();
                    while (!ourline.equals("END_EXCLUDE_LIST") && !ourline.equals(null)) {
                        this.routEx.add(ourline);
                        ourline = in.readLine();
                    }
                }
                if (ourline.equals("BEGIN_INCLUDE_LIST")) {
                    ourline = in.readLine();
                    while (!ourline.equals("END_INCLUDE_LIST") && !ourline.equals(null)) {
                        this.routInc.add(ourline);
                        ourline = in.readLine();
                    }
                }
                if (ourline.equals("BEGIN_FILE_INCLUDE_LIST")) {
                    ourline = in.readLine();
                    while (!ourline.equals("END_FILE_INCLUDE_LIST") && !ourline.equals(null)) {
                        this.fileInc.add(ourline);
                        ourline = in.readLine();
                    }
                }
                if (ourline.equals("BEGIN_FILE_EXCLUDE_LIST")) {
                    ourline = in.readLine();
                    while (!ourline.equals("END_FILE_EXCLUDE_LIST") && !ourline.equals(null)) {
                        this.fileEx.add(ourline);
                        ourline = in.readLine();
                    }
                }
                if (ourline.equals("BEGIN_INSTRUMENT_SECTION")) {
                    ourline = in.readLine();
                    while (!ourline.equals("END_INSTRUMENT_SECTION") && !ourline.equals(null)) {
                        this.instSec.add(ourline);
                        ourline = in.readLine();
                    }
                }
                ourline = in.readLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void remInst(HashSet<String> remlines) {
        this.instSec.removeAll(remlines);
        this.writeSelFile();
    }

    private void writeSelFile() {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(this.selString));
            out.write("#Generated by the TAU PTP plugin\n");
            if (this.routEx.size() > 0) {
                out.write("BEGIN_EXCLUDE_LIST\n");
                Iterator routExIt = this.routEx.iterator();
                while (routExIt.hasNext()) {
                    out.write(String.valueOf((String)routExIt.next()) + "\n");
                }
                out.write("END_EXCLUDE_LIST\n");
            }
            if (this.routInc.size() > 0) {
                out.write("BEGIN_INCLUDE_LIST\n");
                Iterator routIncIt = this.routInc.iterator();
                while (routIncIt.hasNext()) {
                    out.write(String.valueOf((String)routIncIt.next()) + "\n");
                }
                out.write("END_INCLUDE_LIST\n");
            }
            if (this.fileEx.size() > 0) {
                out.write("BEGIN_FILE_EXCLUDE_LIST\n");
                Iterator fileExIt = this.fileEx.iterator();
                while (fileExIt.hasNext()) {
                    out.write(String.valueOf((String)fileExIt.next()) + "\n");
                }
                out.write("END_FILE_EXCLUDE_LIST\n");
            }
            if (this.fileInc.size() > 0) {
                out.write("BEGIN_FILE_INCLUDE_LIST\n");
                Iterator fileIncIt = this.fileInc.iterator();
                while (fileIncIt.hasNext()) {
                    out.write(String.valueOf((String)fileIncIt.next()) + "\n");
                }
                out.write("END_FILE_INCLUDE_LIST\n");
            }
            if (this.instSec.size() > 0) {
                out.write("BEGIN_INSTRUMENT_SECTION\n");
                Iterator instSecIt = this.instSec.iterator();
                while (instSecIt.hasNext()) {
                    out.write(String.valueOf((String)instSecIt.next()) + "\n");
                }
                out.write("END_INSTRUMENT_SECTION\n");
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

