/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.junit.internal.configuration.reader;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.reddeer.junit.Activator;
import org.eclipse.reddeer.junit.configuration.RedDeerConfigurationException;
import org.eclipse.reddeer.junit.internal.configuration.reader.ConfigurationReader;
import org.eclipse.reddeer.junit.requirement.ConfigurableRequirement;
import org.eclipse.reddeer.junit.requirement.Requirement;
import org.eclipse.reddeer.junit.requirement.RequirementException;
import org.eclipse.reddeer.junit.requirement.configuration.RequirementConfiguration;
import org.json.JSONObject;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class JSONConfigurationReader
implements ConfigurationReader {
    private ObjectMapper mapper = new ObjectMapper();

    @Override
    public List<RequirementConfiguration> loadConfigurations(File file) {
        if (!file.exists()) {
            throw new RedDeerConfigurationException("Provided configuration file " + file.getAbsolutePath() + "does not exist.");
        }
        String fileName = file.getName().toLowerCase();
        try {
            JsonNode root;
            if (fileName.endsWith(".json")) {
                root = this.mapper.readTree(file);
            } else if (fileName.endsWith(".yaml") || fileName.endsWith(".yml")) {
                root = this.mapper.readTree(this.convertYamlToJson(file));
            } else {
                throw new RedDeerConfigurationException("Only JSON and YAML files are supported");
            }
            return this.getConfigurationsFromRootNode(root);
        }
        catch (IOException ioe) {
            throw new RedDeerConfigurationException("Could not create configurations for requirements from file " + file.getAbsolutePath() + " due to IO exception", ioe);
        }
        catch (ClassNotFoundException cnfe) {
            throw new RedDeerConfigurationException("Could not create configurations due to not existing declared configuration class in configuration file " + file.getAbsolutePath(), cnfe);
        }
        catch (ClassCastException cce) {
            throw new RedDeerConfigurationException("Could not create configurations for requirements from file " + file.getAbsolutePath() + "due to class hierarchy. Class specified in file is not descendant of requirement configuration", cce);
        }
    }

    private String convertYamlToJson(File file) throws FileNotFoundException {
        Map map = (Map)new Yaml((BaseConstructor)new SafeConstructor()).load((Reader)new FileReader(file));
        JSONObject jsonObject = new JSONObject(map);
        return jsonObject.toString();
    }

    private List<RequirementConfiguration> getConfigurationsFromRootNode(JsonNode root) throws ClassNotFoundException, JsonParseException, JsonMappingException, IOException {
        ArrayList<RequirementConfiguration> configs = new ArrayList<RequirementConfiguration>();
        Iterator it = root.fields();
        while (it.hasNext()) {
            Map.Entry node = (Map.Entry)it.next();
            String annotationClassString = (String)node.getKey();
            String requirementClassString = annotationClassString.substring(0, annotationClassString.lastIndexOf("."));
            Requirement<Annotation> requirement = this.getRequirement(requirementClassString);
            if (ConfigurableRequirement.class.isAssignableFrom(requirement.getClass())) {
                ConfigurableRequirement configurableRequirement = (ConfigurableRequirement)requirement;
                CollectionType typeReference = TypeFactory.defaultInstance().constructCollectionType(List.class, configurableRequirement.getConfigurationClass());
                List resultList = (List)this.mapper.readValue(((JsonNode)node.getValue()).toString(), (JavaType)typeReference);
                configs.addAll(resultList);
                continue;
            }
            throw new RequirementException("Annotation class for requirement " + requirement + " located in " + "configuration file is not encapsulated in configurable requirement. Annotation class" + " must belong to a requirement implementing ConfigurableRequirement interface");
        }
        return configs;
    }

    private Requirement<Annotation> getRequirement(String className) {
        List<Requirement<Annotation>> requirements = Activator.getRequirements();
        for (Requirement<Annotation> req : requirements) {
            if (!req.getClass().getName().equals(className)) continue;
            return req;
        }
        throw new RequirementException(String.valueOf(className) + " is not registered via extension point " + "org.eclipse.reddeer.junit.requirement");
    }
}

