/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.useractions.files.uda;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rse.core.model.IPropertySet;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.internal.useractions.UserActionsIcon;
import org.eclipse.rse.internal.useractions.files.uda.UDSubstListFiles;
import org.eclipse.rse.internal.useractions.files.uda.UDSubstListFolders;
import org.eclipse.rse.internal.useractions.files.uda.UDTypesEditPaneFiles;
import org.eclipse.rse.internal.useractions.ui.SystemCmdSubstVarList;
import org.eclipse.rse.internal.useractions.ui.uda.ISystemUDAEditPaneHoster;
import org.eclipse.rse.internal.useractions.ui.uda.ISystemUDTreeView;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDAResources;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDActionElement;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDActionManager;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDActionSubsystem;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDBaseManager;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDTypeEditPane;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDTypeElement;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDTypeManager;
import org.eclipse.rse.services.clientserver.FileTypeMatcher;
import org.eclipse.rse.shells.ui.RemoteCommandHelpers;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCmdSubSystem;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class UDActionSubsystemFiles
extends SystemUDActionSubsystem {
    public static final String NO_EXTENSION_PLACEHOLDER = ".null";
    private static DateFormat dateFormatter;
    private FileTypeMatcher fileTypeMatcher;
    private static final String[] DOMAINS;
    public static final int DOMAIN_FOLDER = 0;
    public static final int DOMAIN_FILE = 1;
    protected static final String[][] FILE_ACTIONS;
    protected static final String[][] FOLDER_ACTIONS;
    protected static final String[][] IBM_DEFAULT_FOLDERTYPES;
    protected static final String[][] IBM_DEFAULT_FILETYPES;
    protected String[] DOMAIN_NAME_STRING = new String[2];
    protected String[] DOMAIN_NEWNAME_STRING = new String[2];

    static {
        DOMAINS = new String[]{"Folder", "File"};
        FILE_ACTIONS = new String[][]{{"java", "false", "true", "false", "CLASS", "java ${resource_name_root}"}, {"javac", "true", "false", "true", "JAVA", "javac -deprecation -classpath . ${resource_name}"}, {"jar", "true", "false", "true", "ALL", "jar -cvf classes.jar ${resource_name}"}, {"unjar", "false", "true", "false", "JAR ZIP", "jar -xf ${resource_name}"}, {"gmake", "true", "false", "false", "GNU_MAKEFILE", "gmake -f ${resource_name}"}, {"make", "true", "false", "false", "MAKEFILE", "make -f ${resource_name}"}};
        FOLDER_ACTIONS = new String[][]{{"javac", "true", "false", "true", "javac -deprecation -classpath . *.java"}, {"jar", "true", "false", "true", "jar cvf classes.jar *.class"}};
        IBM_DEFAULT_FOLDERTYPES = new String[][]{{"ALL", "*"}};
        IBM_DEFAULT_FILETYPES = new String[][]{{"ALL", "*"}, {"C", "c,h,i"}, {"C_COMPILABLE", "c"}, {"CPP", "cpp,cxx,hpp,ipp"}, {"CPP_COMPILABLE", "cpp,cxx"}, {"CLASS", "class"}, {"CSS", "css"}, {"EAR", "ear"}, {"EXE", "exe,bat,cmd"}, {"GRAPHIC", "bmp,gif,jpg"}, {"GNU_MAKEFILE", "GNUMakefile.null"}, {"HTML", "htm, html"}, {"JAVA", "java"}, {"JAVASCRIPT", "js"}, {"JAR", "jar"}, {"JARZIP", "jar,zip"}, {"JSP", "jsp"}, {"MAKEFILE", "makefile.null, mak"}, {"NONE", "null"}, {"PERL", "pl"}, {"PROFILE", "profile"}, {"PYTHON", "py"}, {"SHELL ", "csh, ksh, sh"}, {"SQLJ", "sqlj"}, {"WAR", "war"}, {"WEB", "css, htm, html, js, jsp"}, {"TAR", "tar"}, {"ZIP", "zip"}};
    }

    public UDActionSubsystemFiles() {
        this.DOMAIN_NAME_STRING[0] = SystemUDAResources.RESID_UDA_FILES_DOMAIN_FOLDER;
        this.DOMAIN_NAME_STRING[1] = SystemUDAResources.RESID_UDA_FILES_DOMAIN_FILE;
        this.DOMAIN_NEWNAME_STRING[0] = SystemUDAResources.RESID_UDA_FILES_DOMAIN_NEWFOLDER;
        this.DOMAIN_NEWNAME_STRING[1] = SystemUDAResources.RESID_UDA_FILES_DOMAIN_NEWFILE;
    }

    protected boolean doActionsMigration(ISystemProfile profile, String oldRelease) {
        return false;
    }

    protected boolean doTypesMigration(ISystemProfile profile, String oldRelease) {
        return false;
    }

    public String internalGetSubstitutionValue(SystemUDActionElement currentAction, String subvar, Object selectedObject) {
        return UDActionSubsystemFiles.getUniversalSubstitutionValue(currentAction, subvar, selectedObject);
    }

    public static String getUniversalSubstitutionValue(SystemUDActionElement currentAction, String subvar, Object selectedObject) {
        IRemoteFile selectedFile = (IRemoteFile)selectedObject;
        if (subvar.equals("${resource_date}")) {
            Date lmd;
            if (dateFormatter == null) {
                dateFormatter = new SimpleDateFormat("yyyy.MM.dd hh:mm:ss z");
            }
            if ((lmd = selectedFile.getLastModifiedDate()) != null) {
                return dateFormatter.format(lmd);
            }
            return "not available";
        }
        if (subvar.equals("${resource_name_root}")) {
            String name = selectedFile.getName();
            int dotIdx = name.lastIndexOf(46);
            if (dotIdx == 0) {
                return "";
            }
            if (dotIdx > 0) {
                return name.substring(0, dotIdx);
            }
            return name;
        }
        if (subvar.equals("${resource_name_ext}")) {
            String name = selectedFile.getName();
            int dotIdx = name.lastIndexOf(46);
            if (dotIdx == 0) {
                if (name.length() == 1) {
                    return "";
                }
                return name.substring(1);
            }
            if (dotIdx > 0) {
                return name.substring(dotIdx + 1);
            }
            return "";
        }
        if (subvar.equals("${container_name}")) {
            String fullpath = selectedFile.getParentPath();
            if (fullpath == null || fullpath.length() == 0) {
                return "";
            }
            IRemoteFileSubSystem rfss = UDActionSubsystemFiles.getFileSubSystem(selectedObject);
            if (rfss == null) {
                return "";
            }
            char sep = rfss.getParentRemoteFileSubSystemConfiguration().getSeparatorChar();
            int idx = fullpath.lastIndexOf(sep);
            if (idx >= 0) {
                return fullpath.substring(idx + 1);
            }
            return "";
        }
        if (subvar.equals("${container_path}")) {
            return selectedFile.getParentPath();
        }
        if (subvar.equals("${resource_path_root}")) {
            String name = selectedFile.getAbsolutePath();
            if (name != null) {
                if (name.startsWith("/") || name.startsWith("\\")) {
                    return name.substring(0, 1);
                }
                int idx = name.indexOf(":\\");
                if (idx > 0) {
                    return name.substring(0, idx + 2);
                }
            }
            return "";
        }
        if (subvar.equals("${resource_path_drive}")) {
            int idx;
            String name = selectedFile.getAbsolutePath();
            if (name != null && name.length() > 1 && (idx = name.indexOf(58)) > 0) {
                return name.substring(0, idx);
            }
            return "";
        }
        return null;
    }

    protected String getTypesDelimiter() {
        return ",";
    }

    protected boolean runCommand(Shell shell, SystemUDActionElement action, String cmdString, IRemoteCmdSubSystem cmdSubSystem, Object context, Viewer viewer) {
        return UDActionSubsystemFiles.runUniversalCommand(shell, cmdString, cmdSubSystem, context);
    }

    public static boolean runUniversalCommand(Shell shell, String cmdString, IRemoteCmdSubSystem cmdSubSystem, Object context) {
        String path = RemoteCommandHelpers.getWorkingDirectory((IRemoteFile)((IRemoteFile)context));
        boolean ok = RemoteCommandHelpers.runUniversalCommand((Shell)shell, (String)cmdString, (String)path, (IRemoteCmdSubSystem)cmdSubSystem);
        return ok;
    }

    public boolean supportsTypes() {
        return true;
    }

    public boolean supportsTypes(int domain) {
        return domain != 0;
    }

    public boolean supportsDomains() {
        return true;
    }

    public int getSingleDomain(SystemUDBaseManager docManager) {
        if (docManager != this.getUDTypeManager()) {
            return -1;
        }
        return 1;
    }

    public SystemUDTypeEditPane getCustomUDTypeEditPane(ISystemUDAEditPaneHoster parent, ISystemUDTreeView tv) {
        return new UDTypesEditPaneFiles(this, parent, tv);
    }

    public SystemUDTypeElement[] primeDefaultTypes(SystemUDTypeManager typeMgr) {
        Vector v = new Vector();
        UDActionSubsystemFiles.primeDefaultUniversalTypes(typeMgr, v);
        this.primeAdditionalDefaultUniversalTypes(typeMgr, v);
        SystemUDTypeElement[] typesArray = new SystemUDTypeElement[v.size()];
        int idx = 0;
        while (idx < typesArray.length) {
            typesArray[idx] = (SystemUDTypeElement)v.elementAt(idx);
            ++idx;
        }
        return typesArray;
    }

    public static SystemUDTypeElement[] primeDefaultUniversalTypes(SystemUDTypeManager typeMgr, Vector vectorOfTypes) {
        SystemUDTypeElement ft;
        Vector<SystemUDTypeElement> v = vectorOfTypes;
        if (v == null) {
            v = new Vector<SystemUDTypeElement>();
        }
        int i = 0;
        while (i < IBM_DEFAULT_FOLDERTYPES.length) {
            ft = typeMgr.addType(0, IBM_DEFAULT_FOLDERTYPES[i][0]);
            if (ft != null) {
                v.addElement(ft);
                ft.setTypes(IBM_DEFAULT_FOLDERTYPES[i][1]);
            }
            ++i;
        }
        i = 0;
        while (i < IBM_DEFAULT_FILETYPES.length) {
            ft = typeMgr.addType(1, IBM_DEFAULT_FILETYPES[i][0]);
            if (ft != null) {
                v.addElement(ft);
                ft.setTypes(IBM_DEFAULT_FILETYPES[i][1]);
            }
            ++i;
        }
        if (vectorOfTypes != null) {
            return null;
        }
        SystemUDTypeElement[] typesArray = new SystemUDTypeElement[v.size()];
        int idx = 0;
        while (idx < typesArray.length) {
            typesArray[idx] = (SystemUDTypeElement)v.elementAt(idx);
            ++idx;
        }
        return typesArray;
    }

    protected void primeAdditionalDefaultUniversalTypes(SystemUDTypeManager typeMgr, Vector vectorOfTypes) {
    }

    public SystemUDActionElement[] primeDefaultActions(SystemUDActionManager actionMgr, ISystemProfile profile) {
        Vector v = new Vector();
        UDActionSubsystemFiles.primeDefaultUniversalActions(actionMgr, profile, v);
        this.primeAdditionalDefaultUniversalActions(actionMgr, profile, v);
        SystemUDActionElement[] actionArray = new SystemUDActionElement[v.size()];
        int idx = 0;
        while (idx < actionArray.length) {
            actionArray[idx] = (SystemUDActionElement)v.elementAt(idx);
            ++idx;
        }
        return actionArray;
    }

    public static SystemUDActionElement[] primeDefaultUniversalActions(SystemUDActionManager actionMgr, ISystemProfile profile, Vector vectorOfActions) {
        SystemUDActionElement newAction;
        String osType;
        String userDefinedActionPropertySetName;
        IPropertySet userDefinedActionPropertySet;
        Vector<SystemUDActionElement> v = vectorOfActions;
        if (v == null) {
            v = new Vector<SystemUDActionElement>();
        }
        if ((userDefinedActionPropertySet = profile.getPropertySet(userDefinedActionPropertySetName = "UserActoins." + (osType = actionMgr.getActionSubSystem().getOSType()) + "." + actionMgr.getDocumentRootTagName())) == null) {
            userDefinedActionPropertySet = profile.createPropertySet(userDefinedActionPropertySetName);
            userDefinedActionPropertySet.addProperty("name", "User Actions - " + osType);
            userDefinedActionPropertySet.addProperty("release", "7.5");
            userDefinedActionPropertySet.addProperty("uda_root", actionMgr.getDocumentRootTagName());
        }
        int domain = 1;
        int idx = 0;
        while (idx < FILE_ACTIONS.length) {
            newAction = actionMgr.addAction(profile, FILE_ACTIONS[idx][0], domain);
            v.addElement(newAction);
            newAction.setCommand(FILE_ACTIONS[idx][5]);
            newAction.setPrompt(true);
            newAction.setRefresh(FILE_ACTIONS[idx][1].equals("true"));
            newAction.setShow(true);
            newAction.setSingleSelection(FILE_ACTIONS[idx][2].equals("true"));
            newAction.setCollect(FILE_ACTIONS[idx][3].equals("true"));
            newAction.setFileTypes(UDActionSubsystemFiles.convertStringToArray(FILE_ACTIONS[idx][4]));
            ++idx;
        }
        domain = 0;
        idx = 0;
        while (idx < FOLDER_ACTIONS.length) {
            newAction = actionMgr.addAction(profile, FOLDER_ACTIONS[idx][0], domain);
            v.addElement(newAction);
            newAction.setCommand(FOLDER_ACTIONS[idx][4]);
            newAction.setPrompt(true);
            newAction.setRefresh(FOLDER_ACTIONS[idx][1].equals("true"));
            newAction.setShow(true);
            newAction.setSingleSelection(FOLDER_ACTIONS[idx][2].equals("true"));
            newAction.setCollect(FOLDER_ACTIONS[idx][3].equals("true"));
            newAction.setFileTypes(new String[]{"ALL"});
            ++idx;
        }
        if (vectorOfActions != null) {
            return null;
        }
        SystemUDActionElement[] actionArray = new SystemUDActionElement[v.size()];
        int idx2 = 0;
        while (idx2 < actionArray.length) {
            actionArray[idx2] = (SystemUDActionElement)v.elementAt(idx2);
            ++idx2;
        }
        return actionArray;
    }

    protected void primeAdditionalDefaultUniversalActions(SystemUDActionManager actionMgr, ISystemProfile profile, Vector vectorOfActions) {
    }

    public boolean restoreDefaultType(SystemUDTypeElement element, int domain, String typeName) {
        boolean ok = UDActionSubsystemFiles.restoreUniversalDefaultType(element, domain, typeName);
        if (!ok) {
            ok = this.restoreAdditionalDefaultType(element, domain, typeName);
        }
        return ok;
    }

    public static boolean restoreUniversalDefaultType(SystemUDTypeElement element, int domain, String typeName) {
        boolean ok = false;
        String[][] typesArray = IBM_DEFAULT_FILETYPES;
        if (domain == 0) {
            typesArray = IBM_DEFAULT_FOLDERTYPES;
        }
        int match = -1;
        int idx = 0;
        while (match == -1 && idx < typesArray.length) {
            if (typeName.equals(typesArray[idx][0])) {
                match = idx;
            }
            ++idx;
        }
        if (match != -1) {
            element.setName(typesArray[match][0]);
            element.setTypes(typesArray[match][1]);
            ok = true;
        }
        return ok;
    }

    protected boolean restoreAdditionalDefaultType(SystemUDTypeElement element, int domain, String typeName) {
        return false;
    }

    public boolean restoreDefaultAction(SystemUDActionElement element, int domain, String typeName) {
        boolean ok = UDActionSubsystemFiles.restoreUniversalDefaultAction(element, domain, typeName);
        if (!ok) {
            ok = this.restoreAdditionalDefaultAction(element, domain, typeName);
        }
        return ok;
    }

    public static boolean restoreUniversalDefaultAction(SystemUDActionElement element, int domain, String actionName) {
        boolean ok = false;
        String[][] actionsArray = FILE_ACTIONS;
        if (domain == 0) {
            actionsArray = FOLDER_ACTIONS;
        }
        int match = -1;
        int idx = 0;
        while (match == -1 && idx < actionsArray.length) {
            if (actionName.equals(actionsArray[idx][0])) {
                match = idx;
            }
            ++idx;
        }
        if (match != -1) {
            element.setName(actionsArray[match][0]);
            element.setPrompt(true);
            element.setRefresh(actionsArray[match][1].equals("true"));
            element.setShow(true);
            element.setSingleSelection(actionsArray[match][2].equals("true"));
            element.setCollect(actionsArray[match][3].equals("true"));
            if (domain == 0) {
                element.setFileTypes(new String[]{"ALL"});
                element.setCommand(actionsArray[match][4]);
            } else {
                element.setFileTypes(UDActionSubsystemFiles.convertStringToArray(actionsArray[match][4]));
                element.setCommand(actionsArray[match][5]);
            }
            ok = true;
        }
        return ok;
    }

    protected boolean restoreAdditionalDefaultAction(SystemUDActionElement element, int domain, String actionName) {
        return false;
    }

    protected static String[] convertStringToArray(String string) {
        StringTokenizer tokens = new StringTokenizer(string);
        Vector<String> v = new Vector<String>();
        while (tokens.hasMoreTokens()) {
            v.addElement(tokens.nextToken());
        }
        String[] strings = new String[v.size()];
        int idx = 0;
        while (idx < strings.length) {
            strings[idx] = (String)v.elementAt(idx);
            ++idx;
        }
        return strings;
    }

    public boolean getWorkingOfflineMode() {
        return false;
    }

    public SystemCmdSubstVarList getActionSubstVarList(int actionDomainType) {
        if (actionDomainType == 0) {
            return UDSubstListFolders.getInstance();
        }
        if (actionDomainType == 1) {
            return UDSubstListFiles.getInstance();
        }
        return null;
    }

    protected boolean meetsSelection(SystemUDActionElement action, IStructuredSelection selection, int domainType) {
        if (domainType == 0) {
            return true;
        }
        String[] unresolvedActionTypes = action.getFileTypes();
        if (unresolvedActionTypes == null || unresolvedActionTypes.length == 0) {
            return true;
        }
        if (unresolvedActionTypes[0].equals("ALL")) {
            return true;
        }
        String[] actionTypes = this.resolveTypes(unresolvedActionTypes, domainType);
        this.fileTypeMatcher = null;
        if (domainType == 1) {
            if (this.fileTypeMatcher == null) {
                this.fileTypeMatcher = new FileTypeMatcher(null, this.getSubsystem().getSubSystemConfiguration().isCaseSensitive());
            }
            this.fileTypeMatcher.setTypesAndNames(actionTypes);
        }
        Iterator elements = selection.iterator();
        Object element = null;
        while (elements.hasNext()) {
            element = elements.next();
            IRemoteFile file = element;
            boolean foundMatch = false;
            if (domainType == 0) {
                if (file.isDirectory()) {
                    foundMatch = true;
                }
            } else if (this.fileTypeMatcher.matches(file.getName())) {
                foundMatch = true;
            }
            if (foundMatch) continue;
            return false;
        }
        return true;
    }

    protected boolean isMatch(Object actionType, Object selectedObject, int domainType) {
        return true;
    }

    protected int getDomainFromSelection(IStructuredSelection selection) {
        int domain = -1;
        Iterator elements = selection.iterator();
        if (elements.hasNext()) {
            IRemoteFile currFile = (IRemoteFile)elements.next();
            domain = currFile.isDirectory() ? 0 : 1;
        }
        return domain;
    }

    public int getMaximumDomain() {
        return 1;
    }

    public String[] getDomainNames() {
        return DOMAINS;
    }

    public String[] getXlatedDomainNames() {
        return this.DOMAIN_NAME_STRING;
    }

    public String[] getXlatedDomainNewNames() {
        return this.DOMAIN_NEWNAME_STRING;
    }

    public String[] getXlatedDomainNewTypeNames() {
        return this.DOMAIN_NEWNAME_STRING;
    }

    public Image getDomainImage(int domain) {
        if (domain == 0) {
            return RSEUIPlugin.getDefault().getImage("org.eclipse.rse.ui.systemfolderIcon");
        }
        if (domain == 1) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
        }
        return null;
    }

    public Image getDomainNewImage(int domain) {
        if (domain == 0) {
            return RSEUIPlugin.getDefault().getImage("org.eclipse.rse.ui.newfolder_wizIcon");
        }
        if (domain == 1) {
            return RSEUIPlugin.getDefault().getImage("org.eclipse.rse.ui.newfile_wizIcon");
        }
        return null;
    }

    public Image getDomainNewTypeImage(int domain) {
        return UserActionsIcon.USERTYPE_NEW.getImage();
    }

    protected String getNewNodeTypeLabel() {
        return SystemUDAResources.RESID_UDA_FILES_NEWNODE_LABEL;
    }
}

