/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.xalan.debugger;

import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xalan.templates.ElemVariable;
import org.apache.xpath.VariableStack;
import org.apache.xpath.objects.XNodeSet;
import org.apache.xpath.objects.XObject;
import org.eclipse.wst.xsl.jaxp.debug.debugger.Variable;
import org.eclipse.wst.xsl.xalan.debugger.XalanStyleFrame;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

public class XalanVariable
extends Variable
implements Comparable {
    private final Log log = LogFactory.getLog(XalanVariable.class);
    private final ElemVariable elemVariable;
    private final VariableStack varStack;
    private int stackFrame;
    private XObject xobject;

    public XalanVariable(XalanStyleFrame xalanStyleFrame, VariableStack varStack, String scope, int slotNumber, ElemVariable elemVariable) {
        super(XalanVariable.getName(elemVariable, scope, xalanStyleFrame), scope, slotNumber + varStack.getStackFrame());
        this.elemVariable = elemVariable;
        this.varStack = varStack;
        this.stackFrame = varStack.getStackFrame();
        try {
            this.xobject = this.getXObject();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static String getName(ElemVariable elemVariable, String scope, XalanStyleFrame xalanStyleFrame) {
        String name = elemVariable.getName().getLocalName();
        String systemId = elemVariable.getStylesheet().getSystemId();
        if ("G".equals(scope) && systemId != null) {
            int index = systemId.lastIndexOf(47);
            name = index > 0 ? String.valueOf(name) + " (" + systemId.substring(index + 1) + ")" : String.valueOf(name) + " (" + systemId + ")";
        }
        return name;
    }

    public String getType() {
        String value = "unknown";
        if (this.xobject != null) {
            int xalanType = this.xobject.getType();
            switch (xalanType) {
                case 600: {
                    value = "unresolved";
                    break;
                }
                case 4: {
                    value = "nodeset";
                    break;
                }
                case 1: {
                    value = "boolean";
                    break;
                }
                case 2: {
                    value = "number";
                    break;
                }
                case 0: {
                    value = "unknown";
                    break;
                }
                default: {
                    value = "string";
                }
            }
        }
        return value;
    }

    public String getValue() {
        String value = "???";
        try {
            this.xobject = this.getXObject();
            if (this.xobject != null) {
                int xalanType = this.xobject.getType();
                switch (xalanType) {
                    case 600: {
                        value = "";
                        break;
                    }
                    case 4: {
                        XNodeSet xns = (XNodeSet)this.xobject;
                        if (xns.nodelist().getLength() > 0) {
                            value = this.convertNode(xns);
                            break;
                        }
                        value = "<EMPTY NODESET>";
                        break;
                    }
                    default: {
                        value = this.xobject.toString();
                        break;
                    }
                }
            }
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        return value;
    }

    private String convertNode(XNodeSet xns) throws TransformerException {
        NodeList nodeList = xns.nodelist();
        String value = this.processNodeList(nodeList);
        return value;
    }

    private String processNodeList(NodeList nodeList) {
        String value = "";
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (node != null) {
                short nodeType = node.getNodeType();
                if (node.getNodeType() == 1) {
                    value = this.createElement(value, node);
                }
                if (nodeType == 8) {
                    value = String.valueOf(value) + "<!-- " + node.getNodeValue() + " -->";
                }
                if (nodeType == 7) {
                    ProcessingInstruction pi = (ProcessingInstruction)node;
                    value = String.valueOf(value) + "<?" + pi.getData() + " ?>";
                }
            }
            ++i;
        }
        return value;
    }

    private String createElement(String value, Node node) {
        value = String.valueOf(value) + "<";
        if (node.getNodeName() != null) {
            value = String.valueOf(value) + node.getNodeName();
            if (node.hasAttributes()) {
                NamedNodeMap attr = node.getAttributes();
                value = String.valueOf(value) + this.buildAttributes(attr);
            }
            value = String.valueOf(value) + ">";
            if (node.getNodeValue() != null) {
                value = String.valueOf(value) + node.getNodeValue();
            }
        }
        if (node.hasChildNodes()) {
            value = String.valueOf(value) + this.processNodeList(node.getChildNodes());
        }
        value = String.valueOf(value) + "</" + node.getNodeName() + ">";
        return value;
    }

    private String buildAttributes(NamedNodeMap attributes) {
        String value = " ";
        int a = 0;
        while (a < attributes.getLength()) {
            Attr attribute = (Attr)attributes.item(a);
            value = String.valueOf(value) + attribute.getName() + "=\"" + attribute.getValue() + "\" ";
            ++a;
        }
        value = String.valueOf(value) + " ";
        return value;
    }

    private XObject getXObject() throws TransformerException {
        XObject xvalue = this.elemVariable.getIsTopLevel() ? this.varStack.elementAt(this.slotNumber) : this.varStack.getLocalVariable(this.elemVariable.getIndex(), this.stackFrame);
        return xvalue;
    }

    public int compareTo(Object arg0) {
        XalanVariable xvar = (XalanVariable)arg0;
        int comp = xvar.stackFrame - this.stackFrame;
        if (comp == 0) {
            comp = this.slotNumber - xvar.slotNumber;
        }
        return comp;
    }
}

