/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.CompoundElement;
import org.eclipse.xtext.Condition;
import org.eclipse.xtext.EnumRule;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Group;
import org.eclipse.xtext.Parameter;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.TypeRef;
import org.eclipse.xtext.XtextPackage;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xtext.ConditionEvaluator;
import org.eclipse.xtext.xtext.OriginalElement;
import org.eclipse.xtext.xtext.OriginalGrammar;
import org.eclipse.xtext.xtext.RuleFilter;
import org.eclipse.xtext.xtext.RuleNames;
import org.eclipse.xtext.xtext.RuleWithParameterValues;
import org.eclipse.xtext.xtext.UsedRulesFinder;

public class FlattenedGrammarAccess {
    private final Grammar flattenedGrammar;

    public FlattenedGrammarAccess(RuleNames names, RuleFilter filter) {
        Grammar grammar = names.getContextGrammar();
        Grammar flattenedGrammar = this.copy(grammar);
        flattenedGrammar.setName(grammar.getName());
        LinkedHashMap<RuleWithParameterValues, AbstractRule> origToCopy = new LinkedHashMap<RuleWithParameterValues, AbstractRule>();
        List<AbstractRule> copies = this.copyRuleStubs(names, origToCopy, filter.getRules(grammar), filter.isDiscardRuleTypeRef());
        Iterables.addAll(flattenedGrammar.getRules(), copies);
        Multimap<TerminalRule, AbstractRule> calledFrom = this.copyRuleBodies(copies, origToCopy);
        this.setHiddenTokens(flattenedGrammar, grammar, origToCopy);
        this.markAsFragment(calledFrom);
        if (filter.isDiscardUnreachableRules()) {
            HashSet<AbstractRule> usedRules = new HashSet<AbstractRule>();
            if (!filter.isDiscardTerminalRules()) {
                usedRules.addAll(GrammarUtil.allTerminalRules(flattenedGrammar));
            }
            UsedRulesFinder finder = new UsedRulesFinder(usedRules);
            finder.compute(flattenedGrammar);
            flattenedGrammar.getRules().retainAll(usedRules);
        }
        this.flattenedGrammar = flattenedGrammar;
        new OriginalGrammar(grammar).attachToEmfObject((Notifier)flattenedGrammar);
    }

    private void setHiddenTokens(Grammar copy, Grammar orig, Map<RuleWithParameterValues, AbstractRule> origToCopy) {
        if (orig == null) {
            copy.setDefinesHiddenTokens(true);
            return;
        }
        if (!orig.isDefinesHiddenTokens()) {
            this.setHiddenTokens(copy, (Grammar)IterableExtensions.head(orig.getUsedGrammars()), origToCopy);
            return;
        }
        copy.setDefinesHiddenTokens(true);
        Iterables.addAll(copy.getHiddenTokens(), (Iterable)Lists.transform(orig.getHiddenTokens(), hidden -> (AbstractRule)origToCopy.get(new RuleWithParameterValues((AbstractRule)hidden))));
    }

    private void markAsFragment(Multimap<TerminalRule, AbstractRule> calledFrom) {
        FluentIterable.from((Iterable)calledFrom.keySet()).filter(it -> !it.isFragment()).filter(it -> this.allAreTerminalRules(calledFrom.get(it))).filter(it -> !((Grammar)it.eContainer()).getHiddenTokens().contains(it)).forEach(it -> it.setFragment(true));
    }

    private Multimap<TerminalRule, AbstractRule> copyRuleBodies(List<AbstractRule> copies, final Map<RuleWithParameterValues, AbstractRule> origToCopy) {
        final HashMultimap calledFrom = HashMultimap.create();
        for (final AbstractRule copy : copies) {
            AbstractRule orig = RuleWithParameterValues.getOriginalRule(copy);
            final Set<Parameter> paramValues = RuleWithParameterValues.getParamValues(copy);
            EcoreUtil.Copier copier = new EcoreUtil.Copier(){

                protected void copyReference(EReference eReference, EObject eObject, EObject copyEObject) {
                    if (XtextPackage.Literals.RULE_CALL__RULE == eReference) {
                        RuleCall origRuleCall = (RuleCall)eObject;
                        RuleCall copyRuleCall = (RuleCall)copyEObject;
                        AbstractRule calledCopy = (AbstractRule)origToCopy.get(new RuleWithParameterValues(origRuleCall.getRule(), this.getParameterConfig(origRuleCall, copyRuleCall)));
                        copyRuleCall.setRule(calledCopy);
                        if (calledCopy instanceof TerminalRule) {
                            calledFrom.put((Object)((TerminalRule)calledCopy), (Object)copy);
                        }
                    } else {
                        super.copyReference(eReference, eObject, copyEObject);
                    }
                }

                Set<Parameter> getParameterConfig(RuleCall origRuleCall, RuleCall copyRuleCall) {
                    if (origRuleCall.getArguments().isEmpty()) {
                        return Collections.emptySet();
                    }
                    return IterableExtensions.toSet((Iterable)Iterables.transform((Iterable)IterableExtensions.filter(origRuleCall.getArguments(), it -> this.evaluate(it.getValue())), it -> it.getParameter()));
                }

                protected void copyContainment(EReference eReference, EObject eObject, EObject copyEObject) {
                    if (XtextPackage.Literals.RULE_CALL__ARGUMENTS == eReference || XtextPackage.Literals.GROUP__GUARD_CONDITION == eReference) {
                        return;
                    }
                    super.copyContainment(eReference, eObject, copyEObject);
                }

                public EObject copy(EObject eObject) {
                    CompoundElement compoundElement;
                    EList<AbstractElement> elements;
                    if (eObject instanceof Group && ((Group)eObject).getGuardCondition() != null && !this.evaluate(((Group)eObject).getGuardCondition())) {
                        return null;
                    }
                    EObject result = super.copy(eObject);
                    if (result instanceof CompoundElement && (elements = (compoundElement = (CompoundElement)result).getElements()).size() == 1) {
                        if (!compoundElement.isFirstSetPredicated() && !compoundElement.isPredicated()) {
                            AbstractElement firstElement = (AbstractElement)elements.get(0);
                            this.mergeCardinalities(firstElement, compoundElement);
                            this.mergePredicates(firstElement, compoundElement);
                            return firstElement;
                        }
                        AbstractElement firstElement = (AbstractElement)elements.get(0);
                        this.mergePredicates(compoundElement, firstElement);
                        firstElement.setFirstSetPredicated(false);
                        firstElement.setPredicated(false);
                    }
                    if (eObject instanceof AbstractElement) {
                        AbstractElement abstractElement = (AbstractElement)eObject;
                        if (!abstractElement.eClass().equals(result.eClass())) {
                            throw new IllegalStateException("copy is: '" + result.eClass().getName() + "' but original was: '" + abstractElement.eClass().getName() + "'");
                        }
                        new OriginalElement(abstractElement).attachToEmfObject((Notifier)result);
                    }
                    return result;
                }

                void mergePredicates(AbstractElement into, AbstractElement from) {
                    if (from.isPredicated()) {
                        into.setPredicated(true);
                        into.setFirstSetPredicated(false);
                    } else if (!into.isPredicated() && from.isFirstSetPredicated()) {
                        into.setFirstSetPredicated(true);
                    }
                }

                void mergeCardinalities(AbstractElement into, AbstractElement from) {
                    String resultCardinality;
                    String c1 = into.getCardinality();
                    String c2 = from.getCardinality();
                    String string = resultCardinality = c1 == null ? c2 : c1;
                    if ("*".equals(c1) || "*".equals(c2) || "+".equals(c1) && "?".equals(c2) || "?".equals(c1) && "+".equals(c2)) {
                        resultCardinality = "*";
                    }
                    into.setCardinality(resultCardinality);
                }

                boolean evaluate(Condition condition) {
                    return new ConditionEvaluator(paramValues).evaluate(condition);
                }
            };
            AbstractElement copiedBody = (AbstractElement)copier.copy((EObject)orig.getAlternatives());
            copier.copyReferences();
            copy.setAlternatives(copiedBody);
            if (!(orig instanceof ParserRule)) continue;
            ParserRule castedCopy = (ParserRule)copy;
            if (!((ParserRule)orig).isDefinesHiddenTokens()) continue;
            castedCopy.setDefinesHiddenTokens(true);
            for (AbstractRule rule : ((ParserRule)orig).getHiddenTokens()) {
                AbstractRule copiedTerminalRule = origToCopy.get(new RuleWithParameterValues(rule));
                castedCopy.getHiddenTokens().add((Object)copiedTerminalRule);
                calledFrom.put((Object)((TerminalRule)copiedTerminalRule), (Object)castedCopy);
            }
        }
        return calledFrom;
    }

    private TypeRef copyTypeRef(TypeRef ref) {
        if (ref == null) {
            return null;
        }
        TypeRef copy = this.copy(ref);
        copy.setClassifier(ref.getClassifier());
        return copy;
    }

    private List<AbstractRule> copyRuleStubs(RuleNames names, Map<RuleWithParameterValues, AbstractRule> origToCopy, List<AbstractRule> rulesToCopy, boolean discardTypeRef) {
        ArrayList<AbstractRule> result = new ArrayList<AbstractRule>();
        for (AbstractRule rule : rulesToCopy) {
            AbstractRule copy;
            String ruleName = names.getAntlrRuleName(rule);
            if (rule instanceof ParserRule) {
                EList<Parameter> params = ((ParserRule)rule).getParameters();
                if (params.isEmpty()) {
                    copy = this.copy((ParserRule)rule);
                    copy.setName(ruleName);
                    copy.setFragment(((ParserRule)rule).isFragment());
                    copy.setWildcard(((ParserRule)rule).isWildcard());
                    if (!discardTypeRef) {
                        copy.setType(this.copyTypeRef(((ParserRule)rule).getType()));
                    }
                    this.attachTo(copy, rule, origToCopy);
                    result.add(copy);
                    continue;
                }
                IterableExtensions.forEach((Iterable)Sets.powerSet((Set)ImmutableSet.copyOf(params)), (parameterConfig, i) -> {
                    RuleWithParameterValues parameterValues = new RuleWithParameterValues(rule, (Set<Parameter>)parameterConfig);
                    ParserRule copy = this.copy((ParserRule)rule);
                    copy.setName(names.getAntlrRuleName(rule, (int)i));
                    copy.setFragment(((ParserRule)rule).isFragment());
                    copy.setWildcard(((ParserRule)rule).isWildcard());
                    if (!discardTypeRef) {
                        copy.setType(this.copyTypeRef(((ParserRule)rule).getType()));
                    }
                    origToCopy.put(parameterValues, copy);
                    parameterValues.attachToEmfObject((Notifier)copy);
                    result.add(copy);
                });
                continue;
            }
            if (rule instanceof TerminalRule) {
                TerminalRule orig = (TerminalRule)rule;
                copy = this.copy(orig);
                copy.setName(ruleName);
                copy.setFragment(orig.isFragment());
                this.attachTo(copy, orig, origToCopy);
                result.add(copy);
                continue;
            }
            if (!(rule instanceof EnumRule)) continue;
            EnumRule copy2 = this.copy((EnumRule)rule);
            copy2.setName(ruleName);
            this.attachTo(copy2, rule, origToCopy);
            result.add(copy2);
        }
        return result;
    }

    private AbstractRule attachTo(AbstractRule copy, AbstractRule orig, Map<RuleWithParameterValues, AbstractRule> origToCopy) {
        RuleWithParameterValues parameterValues = new RuleWithParameterValues(orig);
        parameterValues.attachToEmfObject((Notifier)copy);
        return origToCopy.put(parameterValues, copy);
    }

    private boolean allAreTerminalRules(Collection<AbstractRule> callers) {
        return IterableExtensions.forall(callers, it -> it instanceof TerminalRule);
    }

    private <T extends EObject> T copy(T t) {
        return (T)EcoreUtil.create((EClass)t.eClass());
    }

    public static FlattenedGrammarAccess findInEmfObject(Notifier emfObject) {
        for (Adapter adapter : emfObject.eAdapters()) {
            if (!(adapter instanceof FlattenedGrammarAccessAdapter)) continue;
            return ((FlattenedGrammarAccessAdapter)adapter).get();
        }
        return null;
    }

    public static FlattenedGrammarAccess removeFromEmfObject(Notifier emfObject) {
        EList adapters = emfObject.eAdapters();
        for (int i = 0; i < adapters.size(); ++i) {
            Adapter adapter = (Adapter)adapters.get(i);
            if (!(adapter instanceof FlattenedGrammarAccessAdapter)) continue;
            return ((FlattenedGrammarAccessAdapter)((Object)emfObject.eAdapters().remove(i))).get();
        }
        return null;
    }

    public void attachToEmfObject(Notifier emfObject) {
        if (FlattenedGrammarAccess.findInEmfObject(emfObject) != null) {
            throw new IllegalStateException("The given EMF object already contains an adapter for FlattenedGrammarAccess");
        }
        emfObject.eAdapters().add((Object)new FlattenedGrammarAccessAdapter(this));
    }

    public Grammar getFlattenedGrammar() {
        return this.flattenedGrammar;
    }

    public static class FlattenedGrammarAccessAdapter
    extends AdapterImpl {
        private FlattenedGrammarAccess element;

        public FlattenedGrammarAccessAdapter(FlattenedGrammarAccess element) {
            this.element = element;
        }

        public FlattenedGrammarAccess get() {
            return this.element;
        }

        public boolean isAdapterForType(Object object) {
            return object == FlattenedGrammarAccess.class;
        }
    }
}

