/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.databinding;

import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.jface.util.Util;
import org.eclipse.xwt.XWT;
import org.eclipse.xwt.databinding.Event;
import org.eclipse.xwt.databinding.EventListener;
import org.eclipse.xwt.databinding.EventManager;

public abstract class XWTObservableValue
extends AbstractObservableValue
implements IObserving {
    private Object observed;
    private Class<?> valueType;
    private EventManager eventManager;
    private EventListener eventListener;
    private String path;
    private boolean updating = false;

    public XWTObservableValue(Class<?> valueType, Object observed, String path) {
        super(XWT.getRealm());
        this.valueType = valueType;
        this.observed = observed;
        this.path = path;
        this.init();
    }

    private void init() {
        if (this.eventListener == null) {
            this.eventListener = new EventListener(){

                @Override
                public void handleEvent(Event evt) {
                    if (!XWTObservableValue.this.updating) {
                        final ValueDiff diff = Diffs.createValueDiff((Object)evt.getOldValue(), (Object)evt.getNewValue());
                        XWTObservableValue.this.getRealm().exec(new Runnable(){

                            @Override
                            public void run() {
                                XWTObservableValue.this.fireValueChange(diff);
                            }
                        });
                    }
                }
            };
        }
        this.eventManager = EventManager.getEventManager(this.observed, this.getRealm());
        this.eventManager.addEventListener(this.path, this.eventListener);
    }

    public Object getObserved() {
        return this.observed;
    }

    protected void doSetValue(Object value) {
        Object oldValue;
        this.updating = true;
        value = this.convert((oldValue = this.doGetValue()) == null ? null : oldValue.getClass(), value);
        if (!Util.equals((Object)oldValue, (Object)value)) {
            this.doSetApprovedValue(value);
            this.fireValueChange(Diffs.createValueDiff((Object)oldValue, (Object)value));
            this.eventManager.dispatchEvent(new Event(this.observed, oldValue, value, this.getPath()));
        }
        this.updating = false;
    }

    protected Object convert(Class type, Object value) {
        if (value != null) {
            if (type != null && type.isEnum() && value instanceof String) {
                return Enum.valueOf(type, (String)value);
            }
            IConverter c = XWT.findConvertor(value.getClass(), this.getValueType());
            if (c != null) {
                return c.convert(value);
            }
        }
        return value;
    }

    protected abstract void doSetApprovedValue(Object var1);

    protected Object doGetValue() {
        return this.observed;
    }

    public Class<?> getValueType() {
        return this.valueType;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }
}

